#ifndef _pmap_h_

#define _pmap_h_
#include <stdio.h>	/* FILE */

#ifdef PG_PVM
#include "pg_proto.h"
#endif

#define PVIOCHECK FALSE	/* checking for maximal channels per processor (MNVM) */

#define MAXINT  0x7fffffff

#ifndef FALSE
#define FALSE 0
#define TRUE 1
#endif

#define START 0		/* node all the task desire to place at start time at */
#define NTASKperHOST 16	/* process-wasting for pseudo-distributed mapping >=2 */

#define vypis(A,B) fprintf(stderr,A,B)	/* to get into /tmp/pvml.uid */
#define SUFF ".grp"
#define PREF "o"
#define GROUP "pmapgrp"	/* all parallel working processes */
#define GROUP1 "pmap1grp"	/* auxiliary group for redundant processes */
#define ex(A) {ok=FALSE; return(A);}
extern char *argv0;		/* Program name */
#define EXM {printf("%s: No free memory!\n",argv0); exit(1);}
#define EXF {printf("%s: Internal fatal error!\n",argv0); exit(1);}
extern int toupper(int i);
#define GETY {int i='Y'; /*i=getchar();*/ if(toupper(i)!='Y')ex(2); printf("%c\n",i);}
/* #define PRINTY * if overwriting of temp files should be reported */

#define cprintf(s1,s2) {if(color)printf("%c[7m",'\33');printf(s1,s2); \
 if(color)printf("%c[0m",'\33');}

#ifdef MAX_PATH_LENGTH
#define MAXBUFF MAX_PATH_LENGTH
#else
#define MAXBUFF 512
#endif
#define MXCOLMN 80 /* columns in display (xterm... & view_text_widget) */
#define MXLINES 24 /* lines  -//-  */


#ifdef PG_PVM
 extern char *Hname();
 /*
 #define _PG_start() if(me>=0){char nm[8];sprintf(nm,"%s",Hname());pg_start(nm);}
 #define _PG_end() if(me>=0){char nm[8];sprintf(nm,"%s",Hname());pg_end(nm);}
 */
 #define _PG_start() pg_start("work")
 #define _PG_end() pg_end("work")

 #define PG_start(A) if(me>=0)pg_start(A)
 #define PG_end(A) if(me>=0)pg_end(A)
 #define PG_Result(A,B,C) { pg_start("coltim");Result(A,B,C);pg_end("coltim");}
#else
 #define _PG_start()
 #define _PG_end()
 #define PG_start(A)
 #define PG_end(A)
 #define PG_Result Result
#endif


extern int hwt,swt,cht;		/* actual table sizes */
extern int sumload;		/* computational load sum */
extern float timeconsum;		/* consumed time */
extern int fixed;		/* fix-placed task number */
extern int start;		/* start node */
extern int alpha,beta;		/* weight multiplicators (alpha for communications)*/
extern int dist,nghbr;		/* average HW distantion ,max.neighbourhood */
extern int iter;		/* number of iterations */
extern int diverg;		/* divergence (for equivalent results) */
extern int averspeed;	/* average "speed", in time needed for computing an unit */
extern int *He, *Hg, (*Cg)[3], *Sg, *Loc, *Load, *pvi, *pvo;
extern char buff[];	/* working buffer */
extern char *nout;		/* Result file name */
extern char *version;
extern char *grpname;		/* GRP-file name */
extern char *appname;		/* Application name */
extern int arg4, arg5;		/* command line auxiliary parameters */
extern char mode,modeGRP;	/* mapping mode:0,1,2,3,H,D,B,F,S,A */
#define MODEC "01234DBFHSA"	/* A=all */
#define MODECT 10
#define MODEDEF 'd'		/* default mode : lower case ! */
extern FILE *fi,*fo,*gfo;
extern char *BL, *NBL;		/* Back Line, no Back Line */
extern int scroll;		/* can TERM scroll-up ? ->  #lines */
extern int color;		/* can TERM print in color ? */
extern int grpsavRe;		/* should be results saved? */
extern int grpfound;		/* new or old fashion input file? */
extern int Xstop;		/* signalling from X-interface */
extern int Xexit;		/* signalling from X-interface */
extern int XshowView;		/* signalling to X-interface */
extern int NewSeed;		/* global for restarting : X-initializing */
extern int gred;		/* running from GRED ? */
extern int npvm,ok;		/* #number of PVM hosts, should be mapping done ? */
extern int nptsk,me;		/* #number of parallel tasks,instance number */
extern int sumspeed, hgrd;	/* do get HgTables from alive PVM */
extern void *malloc(unsigned size), *realloc(void *P, unsigned size);
extern void free(void *P);

extern int Adapt();
extern void Animat(int ii);
extern int CollectLoc(int mycost, int th, int it);
extern int CollectTime(int myt);
extern int Comm();
extern void Diffu(char mode);
extern void FindHZ();
extern int FindNghbr();
extern int GRPread();
extern int GRPreadArg(int argc, char *argv[]);
extern int GRPsave();
extern void GRPflushResult(FILE *gf, float ii, int cc, char *mm);
extern int GRPtest();
extern int xGRPusePVM();
extern void GetData();
extern int GetHgInfo();
extern int GetHgTables(char *taskname);
extern char *GetProcName(int i);
extern int GetScroll();
extern void Setgnout(int argc, char **argv);
extern void Greedy0();
extern void Greedy1();
extern void Greedy2();
extern void Greedy3();
extern void Greedy4();
extern int HWread(char sw);
extern void Hme();
extern void HmeFinish();
extern double Imb();
extern int ImbAbs();
extern void KillGroup();
extern int ProbeKill();
extern void SendKill();
extern void Main1(int argc, char *argv[]);
extern void Main2(char *argv[]);
extern int Move(int tsk, int newl, int really);
extern int NoPVMrunning();
extern void PrintTime();
extern void Printline(char c);
extern int Rand(int range);
extern int ReadArg(int argc, char *argv[]);
extern int ReadInt();
extern int ReadTime();
extern int RecvStartLoc(int *rep);
extern void ReallocLoad();
extern void ReorganizeHW();
extern void Result(char *mm, char *ss, char *abi);
extern int SWread(char *name);
extern int SWtestHW();
extern void SendLoc(int cost, int it);
extern void SendTime(int t);
extern void ShowLoad(int ii);
extern void SpawnAdded(char *taskname, int rea);
extern void SpreadData();
extern void SpreadStartLoc(int rep, int it);
extern void SynchData(int tsk, int tgt);
extern void SimAnn();
extern void SetLoad();
extern int SAcollectLoc(int mycost, int *map);
extern int SAfindWho();
extern void SAgetCross(int *map);
extern void SAgetLoc(int who, int *map);
extern void SArecvT(double *max, double *min);
extern void SAsendCross(int who, int *map);
extern int SAsendLoc(int cost);
extern void SAspreadT(double max, double min);
extern int SAsynchro(double *T, int R);
extern void TestRand(int turn, int e);
extern void SAready(int it);
extern int SAwhoisReady(int a, int *m, int th);
extern void SA_HME_deleteReady();
extern void View_hw(char * tx, int wait); 
extern void CheckXshowView(); 
extern int FilterTrace(char *iname, char *pname, char *oname,
		       int (*Cg)[3], int *Sg, char *swn);
extern int Tgetchar(int t, char c);

#endif
