/* other small functions for pmap.c & xpmap.c */

#include "pmap.h"
#include <string.h>
#include <sys/times.h>
#include <limits.h>
#define MNVM 2256	/* i/o ports limit  */
/* PVIOCHECK TRUE/FALSE	: for MNVM=2256 : Greedy4: 27.183s/21.600s */
			/*		  Greedy3:  5.650s/ 0.033s */
			/*		  Greedy2:  6.750s/ 0.017s */
			/*		  Greedy1:  7.083s/ 0.017s */

void ReallocLoad()
{
if((Load = (int *) realloc((void *)Load, hwt*sizeof(int)))==NULL)EXM
#if PVIOCHECK
if((pvi  = (int *) realloc((void *)pvi,  hwt*sizeof(int)))==NULL)EXM
if((pvo  = (int *) realloc((void *)pvo,  hwt*sizeof(int)))==NULL)EXM
#endif
}
  
/*******************/
static int ReadIntEnd(char jj)
{
int sign,i,c;
sign=1;
if (jj =='0')
{c = getc(fi); while ((c < '0' || c > '9') && c>0)
  {if(c=='-')sign=-1;else sign=1; c = getc(fi);}
   if (c == EOF) return(-1);
} else c = jj;
   i = c - '0'; c = getc(fi);
   while  (c >= '0' && c <= '9') {i = (i * 10) + c - '0';c = getc(fi);}
   return(i*sign);
   }

/*******************/
int ReadInt() { return(ReadIntEnd('0')); } 

/**************************************************************************/
int GetScroll() /* can modify BL ! */
{
int i,len,k,kk,s=0; char *tx=NULL, *tx1="xterm", *tx2="vt220", *tx3=":li#";
extern char *getenv(const char *name);

tx=getenv("TERM"); color=TRUE;
if(tx!=NULL)
  if (strncmp(tx1,tx,strlen(tx1))==0 || strncmp(tx2,tx,strlen(tx2))==0)
    if((tx=getenv("TERMCAP"))==NULL) return(24); else {
 len=strlen(tx); kk=strlen(tx3); i=0;
 while(i++<len) if (tx[i]==tx3[0]) {
   for(k=1; k<kk && tx[i+k]==tx3[k]; k++);
   if(k == kk) {i +=k; while(i<len && tx[i]>='0' && tx[i]<='9')
     s=10*s+tx[i++]-'0'; }
 }
}
if(s==0) { BL=NBL; color=FALSE;}
return(s);
}

/*****************************************************************************/
int Adapt()
/* priemerny comm.cost = priem.pocet kanalov * pr.vzdialenost * pr.mohutnost */
/*                           (cht/swt)   * (SUMdist/hwt/hwt') * (SUMcost/cht)*/
/* = (SUMcost*SUMdist)/(hwt*(hwt-1)*swt)				     */
/* priemerny imbalance prispevok = SUMload/swt * AVERAGEspeed */
{
extern int toupper(int i);
int i,j;
float a,b,d;

mode=toupper(mode); /* default 'd' is lower case */
for(i=0; i<=MODECT; i++) if(mode==MODEC[i]) i=MODECT+2; /* +A */
if(i==MODECT+1) {cprintf("Bad mode specified: %c\n",mode); ex(2)}
j = 1;
for (dist = i = 0; i < hwt; i++) for (j = 0; j < hwt; j++) dist += Hg[i*hwt+j];
d = dist; if(hwt>1) d /= (hwt-1); d /= hwt; dist = d + 1;
for (j = i = 0; i < cht; i++) j += Cg[i][2];
b = j * d; a = averspeed*sumload;  /* do kriza */
if (a > 0 && b > 0) { if (a > b) { a /= b; b = 1;}
			else 	 { b /= a; a = 1;}
		    }
else a = b = 1; /* What else can I do ? */
alpha = a * arg4; beta = b; iter = 7*swt; iter /= 2; diverg = 30;
iter /= arg5; if(mode=='D') iter /=4; if(mode=='F') iter /=2;
if (arg4 > 1 || arg5 > 1) printf(" [COMMx%d ITER:%d]",arg4,arg5);
return(0);}

/*************************** TIME MEASURING **********************************/
/* function times() returns CPU times spent by process in ticks on all UNIXs */
/* function clock() is machine dependent : SUN-OS - long, user+system, us    */
/* (and starts counting after 1-st call) :SOLARIS - clock_t, user+sys, us    */
/*					 : LINUX  - clock_t, CPU,  ! ticks ! */
/* function time() returns time since 1970 ...				     */

#ifndef HZ	/* ticks per second */
#ifdef CLK_TCK
#define HZ CLK_TCK
#else
/*	#ifdef CLOCK_PER_SECOND		// <time.h> = 1.000.000, for clock() //
	#define HZ CLOCKS_PER_SECOND
	#else
*/
#define DEF_CLK_HZ
#endif
#endif
static long tick;		/* last read time */
static int hz=0;		/* ticks per second 0==not measured yet */
/*******************/	/* function "clock()" is machine dependent */

/*******************/
void FindHZ()
{
if(hz==0)
{
#define MS 1000000
      
#ifndef HZ
long tim,ut;		/* last read time : tim in ms, ut in ticks/tickperms */
long uto, timo;
int i,j,h;
struct tms tms;
double g;

hz=100; /* default */
timo = clock(); times(&tms);
uto=tms.tms_utime+tms.tms_stime; i=uto*MS; i/=hz;	
TestRand(56789,0);
tim = clock(); times(&tms);
ut=tms.tms_utime+tms.tms_stime; j=ut*MS; j/=hz;

if (tim<=0) printf(" -> HZ=???\n");
else {	h=ut-uto; h *=MS; h /= tim-timo; g = h; g /=hz;
	if ((g>1.01)||(g<0.99)) {
	  hz = h;
	  printf("tick:\tclock:\tutime:\n\t[us]\t[us]\n");
	  printf("%d\t%d\t%d\n",uto,timo,i);
	  printf("%d\t%d\t%d\n",ut,tim,j);
	  printf("-> HZ=%d  err=%.2f%%\n",hz,(g-1)*100);
	}
}

#else

/* extern long sysconf(); */
hz = HZ;

#endif
}
}

/*******************/
int ReadTime()		/* updates tick variable, return spent time in [ms] */
{
struct tms tm;
int u;
u=tick; times(&tm); tick=tm.tms_utime; /* +tm.tms_stime; */
u=tick - u; u *= 1000; u /= hz;	/* tick->ms */
return(u);
}
/*******************/
void PrintTime()
{
double f;
ReadTime(); f = tick; f /= hz; printf("\nHZ=%d  Accumulated time: %.2fs",hz,f);
#ifdef DEF_CLK_HZ
 printf("   HZ=??? : time unit is computed => may be wrong");
#endif
printf("\n");
}

/*************/
void SetLoad()
{
int i;
for(i=0; i<hwt; i++) Load[i]=0; if(hwt>0) for(i=0; i<swt; i++) Load[Loc[i]] += Sg[i];
}

/****** old method for evaluating was: SUM of ABS differences from sumload*averspeed */
/* but for not-homogenous speed this is not apropriate method */
/* for diffusion method (own, boillat and fixed) 
   their internal cost function need not be changed */
/*******************/
#ifdef BLABLA
int ImbAbs()
{
extern int abs(int i);
int i;
double s,z,d;
z = sumload; z /= hwt; z *= averspeed;
for (s = i = 0; i < hwt; i++) {
  d = Load[i]*He[i]; d -=z; if(d<0) s -=d; else s +=d; }
return(s);
}

double Imb()
{
double f;
f = 2; f /= hwt; f = 2 - f; f *= sumload; f *= averspeed; if(f==0)f=MAXINT;
return(ImbAbs()*100/f); /* printf("\tImb=%.2f%% ", */
}
#endif

/****** new method for evaluating: SUM of ABS differences from average(load*speed) */
static int averload;

int ImbAbs()
{
extern int abs(int i);
int i;
double s,z,d;
for (s = i = 0; i < hwt; i++) s += Load[i]*He[i];
averload = s; z = s; z /=hwt;
for (s = i = 0; i < hwt; i++) {
  d = Load[i]*He[i]; d -=z; if(d<0) s -=d; else s +=d; }
return(s);
}

double Imb()
{
double f; 
int i;
f = 2; f /= hwt; f = 2 - f; 
i = ImbAbs(); /* set topical averload */
f *= averload;
if(f==0)f=MAXINT;
return(i*100/f);
}

/**************************/
int Comm()
{
int s,i;
for (s = i = 0; i < cht; i++) s += Cg[i][2] * Hg[Loc[Cg[i][0]]*hwt+Loc[Cg[i][1]]];
return(s); /* printf("\tComm=%3d %s\n",s,BL); */
}

/******************************************************************************/
void Result(char *mm, char *ss, char *abi)
{extern char *swn;	/* task names table, defined in "pmap_grp.h" */

int i,myt,cc;
float ii,f;

if(me<=0) {	/* file fo is opened ... */

myt = ReadTime();
grpsavRe=TRUE;
cprintf("\n%s ",ss);
ii=Imb(); printf(" Imb=%5.2f%%",ii);
cc=Comm(); printf(" Comm=%3d",cc);
f =  myt; f /= 1000; printf("\tTime=%.2fs\t",f); timeconsum=f;

if(mode!='H') { /* checking Load: */
 for (i = 0; i < swt; i++) Load[Loc[i]] -= Sg[i];
 for (i = 0; i < hwt; i++) if(Load[i] != 0) printf(" L%d!",i);
 for(i=0; i<swt; i++) Load[Loc[i]] += Sg[i]; /* restore */
}
#if PVIOCHECK
/* checking the virtual channel number: */
for (i=0; i < hwt; i++) pvi[i] = pvo[i] = 0;
for (i=0; i < cht; i++)
 { if ((s = Loc[Cg[i][0]]) != (z = Loc[Cg[i][1]])) { pvo[s]++; pvi[z]++; } }
for (s=i=0; i < hwt; i++) if (pvo[i] > MNVM || pvi[i] > MNVM) s++;
if (s > 0) printf(" P%d!",s);
#endif

/* for SW_graph view purpose :
f = sumload; printf("\nAverage computational cost = %.2f\n",f/swt);
{int s; for(s = i = 0; i < cht ; i++) s += Cg[i][2]; f = s;}
printf("Average communicational cost = %.2f \n",f/cht);
*/

printf(" %s","");
if (strchr(abi,'a')!=NULL) {printf("%d/",alpha);printf("%d",beta);}
if (strchr(abi,'i')!=NULL) printf(":%d",iter);

if(me==0 && (f = CollectTime(myt))!=myt) {
  f /= 1000;  printf("\nSummTime=%.2fs\t",f); timeconsum=f; }

if(XshowView) Animat(-1); /* show result in View window */
if(swn==NULL) { /* for old-fashioned input file format */
  fseek(fo,0,SEEK_SET);
  GRPflushResult(fo,ii,cc,mm); /* it uses timeconsum ! */
}
}

else SendTime(ReadTime()); /* me>0 */
}

/*******************/
void ShowLoad(int ii)
{
int i; int hw;
hw = hwt; if (hw>12) hw = 12;
printf("\r%4d: ",ii); for (i = 0; i < hw; i++) printf("%5d",Load[i]);
if (hw < hwt) printf(" ...");
}

/*******************/
void Printline(char c)
{int i; printf("\n"); for (i=0; i<80; i++) putchar(c);}

/**********************
int Rand1(int range)
{
float f; int rand();	* pozor: bola zmena random -> rand bez overenia! *
f = (float)abs(rand()); f /= MAXINT; f *= range;
return(f);
}
**********************/

int NewSeed = 0; /* global for restarting : X-initializing */
/************** INMOS TOOLSET D7205 RANDOM GENERATOR ********/
int Rand(int range)
{
#define A 1664525
/* static NewSeed = 0; */
unsigned int w;
int x = MAXINT / range;
NewSeed = (NewSeed * A) + 1;	/* next in sequence */
w = NewSeed; w >>= 1; w = w / x;	/* into range <0,range) */
return(w);
}

/**********************/
void TestRand(int turn, int e)
{
int i,max,min,m,s;
float f;
#define RANGE 100
min = RANGE;
for (s = max = i = 0; i < turn; i++) 
 { m = Rand(RANGE); s += m; if (m < min) min = m; if (m > max) max = m; }
f = s; f /= turn;
if(e)printf("\nRandom Generator <0..%d) -> <%d--%.2f--%d>",RANGE,min,f,max);
if(max>=RANGE){printf("\nRandom Generator internal ERROR!\n");EXM}
}

/**********************/
int InitialPlacing(int st)	/* Load[], Loc[], pvi[], pvo[] */
			/* all the tasks wish be placed at only "st" node */
{int i;			/* -> start = st ? 0 */
#if PVIOCHECK
for (i=0; i < hwt; i++) Load[i] = pvi[i] = pvo[i] = 0;
#else
for (i=0; i < hwt; i++) Load[i] = 0;
#endif
Load[st] = sumload;for (i=0; i < swt; i++) Loc[i] = st; 
if (Move(fixed,0,TRUE)) { start = st;
#if PVIOCHECK
{int i,f,t;
 for (i=0; i < cht; i++)
  if ((f = Loc[Cg[i][0]]) != (t = Loc[Cg[i][1]])) { pvo[f]++; pvi[t]++; }}
#endif
}
else {Load[st]= 0; Load[start=0]= sumload; for (i=0; i<swt; i++) Loc[i]= 0; }
return(Load[st]>0);
}


/******************************************************************************/

	/* M A P P I N G     S T R A T E G I E S */

/******************************************************************************/
void Greedy0()	/* rand.nocheck : random placing without PVIOCHECK checking */
{
int i;
ReadTime(); for (i=0; i < hwt; i++) Load[i] = 0;
for (i = 0; i < swt; i++) 
 if (i != fixed) Load[Loc[i] = Rand(hwt)] += Sg[i];
 else Load[Loc[fixed] = 0] += Sg[fixed];
}

/******************************************************************************/
void Greedy1()	/* random : random allowed placing */ 
		/* !!! set the PVIOCHECK to TRUE !!! */
{
int i;
ReadTime(); InitialPlacing(START);
if (!PVIOCHECK) printf(" !! no check :");
for (i=0; i<swt; i++) if (i != fixed) while (!Move(i,Rand(hwt),TRUE));
}

/********************/
static int FindFree(int tsk) /* find next most free node */
{
static int last = -1, fou = -1;	/* last task - found node*/
int i,ii,val,m,s;
Load[Loc[tsk]] -= Sg[tsk]; ii = -1;
if (last!=tsk)			/* find most free : */
{ m=MAXINT; for (i=0; i<hwt; i++) if (m > (s = Load[i]*He[i]) ) {m = s; ii = i;} }
else
{ val=Load[fou]*He[fou]; fou++; ii = -1;	/* find next with the same val : */
 for (i=fou; i<hwt; i++) if (val == Load[i]*He[i]) {ii = i; i=hwt;}
 m = MAXINT; if (ii<0)
 for (i=0; i<hwt; i++)		/* if fail: find some with min. higher val: */
  { s = Load[i]*He[i]; if (m>s && s>val) {m = s; ii = i;} }
 if (ii<0) 
 {
 printf("Error FindFree:tsk=%d val=%d loc=%d fou=%d \n",
			tsk,val,Loc[tsk],fou);
 for (i=0; i<hwt; i++) printf("%d ",Load[i]); printf("\n");
 printf("move tsk->Loc[tsk] : %d (TRUE=%d)\n",Move(tsk,Loc[tsk],TRUE),TRUE);
 exit(1);
 }
}
Load[Loc[tsk]] += Sg[tsk];
last=tsk; return(fou=ii);
}

/******************************************************************************/
void Greedy2()	/* to_most_free : next task place to most free node */
{
int i;
ReadTime(); InitialPlacing(START);
for (i=0; i<swt; i++) if (i != fixed) while (!Move(i,FindFree(i),TRUE)) ;
}

/********************/
static int FindLargest(int ss) /* find largest non-placed task on the "start" node */
			/* ss==0 -> restart static variables */
{
static int w; /* w - weight Sg[] : greater are placed yet */
static int t;  /* t - task number: lower or equal are placed yet | w=Sg[t] */
int i,ii,s,m;/* keby bol vstupom iny ako "start" uzol, bolo by treba w[], t[] */
if (ss==0) {w = MAXINT; t = -1;}
ii = -1;
while (ii<0 && w>0)
{m = -1;
 for (i=0; i<swt; i++) if (Loc[i]==start) { s = Sg[i];
  if (m<s && s<w) {m=s; ii=i;}
  else	if (s==w && i>t) {m=s; ii=i; i=swt;}
					 }
 if (ii<0) {w--; t=-1;} else { t=ii; if (m<w) w=m; }
}
/* vypis("largest:%d w=%d\n",ii,w); */
if (ii<0) exit(1); return(ii);
}

/******************************************************************************/
void Greedy3() /* large_first: choose largest task to place to most free node */
{
int i,ii;
ReadTime(); InitialPlacing(START);
for (i = 0; i < swt; i++) 
 { ii = FindLargest(i); if (ii != fixed) while (!Move(ii,FindFree(ii),TRUE)); }
}

/********************/
static int Fit(int loc, int nod)
{
int i,l,m;
for (i = m = 0; i < cht; i++) if (Cg[i][0] ==  nod) if ((l=Loc[Cg[i][1]]) >= 0) 
		m += Cg[i][2] * Hg[loc*hwt+l];   else m +=Cg[i][2] * dist; 
m *= alpha; m += beta * Load[nod]*He[nod]; return(m);
}

/********************/
static int FindFit(int tsk) /* find most convenient - free&near - node */
{
static int last = -1, fou = -1; /* last task - found node */
int i,s,m,jj,val, loc=Loc[tsk];
Load[loc] -= Sg[tsk]; jj = -1;
if (last!=tsk)			/* find most convenient : */
{ m=MAXINT; for (i=0; i<hwt; i++) if (m > (s = Fit(loc,i))) {m = s; jj = i;} }
else
{ val=Fit(loc,fou++); jj = -1;	/* find next with the same val : */
 for (i=fou; i<hwt; i++) if (val == Fit(loc,i)) {jj = i; i=hwt;}
 m = MAXINT; if (jj<0)
 for (i=0; i<hwt; i++)		/* if fail: find some with min. higher val : */
  { s = Fit(loc,i); if (m>s && s>val) {m = s; jj = i;} }
 if (jj<0) 
 {
 printf("Chyba FindFit:tsk=%d val=%d loc=%d fou=%d \n",
			tsk,val,Loc[tsk],fou);
 for (i=0; i<hwt; i++) printf("%d ",Load[i]); printf("\n");
 printf("move tsk->Loc[tsk] : %d (TRUE=%d)\n",Move(tsk,Loc[tsk],TRUE),TRUE);
 exit(1);
 }
}
Load[loc] += Sg[tsk];
last=tsk; return(fou=jj);
}

/******************************************************************************/
void Greedy4() /* fit_large : the largest task to place to most convenient node */
{
int i,ii;
ReadTime(); InitialPlacing(START);
for (i = 0; i < swt; i++) 
 { ii = FindLargest(i);				    /* vypis */
   if (ii != fixed) while (!Move(ii,FindFit(ii),TRUE)) printf("%d->%d\r",i,ii); }
}

/******************************************************************************/
int Move(int tsk, int newl, int really)	/* returns move allowance */
{
int old;
if (tsk < 0 || tsk == fixed) return(FALSE); 
if (newl == (old = Loc[tsk])) return(TRUE);

#if PVIOCHECK
int old,voo,vio,von,vin,k,ip,op,ic,oc;
voo = vio = von = vin = 0;
for (k=0; k < cht; k++)
{
ip = Cg[k][1]; op = Cg[k][0]; ic = Loc[ip]; oc = Loc[op];
     if (ip == tsk && ic == newl);
else if (op == tsk && oc == newl);
else if (ip == tsk && oc == old) { voo++; vin++; }
else if (op == tsk && ic == old) { vio++; von++; }
else if (ip == tsk && oc == newl) { vio--; von--; }
else if (op == tsk && ic == newl) { voo--; vin--; }
else if (ip == tsk) { vio--; vin++; }
else if (op == tsk) { voo--; von++; }
}
if (pvi[old]+vio > MNVM || pvo[old]+voo > MNVM ||
    pvi[newl]+vin > MNVM || pvo[newl]+von > MNVM) return(FALSE);
#endif

if (really)
 { /* vypis("move:%d:%d->%d\t",tsk,old,newl); */
  Load[old] -= Sg[tsk]; Load[newl] += Sg[tsk]; Loc[tsk] = newl;
#if PVIOCHECK
  pvo[old] += voo; pvo[newl] += von;
  pvi[old] += vio; pvi[newl] += vin;
#endif
 }
return(TRUE);
}
/***************************
void brkp() { printf(">BRK<");getchar();}
******************************************************************************/

