/* GRPreadArg, GRPtest, GRPread  for pmap.c & xpmap.c */

/* #define WAIT_FOR_TRACE_STABLE */
#define ONLY_NEW_TRACE

#include "pmap.h"
#include <string.h>
#include "pmap_grp.h"
extern void exit(int); 

#define DELIM (c=='=' || c==' ' || c=='\n' || c=='\r')

char *swn=NULL;	/* task names table, each name is max.TASKNLGT-1 chars & NULL */
char *appname=NULL;	/* Application name */
char **hwn=NULL;	/* for *GetProcName() : not static! */
char *grpname=NULL;	/* GRP-file name */
int grpok=FALSE;	/* does GRP-file contain ProgramPart ? */
int DLBisON=FALSE;	/* Dynamic Load Balancing Switch status */
int DLBorig;		/* original status of DLB */

static int GRPparse();
static int getString(FILE *ff, char *tx);
static int Open(FILE **fi);
static int findNext(FILE *ff, char *tx);
static int GRPfindNext(char *tx);
static int ReadTrace();

/*****************************************************************************/
int GRPtest() /* ok, appname? */
{int r; char *ss=NULL; FILE *ff=NULL;
r=TRUE;
if(
#ifndef NOPVM
!(grpname[0]=='-') && 
#endif
Open(&ff)==0) {
  if(!findNext(ff,"application:")) r=FALSE;		/*"ProgramPart"*/
  else { getString(ff,buff); ss=strdup(buff); grpok=findNext(ff,GR_HP);
	 if(appname!=NULL && strcmp(appname,ss)!=0 && grpok) {
	   appname=ss;
	   printf("warning: bad application name %s in GRED-MP call !\n",ss);
	 } else appname=ss;
  }
  fclose(ff); }  /* below: for saving PVM-hw info in old-fashioned format */
else { ok=FALSE; if(strlen(grpname)==5 && strncmp(grpname,"-swhw",5)==0) r=FALSE; }

return(r);
}

/**************************************************************************/
int GRPreadArg(int argc, char *argv[])	/* arg4, arg5 */
{
if(argc>2 && !gred) mode = toupper(argv[2][0]);
arg4 = 1; arg5 = 1; return(0); }

#define GRPreadInt() ReadInt()

static int GRPgetint(char *tx) {GRPfindNext(tx); return(GRPreadInt());}

static int GRPgetFirstChar()
{
int c;
while( (c=getc(fi)) != EOF && c != '\"') ;
if(c=='\"')return(getc(fi));
else {cprintf("Bad GRP_file: can't find %s\n","\""); exit(1);}
return(-1);
}

/**************************************************************************/
static int GRPgetQuoted(char *tx) /* quoted between " */
{
int c,i;

for(i=0; i<TASKNLGT;i++) tx[i]='\0'; i=0;
tx[i++]=GRPgetFirstChar();
while ( i<TASKNLGT-1 && (c = getc(fi)) != EOF ) {
  if (c=='\"') return(TRUE); else tx[i++]=c; }
return(FALSE);
}

/**************************************************************************/
static int GRPloadSWN() /* from Mapping Section */
{
int i;
for(i=0;i<swt;i++)if(!GRPgetQuoted(&swn[i*TASKNLGT]))return(FALSE);
return(TRUE);
}

/**************************************************************************/
static int GRPloadHWN() /* from Mapping Section */
{
char tx[TASKNLGT];
int i;
for(i=0;i<hwt;i++){if(!GRPgetQuoted(tx))return(FALSE);hwn[i]=strdup(tx);}
return(TRUE);
}

/*****************************************************************************/
static int Open(FILE **ffi)
{
char *tx=NULL, *xx=NULL, *gg=NULL;
int i;

if ((*ffi = fopen(grpname, "r")) == NULL) {
  tx=getenv(GRPDIRPATH); xx=NULL; gg=strdup(grpname);
  if(tx!=NULL) { i=strlen(grpname)+strlen(tx)+2;
    if((xx = (char *) malloc(i*sizeof(char)))!=NULL) {
      strcpy(xx,tx); strcat(xx,"/"); strcat(xx,grpname);
      free(grpname); grpname=xx; xx=NULL;
    }
    else printf("warning * file %s/%s will not be read\n",tx,grpname);
    if ((*ffi = fopen(grpname, "r")) == NULL) {
      if(strstr(grpname,SUFF)==NULL) { i=strlen(grpname)+strlen(SUFF)+1;
	if((xx = (char *) malloc(i*sizeof(char)))!=NULL) {
	  strcpy(xx,grpname); strcat(xx,SUFF);
	  free(grpname); grpname=xx; xx=NULL;
	}
	else printf("warning * file %s%s will not be read\n",grpname,SUFF);
	*ffi = fopen(grpname, "r");
      }
    }
  }
  if (*ffi == NULL) { free(grpname); grpname=strdup(gg);
    if(strstr(grpname,SUFF)==NULL) { i=strlen(grpname)+strlen(SUFF)+1;
	if((xx = (char *) malloc(i*sizeof(char)))!=NULL) {
	  strcpy(xx,grpname); strcat(xx,SUFF);
	  free(grpname); grpname=xx; xx=NULL;
	}
	else printf("warning * file %s%s will not be read\n",grpname,SUFF);
    }
    if ((*ffi = fopen(grpname, "r")) == NULL) {
      cprintf("Cannot open %s GRP_file !\n",grpname); ex(2)
    }
  }
  free(gg); gg=NULL;
}
return(0);
}

/*****************************************************************************/
static int GRPopen()
/* vytvori docasny subor TEMPNAME, do ktoreho da len MappingSection a ten podstrci */
{
int c, r; FILE *ff; char *pp=NULL, *ss=NULL;

if((r=Open(&fi))>0)return(r);
if(strcmp(grpname,TEMPNAME)==0 || strcmp(grpname,TEMP_TMP)==0) {
  cprintf("%s GRP_file will not be overwritten by output files!\n",grpname);
  cprintf("%sRename it first!\n",""); ex(2)
}

strcpy(buff,""); pp=getenv(OUTNAMEDIR);
if(pp!=NULL && strlen(pp)>0) { strcat(buff,pp); strcat(buff,"/"); }
if(appname!=NULL && strlen(appname)>0) strcat(buff,appname);
else 
if ((ss=strrchr(grpname,'/'))==NULL) strcat(buff,grpname); else strcat(buff,++ss);
strcat(buff,OUTNAMESUFF); nout=strdup(buff);

#ifdef PRINTY
if ((fo = fopen(nout, "r")) != NULL) {
  printf("Result GRP_file %s exists, overwrite ? [y/n]y\b",nout); GETY
}
#endif

if ((fo = fopen(nout, "w")) == NULL) 
		{cprintf("Cannot open %s as result GRP_file !\n",nout); ex(2)}
    if(!gred) printf("<<< MAPPING: GRP_file=%s ",grpname);
printf("---> result mapping_vector: %s\n",nout);

if ((ff = fopen(TEMPNAME, "w+")) == NULL)
		printf("Cannot open %s as temp file !\n",TEMPNAME);
else { /*int f; c=fileno(ff); f=dup(c); */
  if(!GRPfindNext(GR_S_M)) fclose(ff) ;
  else {
    while((c=getc(fi))!='{' && c!=EOF) ;
    r=1;
    fprintf(ff,"%s\n{",GR_S_M);
    while(r>0 && (c=getc(fi)) != EOF) {
      if(c=='{') r++; else if(c=='}') r--; putc(c,ff); 
    }
    fclose(fi); fi=ff; rewind(fi);
  }
}
return(0);
}




/* */






/*****************************************************************************/
static int CompareCg(int cht_, int (*Cg_)[3]) /* and also set Cg[][2] */
    /* staci len aby Cg_ bola podmnozina Cg, pretoze Cg su obojsmerne, aj ked 
       "vznikli" z jednosmernych - toto sa tyka len "syntetickych" uloh */
{
  int i,j;
  for (j=0; j<cht_; j++) if(Cg_[j][2]<0) return(TRUE); /* not usable */
  for (i=0; i<cht; i++) {
    for (j=0; j<cht_; j++)
      if(Cg[i][0]==Cg_[j][0] && Cg[i][1]==Cg_[j][1] && Cg_[j][2]>0) {
      Cg_[j][2]= -Cg_[j][2]; j=cht_; }
    if(j==cht_) for (j=0; j<cht_; j++) /* try reverse direction */
      if(Cg[i][0]==Cg_[j][1] && Cg[i][1]==Cg_[j][0] /*&& Cg_[j][2]>0*/) {
      /*Cg_[j][2]= -Cg_[j][2];*/ j=cht_; }
    if(j==cht_) i=cht;
  }
  if(i>cht) return(TRUE);
  
  for (j=0; j<cht_; j++) {
    for (i=0; i<cht; i++)
      if(Cg_[j][0]==Cg[i][0] && Cg_[j][1]==Cg[i][1])
	{ Cg[i][2]= -Cg_[j][2]; i=cht; }
  }
  /* vypis(" Compare CHT=O.K.\n");
  printf("Cg=");for(i=0;i<cht;i++) {
		  printf("[");
		  for(j=0;j<3;j++)printf("%d ",Cg[i][j]);
		  printf("] ");
		}
		printf("\n");
  */
  return(FALSE);
}


/*******************************************/
static void getSWL()
{
int i,s;

if(GRPfindNext(GR_M_load)) {
  for (sumload = s = i = 0; (s >= 0 && i < swt); i++)
    {Sg[i] = s = GRPreadInt(); sumload += s;}
  if (i != swt) {
    cprintf("ERROR: bad Mapping section in GRP_file !%s\n","");
    for (i=0; i<swt; i++) Sg[i] = 1;
    sumload = swt;
  }
}
}

/*******************************************/
static int CompareSWN()
{
int i;
char tx[TASKNLGT];
for(i=0;i<swt-MASTER;i++) {
  if(!GRPgetQuoted(tx)) return(TRUE);
  if(strcmp(&swn[i*TASKNLGT],tx)!=0) return(TRUE);
}
/* vypis(" Compare SWN=O.K.\n"); */
getSWL();
return(FALSE);
}


/*******************************************/
static int GetMaster()
{int i,j,k,f;
 /* check for master process : (it has channel connection with all other) */
 
/* printf("\n");
for(i=0;i<cht;i++) printf("%d-%d:%d ",Cg[i][0],Cg[i][1],Cg[i][2]);
printf("\n"); */
f=-2;
 for(j=swt-1;j>=0;j--) {
   for(k=0;k<swt;k++) {
     if(j!=k) {
       for(i=0;i<cht;i++)if(Cg[i][0]==j && Cg[i][1]==k) i=cht;
       if(i>cht) {
	 for(i=0;i<cht;i++)if(Cg[i][0]==k && Cg[i][1]==j) i=cht;
	 if(i==cht) k=swt;
       }
       else k=swt;
     }
   }
   if(k==swt) {
     f=j; j=-1;
   }
 }
return(f);
}


/*****************************************************************************/
static int CompareSW() /* swt, cht, sumload, Sg[], Cg[], ok */
/* compares SW-graph from Mapping section with the one parsed from ProgramPart */
/* and if these match, use values (computational and communicational loads) */
{
int i,j,s, (*Cg_)[3]=NULL, cht_=0;

if(GRPfindNext(GR_G_T)) {
  s = GRPgetint(GR_M_ntask); if(s!=swt)return(TRUE); /* not usable */
  GRPfindNext(GR_G_T);
  GRPfindNext(GR_M_task_name);
  if(swn==NULL) return(TRUE);
  if(CompareSWN()) return(TRUE);
  
  if(GRPfindNext(GR_M_load)) {
    for (sumload = s = i = 0; (s >= 0 && i < swt); i++)
      {Sg[i] = s = GRPreadInt(); sumload += s;}
    if (i != swt) {cprintf("warning: bad Mapping section !\n%s","");
		   for (sumload = i = 0; i < swt; i++) Sg[i] = 1;
		   sumload=swt;
		   return(TRUE);
    }
  }
  cht_=GRPgetint(GR_M_nchan);
  if(cht_!=cht)cprintf(" *one/bi/MASTER* %s","");
  if(cht_!=cht)return(TRUE); /* was change - MASTER */
  GRPfindNext(GR_M_tcomm);
  if((Cg_ = (int (*)[3]) realloc((void *)Cg_, cht_*sizeof(int[3])))==NULL)
    return(TRUE);
  for (i = s = 0; i < cht_ && s >= 0; i++)
    for (j = 0; j < 3; j++) Cg_[i][j] = s = GRPreadInt();
  if(i!=cht_) {free((void *)Cg_); Cg_=NULL; return(TRUE); }
  if(GRPfindNext(GR_M_fixed) && fixed<0) fixed = GRPreadInt();
  s=CompareCg(cht_,Cg_); /* and also set Cg[][2] */
  free((void *)Cg_); Cg_=NULL;
  if(s)cprintf(" *NEW* %s","");
  if(!s) s = fixed!=GetMaster();
  return(s);
}
else return(TRUE);
}


static int GRPaddMASTERchannels(int mxk)
{int i,k;
  if(fixed==swt-1 && 2*(swt-1)==cht-mxk) { /* MASTER with slaves bi-directional */
    k=mxk;
    for(i=0;i<swt-1;i++) {
      Cg[k][0]=fixed; Cg[k][1]=i; Cg[k++][2]=1;
      Cg[k][0]=i; Cg[k][1]=fixed; Cg[k++][2]=1;
    }
    return(TRUE);
  } else {cht -= 2*(swt-1); /* cht= ... */
	  printf(" WARNING: channels for MASTER not used! #channels=%d\n",cht);
	  return(FALSE);
  }
}

/************** MASTER ****************/ /*--- not static : for pmap_swhw.c --*/
void GRPaddMaster(char *appn) /* Increments swt,cht. For non-grp inputs only! */
{int i,j,ch;
#if MASTER == 1 
 if(fixed==swt-1) return; /* MASTER is already added and marked */
 /* check for master process : (it has no channel connection) */
 for(j=i=0;i<cht;i++)if(Cg[i][0]==swt-1 || Cg[i][1]==swt-1)i=cht;
 if(i>cht) {
   fixed=swt++; /* fixed=swt-1 */ /* swt= ... */
   if((Sg  = (int *) realloc((void *)Sg,  swt*sizeof(int)))==NULL)EXM
   if((Loc = (int *) realloc((void *)Loc, swt*sizeof(int)))==NULL)EXM
   if(appn!=NULL) { /* not for old-fashioned input format */
     if((swn = (char *) realloc((void *)swn,swt*sizeof(char[TASKNLGT])))==NULL)EXM
     strncpy(&swn[fixed*TASKNLGT],appn,TASKNLGT); /* MASTER process */
   }
   Loc[fixed]=0; Sg[fixed]=Sg[0]; /* something */
   sumload += Sg[fixed];
   grpsavSw=TRUE;
   ch=cht; /* MASTER is connected with all other processes bi-directionaly */
   cht += 2*(swt-1); /* cht= ... */
   if((Cg = (int (*)[3]) realloc((void *)Cg, cht*sizeof(int[3])))==NULL)EXM
   GRPaddMASTERchannels(ch);
   printf("...MASTER added as %d...",fixed);
   printf("\n#tasks=%d #channels=%d",swt,cht);
 }
#endif 
}

/*****************************************************************************/
int GRPread()	/* swt,cht,sumload,Sg[],Cg[],nout,ok,mode,hwt, */
    		/* ?Hg[],?He[],?averspeed,hgrd,?Loc[] */
{
int i,j,s;

printf("...reading mapping info\n%s",BL);
#ifndef NOPVM
if(grpname[0]=='-') hgrd=TRUE;
else
#endif
  {
GRPopen(); /* fi,fo */ if(!ok) ex(2);
if(!GRPfindNext(GR_S_M)) {
  grpsavOp=grpsavSw=hgrd=TRUE; GRPparse();}
else
{
  if(GRPfindNext(GR_G_M))
    if(GRPfindNext(GR_M_smethod))
      { modeGRP=toupper(GRPgetFirstChar());
	if(mode!=toupper(mode)) /* lower case == default mode */
	  mode=modeGRP;
      }	 /* mode entered in command-line has the higher priority */
  if(GRPfindNext(GR_M_dmethod)) DLBisON=!(GRPgetFirstChar()=='0');
  DLBorig=DLBisON;
  /* coomand line option has higher priority */
  
  if(grpok) { GRPparse(); grpsavSw=CompareSW(); /* also reads SW part ...*/  }
  else {
    /*******************************  SW part read for non-grp input **************/
    if(GRPfindNext(GR_G_T)) 
      {
	swt= GRPgetint(GR_M_ntask);
	if((Sg  = (int *) realloc((void *)Sg,  swt*sizeof(int)))==NULL)EXM
	if((Loc = (int *) realloc((void *)Loc, swt*sizeof(int)))==NULL)EXM
	for(i=0;i<swt;i++)Loc[i]=Sg[i]=0;
	if(!gred) printf("#tasks=%d",swt);
	GRPfindNext(GR_G_T);
	GRPfindNext(GR_M_task_name);
	if(swn==NULL)if((swn  = (char *) malloc(swt*sizeof(char[TASKNLGT])))==NULL)EXM
	if(!GRPloadSWN()){
	  cprintf("ERROR:%s bad SW_graph names !\n","");free(swn);swn=NULL;}
	
	getSWL(); /* load */
	cht= GRPgetint(GR_M_nchan); GRPfindNext(GR_M_tcomm);
	if((Cg = (int (*)[3]) realloc((void *)Cg, cht*sizeof(int[3])))==NULL)EXM
	for (i = s = 0; i < cht && s >= 0; i++)
	  for (j = 0; j < 3; j++) Cg[i][j] = s = GRPreadInt();
	if(!gred) printf(" #channels=%d",cht);
	if(GRPfindNext(GR_M_fixed)) fixed = GRPreadInt(); else fixed = -1;
	GRPaddMaster(appname); /* MASTER swt++?,cht++? */
      }
  }  
  
  /*******************************  HW part read *******************/
  hgrd=!GRPfindNext(GR_G_P);
  if(!hgrd) hgrd=(hwt=GRPgetint(GR_M_nproc)) <= 0;
  if(!hgrd)
    {
      GRPfindNext(GR_G_P);
      GRPfindNext(GR_M_proc_name);
      if((hwn = (char **) realloc((void *)hwn, hwt*sizeof(char *)))==NULL)EXM
      if(!GRPloadHWN()){cprintf("ERROR:%s bad HW_graph names !\n","");ex(3)}
      GRPfindNext(GR_G_P);
      j=GRPfindNext(GR_M_speed);	/* v-- 2*hwt: for short-time speed also */
      if((He = (int *) realloc((void *)He, 2*hwt*sizeof(int)))==NULL)EXM
      for (i=0; i<2*hwt;i++) He[i]=1; 
      if(j) {averspeed = 0;
	     for (i = 0; i < hwt; i++) { He[i] = j = GRPreadInt(); averspeed +=j; }
	     if (He[hwt-1] <0) {cprintf("ERROR:%s bad HW_graph !\n","");ex(3)}
	     averspeed /= hwt;
      } else averspeed = 1;       
      GRPfindNext(GR_G_P);
      GRPfindNext(GR_M_pcomm);
      if((Hg = (int *) realloc((void *)Hg, hwt*hwt*sizeof(int)))==NULL)EXM
      for (i = 0; i < hwt; i++)  for (j = 0; j < hwt; j++) Hg[i*hwt+j] = GRPreadInt();
      if (Hg[hwt*hwt-1] <0) {cprintf("ERROR:%s bad HW_graph !\n","");ex(3)}
      if(!gred) printf(" => #hw_nodes=%d",hwt);
      /*******************************  Loc part read *******************/
      if(!grpsavSw && GRPfindNext(GR_G_R) && GRPfindNext(GR_M_location))
	{ for(i=0;i<swt;i++) Loc[i]=GRPreadInt();
	  for(s=i=0;i<swt;i++) if((j=Loc[i])>=hwt || j<0) s++;
	  XshowView=(s==0); CheckXshowView(); } /* for non-x interfaced */
    }
}
ReadTrace();
}
unlink(TEMPNAME); /* if exists */
ReallocLoad(); /* also pvi, pvo */
SetLoad();
fclose(fi);
return(0);
}


/****************************/
static int findNext(FILE *ff, char *tx)  /* no rewind */
{
int c,f,txm; char tx0;

txm = strlen(tx); tx0 = toupper(tx[0]);
while ( (c = getc(ff)) != EOF) {
  if ((c = toupper(c)) == tx0) {
    for (f=0; f<txm && c == toupper(tx[f]); f++)
      c =toupper(getc(ff));
    if (f == txm && DELIM)
      return(TRUE);
  }
}
return(FALSE);
}

/****************************/
static int GRPfindNext(char *tx)
{int r;
for(r=0;r<2;r++) {
  if(findNext(fi, tx))return(TRUE);
  rewind(fi); /* 1 allowed rewind */
}
return(FALSE);
}






 

/*------------------------------------------------------------------------*/

/*----------------- P A R S E R ------------------------------------------*/

/*------------------------------------------------------------------------*/

#define PARS_P "process"

/* Zjednoduseny parser: vyuziva "-t" volbu programu "grppars", ktora vytvori
   "task graph" avsak taky, ze ak je apojenie z A do B a pritom nie je opacne,
   tu je aj opacny smer,  je umelo pridany. Pri monitorovani taky kanal
   neexistuje, a preto treba namerat nejaku zmysluplnu hodnotu, trebars 0. */
/* Oprava: 1)zmenit grppars 2)doplnit vyhodenie neexistujucich spojeni */

#define EXW {printf("%s: Internal error or bad GRP file!\n",argv0); return;}

/* ------------------------ */
static int findProc(char *tx) 
{
int i,j;
j=-1; for(i=0;i<swt-MASTER;i++) if(strcmp(tx,&swn[i*TASKNLGT])==0) {j=i; break;}
return(j);
/*
i=0; while (i<swt) {
       while( i<swt && swn[i*TASKNLGT]!=tx[0])i++;
       if(i<swt && 0==strncmp(tx,&swn[i*TASKNLGT],TASKNLGT)) return(i);
       i++;
     }
return(-1);
*/
}

/* ------------------------------------ */
static int findChan(int i, int j, int mxk)
{int k;
 if(i<0 || j<0 || i>swt || j>swt) EXF
 for(k=0;k<mxk;k++) if(Cg[k][0]==i && Cg[k][1]==j) return(k);
 return(mxk);
}

static void enableCg(int f, int t)
{int k;
 if((k=findChan(f,t,cht))==cht) EXW
 if(Cg[k][2]<0)  Cg[k][2]=-Cg[k][2]; 
}

static void setchan(int p, int m, FILE *ff)
{int i; char *c;
if(!findNext(ff,GR_P_PP))EXW
getString(ff,buff); if((c=strchr(buff,';'))!=NULL) *c='\0';
if((i=findProc(buff))<0)EXW;
if(m==0) enableCg(i,p);
else if(m==1) enableCg(p,i);
else if(m==2) { enableCg(i,p); enableCg(p,i);}
else { printf("bad mode "); EXF }
return;
}

/* ----------------------------------------- */
static void CorrectCHT() /* corrects channels after "grppars" (bi-direct) */
{int i; FILE *fcf=NULL; long *thr=NULL;

if(Open(&fcf)>0)return;
if((thr  = (long *) realloc((void *)thr, swt*sizeof(long)))==NULL)EXM
for(i=0;i<swt-MASTER;i++) thr[i]=0; /* ProgramPart" */
if(!findNext(fcf,GR_HP)) {printf("not found: %s\n",GR_HP);EXW}
rewind(fcf);
for(i=0;i<swt-MASTER;i++) {
  if(findNext(fcf,GR_P)) /* Process */
    { getString(fcf,buff);
      if(strcmp(buff,&swn[i*TASKNLGT])!=0) 
	{ printf("%d:%s swn=%s\n",i,buff,&swn[i*TASKNLGT]); EXW }
      if(findNext(fcf,GR_P_P)) /* PortSection */
      thr[i]=ftell(fcf);
      else { printf("not found: %s :%d\n",GR_P_P,i); EXW } }
  else {printf("not found: %s :%d\n",GR_P,i);EXW}
}
if(findNext(fcf,GR_P))EXW /* Process */
for(i=0;i<cht;i++) Cg[i][2]=-Cg[i][2];  /* disable all channels and enable only if used : */
for(i=0;i<swt-MASTER;i++) {
  if(fseek(fcf,thr[i],SEEK_SET)<0)EXW
  while(findNext(fcf,GR_P_PI) && (i+1==swt-MASTER || thr[i+1]>ftell(fcf)))
    setchan(i,0,fcf);
  if(fseek(fcf,thr[i],SEEK_SET)<0)EXW
  while(findNext(fcf,GR_P_PO) && (i+1==swt-MASTER || thr[i+1]>ftell(fcf)))
    setchan(i,1,fcf);
  if(fseek(fcf,thr[i],SEEK_SET)<0)EXW
  while(findNext(fcf,GR_P_PIO) && (i+1==swt-MASTER || thr[i+1]>ftell(fcf)))
    setchan(i,2,fcf);
}
free((void *)thr); thr=NULL;
fclose(fcf);
}

/* ----------------------------------------- */
static int getString(FILE *ff, char *tx)
    /* after loaded text should be delimiter */
{int c,i;

for(i=0;i<TASKNLGT;i++) tx[i]='\0'; i=0;
while ( i<TASKNLGT-1 && (c = getc(ff)) != EOF ) {
    if (i>0 && DELIM) return(TRUE); else tx[i++]=c; }
/* NO allowed rewind */
if(c!=EOF)printf("warning: string \"%s\"is too long!\n",tx);
while ((c = getc(ff)) != EOF && !(DELIM));
return(c != EOF);
}

/* -------------------------------------------------------------------------------- */
/* -------------------------------------------------------------------------------- */
static int GRPparse() /* swt, cht, sumload, Sg[], Cg[] */
{
int i,j,k,mxk;
char tx[TASKNLGT];
char *pp=NULL;
FILE *gfi;
int  (*Cgg)[3]=NULL;

printf("...parsing tasks\n%s",BL);
strcpy(buff,"");
pp=getenv(GRPPATH);
if(pp==NULL || strlen(pp)==0)
/*    printf("Warning: environment variable %s is not set!\n",GRPPATH) */ ;
else { strcpy(buff,pp); strcat(buff,GRPPATHb); }

strcat(buff,GRPPARS); strcat(buff,GRPWTASK); pp=strdup(buff);
sprintf(buff,"%s %s > %s\n",pp,grpname,TEMP_TMP);
if(system(buff)!=0) { cprintf("\n\"%s\" error\n",GRPPARS); exit(2); }
free(pp); pp=NULL;

if((gfi = fopen(TEMP_TMP, "r")) == NULL) {
	printf("Cannot open %s as TEMP_file !\n",TEMP_TMP);
	ex(2) }
j=0; while(findNext(gfi, PARS_P)) j++; rewind(gfi); swt=j+MASTER;
if((Sg  = (int *) realloc((void *)Sg,  swt*sizeof(int)))==NULL)EXM
if((Loc = (int *) realloc((void *)Loc, swt*sizeof(int)))==NULL)EXM
for(i=0;i<swt;i++)Loc[i]=Sg[i]=0;
if(swn==NULL)if((swn  = (char *) malloc(swt*sizeof(char[TASKNLGT])))==NULL)EXM

findNext(gfi, PARS_P);
for(mxk=j=i=0;i<swt-1;i++) { getString(gfi,&swn[i*TASKNLGT]); findNext(gfi, PARS_P); }
#if MASTER == 1
strncpy(&swn[i*TASKNLGT],appname,TASKNLGT); fixed=i; /* MASTER process */
#endif
for(i=0;i<swt;i++) Sg[i]=1; sumload=swt;
rewind(gfi);

cht=0; while(getString(gfi,tx)) cht++; rewind(gfi); /* cht= ... */
				       
#if MASTER == 1
/* cht += 2*(swt-1);  * MASTER has connections with all processes */
cht -=2;  /* -2 per process -2 first line +2 per process == -2 */ /* cht= ... */
#else
cht -= 2*swt; /* for each process begin keyword and its name + first line=2 strings */
fixed=-1;     /* cht= ...above */          /* preco som to tam dal? */
#endif

/* grppars does not take account into channel direction !-> 1-st half for final, 2-nd for work */
if((Cgg = (int (*)[3]) realloc((void *)Cgg, cht*sizeof(int[3])))==NULL)EXM
if((Cg = (int (*)[3]) realloc((void *)Cg, cht*sizeof(int[3])))==NULL)EXM
  
for(i=0;i<cht;i++) Cg[i][2]=0;
mxk=0; rewind(gfi); findNext(gfi, PARS_P);
while(getString(gfi,tx)) { /* from process name */
  i=findProc(tx);
  if(i<0)EXF
  do {
    getString(gfi,tx);
    j=findProc(tx);
    if(j>=0) {
      if((k=findChan(i,j,mxk))==mxk) mxk++;
      if(k>=cht)EXF
      if(k>=0) {Cg[k][0]=i; Cg[k][1]=j; Cg[k][2]+= 1;} /* preco? */
    }
    }
  while(j>=0); /* j=-1 ...was "process" */
}

/* remove not used bi-directional to uni-directional : */
CorrectCHT();
for(k=i=0;i<cht;i++) 
    if(Cg[i][2]>0) { Cgg[k][0]=Cg[i][0]; Cgg[k][1]=Cg[i][1]; Cgg[k][2]=Cg[i][2]; k++; }
free((void *)Cg); Cg=Cgg;
cht=k;  mxk=k;
#if MASTER == 1
cht += 2*(swt-1);  /* MASTER has connections with all processes */ /* cht= ... */
#endif

if((Cg = (int (*)[3]) realloc((void *)Cg, cht*sizeof(int[3])))==NULL)EXM
if(!gred) printf("#tasks=%d #channels=%d",swt,cht);

#if MASTER == 1
GRPaddMASTERchannels(mxk);
#endif

unlink(TEMP_TMP);
fclose(gfi);
return(0);
}












/* ...................................................................... */

/* .................. T R A C E ......................................... */

/* ...................................................................... */


#include <sys/stat.h>
#include <unistd.h>

static int older(time_t a, time_t b) { return(a<b); }

static int ReadTrace()
{
struct stat buf;
time_t modif1,modif2;
int i;
char *pp=NULL, *iname=NULL, *pname=NULL, *oname=NULL;

/*define Return(Z) {printf("\nWarning: file %s not found\n",Z); return(FALSE);}
perror("TraceWarning");*/ 

if((pp=getenv("TRACEDIR"))==NULL) pp=getenv(TRACEDIR);

if((iname=getenv("TRACE001"))==NULL) iname=TRACE001;
strcpy(buff,pp); strcat(buff,"/");
strcat(buff,iname); iname=strdup(buff);
if(stat(iname,&buf)<0) return(FALSE); modif1=buf.st_mtime;

#ifdef WAIT_FOR_TRACE_STABLE
{off_t siz,siz0;
siz=0; printf("\n...wait for trace file stable\n%s",BL);
       printf("                               \r");
do {siz0=siz; sleep(1); siz=buf.st_size;} while(siz>siz0);
}
#endif

if((pname=getenv("TRACE002"))==NULL) pname=TRACE002;
strcpy(buff,pp); strcat(buff,"/");
strcat(buff,pname); pname=strdup(buff);
if(stat(pname,&buf)<0) return(FALSE); modif2=buf.st_mtime;

if((oname=getenv("TRACE003"))==NULL) oname=TRACE003;
strcpy(buff,pp); strcat(buff,"/");
strcat(buff,oname); oname=strdup(buff);

i=FALSE; 
#ifdef ONLY_NEW_TRACE
if(stat(oname,&buf)<0 || older(buf.st_mtime,modif1) || older(buf.st_mtime,modif2))
#endif
    i=FilterTrace(iname,pname,oname,Cg,Sg,swn);

if(stat(oname,&buf)<0) return(FALSE); modif1=buf.st_mtime;

if(stat(nout,&buf)==0 && older(modif1,buf.st_mtime)) {
  if(i)printf("\nwarning: filesystem time is corrupted!\n");
  else printf(" ...old trace   \n");
  /* mapping was done, TRACE003 file is older than mapping results !!*/
  return(FALSE);
}
/*for(i=0;i<swt;i++)Loc[i]=0; XshowView=FALSE; * clear last result data */

if(i) { grpsavSw=TRUE; printf(" ...trace OK\n"); }
return(i);
}
