/* GRED environment variables: */
#define GRPPATH "GREDPATH"	/* path to binaries */
#define GRPPATHb "/bin/"	/* subdirectory - because the mistake in GRED */
#define GRPDIRPATH "GRPDIR"	/* path to applications (GRP-files) */
#define OUTNAMEDIR "OBJDIR"	/* path to objects */

/* other GRED - dependent values: */
#define OUTNAMESUFF ".map"	/* result mapping vector is 
					stored in $OBJDIR/application-name.map */
#define GRPPARS  "grppars"	/* parser utility name */
  /* #define GRPPARS  "grp2c -s" * parser utility name */
#define GRPMERGE " -G -Po "	/* parser options for merging with overwriting */
#define GRPWTASK " -t "		/* parser options for writing a task graph */

#define MASTER 1		/* [0,1] - add MASTER GRED process item */

/* trace-data values: */
#define TRACEDIR "HOME"		/* default path to trace files */
#define TRACE001 "trace.trf"	/* default trace file name */
#define TRACE002 "pgrc"		/* default pg_pvm environment trace file name */
#define TRACE003 "pgmap"	/* default our tracefilter output name */

#define COPY "/bin/cp"
#define DELETE "rm"
#define TEMPNAME "/tmp/xPmap_out.out" /* if it was /tmp/xP.., grppars fail to open it!*/
#define TEMP_TMP "/tmp/xPmap_tmp.out"
#define HWDEFAULT "_hw_.grp"	/* name for created HW-section only "application" */ 

#define TASKNAME  "P"		/* default process name prefix */
#define TASKNLGT 16		/* length for task/processor names storing */

#define XSTART 0		/* upper left X position */
#define YSTART 0		/* upper left Y position */
#define XSTEP 1			/* X step between boxes */
#define YSTEP 1			/* Y step between boxes */
#define XMAX 15			/* maximal valid X position, was 7 */
#define YMAX 11			/* maximal valid Y position, was 5 */
#define GR_S_M "Section: Mapping"
#define GR_G_M "Group: MappingOptions"
#define GR_G_T "Group: TaskGraph"
#define GR_G_P "Group: ProcessorGraph"
#define GR_G_R "Group: StaticResult"
#define GR_M_smethod "smethod"
#define GR_M_dmethod "dmethod"
#define GR_M_ntask "ntask"
#define GR_M_task_name "task_name"
#define GR_M_fixed "fixed"
#define GR_M_load "load"
#define GR_M_nchan "nchan"
#define GR_M_tcomm "tcomm"
#define GR_M_nproc "nproc"
#define GR_M_proc_name "proc_name"
#define GR_M_speed "speed_time"
#define GR_M_pcomm "pcomm"
#define GR_M_location "location"
#define GR_S_E "Section: Editor"
#define GR_G_XY "Group: ProcXY"
#define GR_HP "ProgramPart"
#define GR_P "Process:"
#define GR_P_P "PortSection"
#define GR_P_PI "InPort:"
#define GR_P_PP "Proc:"
#define GR_P_PO "OutPort:"
#define GR_P_PIO "InOutPort:"

extern int grpsavSw;	/* TaskGraph Group found? */
extern int grpsavOp;	/* MappingOption Group found? */
extern int DLBisON, DLBorig; /* current & original status of DLB switch */
  
extern char *swn;	/* task names table, each name is max.TASKNLGT-1 chars +NULL */
extern char **hwn;	/* for *GetProcName() : not static! */
extern int grpok;	/* does GRP-file contain ProgramPart ? */

extern char *getenv(const char *name);
extern int system(const char * string);
extern int unlink(const char * string);
extern int rename(const char * old, const char * string );

