/* GRPwriteResult, GRPsave() for pmap.c & xpmap.c */

#include "pmap.h"
#include <string.h>
#include "pmap_grp.h"

			/* should be saved: */
int grpsavSw=FALSE;	/* TaskGraph Group */
int grpsavED=FALSE;	/* ProgramPart etc. */
int grpsavOp=FALSE;	/* MappingOption Group */
int grpsavRe=FALSE;	/* StaticResult Group */

#define MXL MAXBUFF-20	/* ==512-20 maximal line length in output files */

/***********************************************************************/
static void GRPflushOption(FILE *gf)
{char c;
fprintf(gf,"  %s\n  {\n",GR_G_M);
if(grpsavRe)c=mode; else c=modeGRP; /* only if new mapping was done */
fprintf(gf,"    %s = \"%c\";\n",GR_M_smethod,c);
if(DLBisON) c='1'; else c='0';
fprintf(gf,"    %s = \"%c\";\n",GR_M_dmethod,c);
fprintf(gf,"  }\n");
}

/**********************************/
static char *getTASKNAME(int i)
{  if(swn!=NULL) return(&swn[i*TASKNLGT]);
  else {sprintf(buff,"%s%d",TASKNAME,i); return(buff);}
}

/***********************************************************************/
static void GRPflushSw(FILE *gf)
{
int i,j;

fprintf(gf,"  %s\n  {\n",GR_G_T);
fprintf(gf,"    %s = %d;\n",GR_M_ntask,swt);
j=fprintf(gf,"    %s = ",GR_M_task_name);
for(i=0;i<swt-1;i++) {
  j += fprintf(gf,"\"%s\",",getTASKNAME(i));
  if(j>=MXL){j=4; fprintf(gf,"\n    ");}
}
fprintf(gf,"\"%s\";\n",getTASKNAME(i));
fprintf(gf,"    %s = %d;\n",GR_M_fixed,fixed);

j=fprintf(gf,"    %s = ",GR_M_load);
for(i=0; i<swt-1; i++) {
  j += fprintf(gf,"%d,",Sg[i]);
  if(j>=MXL){j=4; fprintf(gf,"\n    ");}
}
fprintf(gf,"%d;\n",Sg[i]);

fprintf(gf,"    %s = %d;\n",GR_M_nchan,cht);
j=fprintf(gf,"    %s = ",GR_M_tcomm);
/* {int k;
  k=-1;for (i=0; i<cht; i++) { 
       if(Cg[i][0] != k || j>=MXL ) \* new line also for next source node *\
	 {if(k>=0)fprintf(gf,",");fprintf(gf,"\n    ");j=4;k=Cg[i][0];}
       else j += fprintf(gf,", ");
       j += fprintf(gf,"%d,%d,%d",Cg[i][0],Cg[i][1],Cg[i][2]);
     }
} */
{
  for (i=0; i<cht-1; i++) {
    j += fprintf(gf,"%d,%d,%d, ",Cg[i][0],Cg[i][1],Cg[i][2]);
    if(j>=MXL){j=4; fprintf(gf,"\n    ");}
  }
}
fprintf(gf,"%d,%d,%d;\n",Cg[i][0],Cg[i][1],Cg[i][2]);
fprintf(gf,"  }\n");
}

/***********************************************************************/
static void GRPflushHw(FILE *gf)
{
int i,j,k;
	
fprintf(gf,"  %s\n  {\n",GR_G_P);
fprintf(gf,"    %s = %d;\n",GR_M_nproc,hwt);
if(hwt>0) {
 j=fprintf(gf,"    %s = ",GR_M_proc_name);
 if(hwt>1) for(i=0; i<hwt-1; i++) {
   j += fprintf(gf,"\"%s\", ",GetProcName(i));
   if(j>=MXL){j=4; fprintf(gf,"\n    ");}
 }
 fprintf(gf,"\"%s\";\n",GetProcName(hwt-1));

 j=fprintf(gf,"    %s = ",GR_M_speed);
 if(hwt>1) for(i=0; i<hwt-1; i++) {
   j += fprintf(gf,"%d, ",He[i]);
   if(j>=MXL){j=4; fprintf(gf,"\n    ");}
 }
 fprintf(gf,"%d;\n",He[hwt-1]);

 j=fprintf(gf,"    %s = ",GR_M_pcomm);
 if(hwt>1) {	for (i=0; i<hwt-1; i++) {
			for (k=0; k<hwt; k++) {
			  j += fprintf(gf,"%d,",Hg[i*hwt+k]);
			  if(j>=MXL){j=4; fprintf(gf,"\n    ");}
			}
			fprintf(gf,"\n            ");j=12;
			}
		for (k=0; k<hwt-1; k++) {
		  j += fprintf(gf,"%d,",Hg[(hwt-1)*hwt+k]);
		  if(j>=MXL){j=4; fprintf(gf,"\n    ");}
		}
 }
 fprintf(gf,"%d;\n",Hg[hwt*hwt-1]);
}
fprintf(gf,"  }\n");
}

/***********************************************************************/
void GRPflushResult(FILE *gf, float ii, int cc, char *mm)
{ /* MASTER process will be shown in the result GRP file group as last one */
  int i,j;
  fprintf(gf,"  %s\n  {\n",GR_G_R);
  j=fprintf(gf,"    %s = ",GR_M_location);
  for (i=0; i < swt-1; i++) {
    j += fprintf(gf,"%d,",Loc[i]);
    if(j>=MXL){j=4; fprintf(gf,"\n    ");}
  }
  fprintf(gf,"%d;\n",Loc[i]);
  fprintf(gf,"    imbalance = %.2f;\n",ii);
  fprintf(gf,"    comm_cost = %d;\n",cc);
  fprintf(gf,"    method = \"%s\";\n",mm);
  fprintf(gf,"    time = %.2f;\n",timeconsum);
  fprintf(gf,"  }\n");
}

/***********************************************************************/
static void GRPwriteResult()
{ /* process[swt-1] is master, it should be fix-mapped on the root (#0) */
int i;
if(swn!=NULL) {
  fprintf(fo,"%d\n",swt-MASTER);
  for(i=0;i<swt-MASTER;i++) {
    fprintf(fo,"%s ",getTASKNAME(i));
    fprintf(fo,"%s\n", GetProcName(Loc[i]));
  }
}
}

/***********************************************************************/
static void GRPflushEditor(FILE *gf)
{  
int i,j; int x,y;
fprintf(gf,"  %s\n  {\n",GR_S_E); /* Editor section */
fprintf(gf,"  %s\n  {\n",GR_G_XY); /* ProcXY group */
x=XSTART; y=YSTART; j=fprintf(gf,"   ");
for(i=0;i<swt-MASTER;i++) {
  j += fprintf(gf," %s = %d,%d;",getTASKNAME(i),x,y);
  x+=XSTEP;if(x>XMAX){x=XSTART;y+=YSTEP;} if(y>YMAX)y=YSTART;
  if(j>=MXL){j=3; fprintf(gf,"\n   ");}
}
fprintf(gf,"  }\n  }\n");
}

/******************************************/
static int FindInPort(int from, int to)
{
int j,k;
k=1;
/* for(j=0;j<cht;j++) if(Cg[j][0]==to) k++; */
for(j=0;j<cht;j++) if(Cg[j][1]==to) {
  if(Cg[j][0]==from) return(k);
  else k++;
}
return(-1); /* error */
}
/******************************************/
static int FindOutPort(int from, int to)
{
int j,k;
k=1;
for(j=0;j<cht;j++) if(Cg[j][1]==from) k++;
for(j=0;j<cht;j++) if(Cg[j][0]==from) {
  if(Cg[j][1]==to) return(k);
  else k++;
}
return(-1); /* error */
}

/***********************************************************************/
static int GRPflushProgram(FILE *gf)
{
#define SEQH fprintf(gf,"SEQ: %d \"seq\"\n{\n",d++); \
  fprintf(gf,"  Cin 1: {%d}\n  Cout 2: {%d}\n}\n",b,b+1); b++
#define SEQT(A) fprintf(gf,"{@ for(i=0;i<%d;i++)j=3*i;}\n",A*1000)
int i,j,k,d,b,err;
       
fprintf(gf,"%s\n{\n",GR_HP); /*"ProgramPart"*/
d=b=1; err=FALSE;
for(i=0;i<swt-MASTER && !err;i++) { k=1;
  fprintf(gf,"  %s%s\n   HeaderSection\n   {\n",GR_P,getTASKNAME(i)); /*"Process: "*/
  fprintf(gf,"Heads {@  } Global {@  } Local {@  int a[1],i,j;}\n   }");
  fprintf(gf,"   %s\n   {\n",GR_P_P); /*"PortSection"*/
  
  for(j=0;j<cht;j++) if(Cg[j][1]==i && (MASTER==0 || Cg[j][0]!=fixed))
    fprintf(gf,"%s%d   { %s%s; PortID: %d; Type int[1]; }\n", /*"InPort: ","Proc: "*/
	    GR_P_PI,k++, GR_P_PP,getTASKNAME(Cg[j][0]), FindOutPort(Cg[j][0],i));

  for(j=0;j<cht;j++) if(Cg[j][0]==i && (MASTER==0 || Cg[j][1]!=fixed))
    fprintf(gf,"%s%d   { %s%s; PortID: %d; Type int[1]; }\n", /*"OutPort: ","Proc: "*/
	    GR_P_PO,k++, GR_P_PP,getTASKNAME(Cg[j][1]), FindInPort(i,Cg[j][1]));

  fprintf(gf,"   }\n   ProgramSection\n   {\nDUMMYB: %d \"\" {Cout 1: {%d}}\n",d++,b);
/*  SEQH; SEQT(Sg[i]);
  fprintf(gf,"CAI: %d \"I\" {Cin 1: {%d} Cout 2: {%d} Port 1: {@ a};}\n",
	  d++,b,b+1);b++;
  SEQH;
  fprintf(gf,"CAO: %d \"O\" {Cin 1: {%d} Cout 2: {%d} Port 2: {@ a};}\n",
	  d++,b,b+1);b++;
  SEQH;
*/  
  err=(fprintf(gf,"DUMMYE: %d \"\" {Cin 1: {%d}}\n   }\n",d++,b)<0);
  if (err) printf("...file write error: %d\n",err);
}
fprintf(gf,"  }\n\nScreenPart{}\n");
return(err);
}

/***********************************************************************/
static int GRPflush(int grpsavED)
{int i,j;
 char mm[2]={'\0','\0'};
 char *apn=NULL,*pp=NULL,*saved=NULL, *bb=NULL, cc='\0';
 
 if((gfo = fopen(TEMPNAME, "w")) == NULL) {
   printf("Cannot open %s as TEMP_GRP_file !\n",TEMPNAME);
   ex(2) }
 if(grpname[0]=='-') apn=strdup(HWDEFAULT); else apn=strdup(grpname);
 if ((pp=strstr(apn,SUFF))!=NULL) {cc=*pp; *pp='\0';} 
 {
   if(appname!=NULL) bb=appname;
   else {  if((bb=strrchr(apn,'/'))==NULL) bb=apn; else bb++;
	   printf("Application: %s\n",bb); }
   fprintf(gfo,"Application: %s\n{\n",bb);
 }
 if (pp!=NULL) *pp=cc; 
  
 printf("...saving%s\n",BL);
 fprintf(gfo,"HeaderPart\n{\n");
 if(grpsavED)GRPflushEditor(gfo);
 fprintf(gfo,"  %s\n  {\n",GR_S_M); /* MappingSection */
 if(grpsavOp)GRPflushOption(gfo);
 if(grpsavSw)GRPflushSw(gfo);
 if((hgrd && npvm>0) || !grpfound)GRPflushHw(gfo);
 mm[0]=mode; if(grpsavRe)GRPflushResult(gfo,Imb(),Comm(),mm);
 fprintf(gfo,"  }\n}\n");
 i=0; if(grpsavED)i=GRPflushProgram(gfo); /* i = write error */
 fprintf(gfo,"}\n");
 fclose(gfo); /* TEMPNAME */
 if(i>0) { unlink(TEMPNAME); 
	 free(apn); apn=NULL; printf("Warning: application is not updated!\n"); ex(3) }
 grpsavOp=grpsavSw=grpsavRe=grpsavED=FALSE;
  
 strcpy(buff,"");
 pp=getenv(GRPPATH);
 if(pp==NULL || strlen(pp)==0)
   /*    printf("Warning: environment variable %s is not set!\n",GRPPATH) */ ;
 else { strcpy(buff,pp); strcat(buff,GRPPATHb); }
 
 strcat(buff,GRPPARS); strcat(buff,GRPMERGE); pp=strdup(buff);
 if(grpname[0]!='-' && grpfound)
   sprintf(buff,"%s %s %s > %s\n",pp,apn,TEMPNAME,TEMP_TMP); /* merge added info */
 else
   sprintf(buff,"%s %s > %s\n",pp,TEMPNAME,TEMP_TMP); /* try check it */
 free(pp); pp=NULL;
 j=printf("...calling an external program \"%s\"%s\n",GRPPARS,BL);
 i=(system(buff)==0);
 if (!i) { /* checking error or GRPPARS bug */
   cprintf("warning: some error has appeared in the external program %s\n",GRPPARS);
   unlink(TEMP_TMP); rename(TEMPNAME,TEMP_TMP); /* try use non-checked file */
 } else { buff[j--]='\0'; for(;j>=0;j--) buff[j]=' '; printf("%s\r",buff); }
 
 saved=apn;
 if ((fi = fopen(apn, "r")) != NULL) {
   if (!i || strcmp(apn,grpname)!=0 || !grpok || strstr(grpname,PREF)==grpname ) {
     printf("warning: will not overwrite %s !\n",apn);
     saved=TEMP_TMP; cprintf("\tNew GRP application is saved to:%s\n",TEMP_TMP);
     i=FALSE;
   }
   fclose(fi);
 } else i=TRUE;  /* new created file will be used also in non-checked fashion */
 
 if(i) { if (rename(TEMP_TMP,apn)!=0) {
	   sprintf(buff,"%s %s %s\n",COPY,TEMP_TMP,apn);
	   printf("...moving%s\n",BL);
	   if(system(buff)<0) i=FALSE;
	   else { sprintf(buff,"%s %s\n",DELETE,TEMP_TMP); system(buff); }
	 }
	 if(i) { cprintf("  saved to: %s\n",apn); }
	 else {saved=TEMP_TMP; cprintf("  saved to: %s\n",TEMP_TMP);}
 }
 
 unlink(TEMPNAME);
 if(grpname[0]=='-') {
   sprintf(buff,"#PVM=%d  Saved to:%s",npvm,saved);
   View_hw(buff,TRUE);
 } 
 free(apn); apn=NULL;
return(0);
}

/***********************************************************************/
int GRPsave()
{int i,grpsavED;

 grpsavED=!grpok;
 if(!grpfound && swt>0) grpsavOp=grpsavSw=grpsavRe=grpsavED=TRUE;
 if(DLBorig!=DLBisON || (grpsavRe && modeGRP!=mode)) grpsavOp=TRUE;
 i=0;
 if(grpsavOp || grpsavSw || hgrd || grpsavRe || grpsavED)
   i=GRPflush(grpsavED);
 GRPwriteResult();
 fclose(fo);
 return(i);
}

