/* function Hme for pmap.c & xpmap.c */

#include "pmap.h"
/*#include <string.h>*/
		/* skip some result from slow worker? : set TH > 1 ! */
#define TH 2	/* 1/TH of workers should be ready for collecting */

/*****************************************************************************/
/*  H M E  ****  Microprocessing and Microprogramming 36 (1992/93) 83-92pp   */
/*  S.Selvakumar & C.Siva Ram Murthy: An efficient heuristic algorithm for   */
/*  mapping parallel programs onto multicomputers */
/* je to dost cudne: ak fronta neklesa a nie je plna, vyprazdnuje sa ! */

#define LLL 3		/* dlzka fronty pre costy - parameter */
			/* int Loc[NILTASK];	 * pracovna konfiguracia */
static int *LocOpt=NULL;/* int LocOpt[NILTASK];   optimalna konfiguracia */
static int queue[LLL];	/* fronta pre odkladanie hodnot */
static int itersave=-1;	/* for detecting non started HME */ 
static int queuelength, costLoc, costOpt, RRR, killed=FALSE;

static int CostEval() { return( (alpha*Comm()) + (beta*ImbAbs()) ); }

/****************/
static void Initconfig()
{
int i,j;
if(me<=0) if((LocOpt = (int *) malloc(swt*sizeof(int)))==NULL)EXM
queuelength=0; RRR=swt/2; /* 2*swt ale z clanku: 2..10 */
for (i=0;i< swt ;i++) {j=Loc[i]=Rand(hwt); if(me<=0) LocOpt[i]=j;}
if(fixed>=0) {Loc[fixed]=0; if(me<=0) LocOpt[fixed]=0;}
SetLoad(); costOpt=costLoc=CostEval();
}

/****************/
static int HMEmove(int kill)		/* vykona najviac jeden - najlepsi */
{
int i,k,loc,cost, ktory,kam,kolko;
ktory=kam=-1; kolko=costLoc;
for(i=0;i<swt;i++) if (i!=fixed) {
  if(kill && (killed || ProbeKill()))   /* not needed computing */
    { killed=TRUE; return(FALSE); }
  loc=Loc[i];
  for(k=0; k<hwt ; k++) {
	Move(i,k,TRUE);
	if((cost=CostEval()) < kolko) { kolko=cost; ktory=i; kam=k; }
	Move(i,loc,TRUE);
	}
  }
costLoc = kolko; return(Move(ktory,kam,TRUE)); /* ci bol uskutocneny */
}

/****************/
static int Exchange(int kill)		/* vykona najviac jednu - najlepsiu */
{
int cost,i,j,loc1,loc2, ktory1,ktory2,kam1,kam2,kolko;
ktory1=ktory2=kam1=kam2=-1; kolko= costLoc;
for (i=0; i<swt; i++) if (i!=fixed) {
  if(kill && (killed || ProbeKill()))   /* not needed computing */
    { killed=TRUE; return(FALSE); }
  loc1=Loc[i];
  for (j=0; j<swt; j++) if (j!=fixed && j!=i && (loc2=Loc[j]) != loc1) {
	Move(i,loc2,TRUE); Move(j,loc1,TRUE);
	if ((cost=CostEval()) < kolko)
		{ kolko=cost; ktory1=i; ktory2=j; kam1=loc2; kam2=loc1; }
	Move(i,loc1,TRUE); Move(j,loc2,TRUE);
	}
  }
costLoc = kolko; return(Move(ktory1,kam1,TRUE) && Move(ktory2,kam2,TRUE));
}

/****************/
static int Controlqueue()
{
int i,inprogress;
static int clear=0;
#define len queuelength
#define MAXCLEAR 10 /* queue clear limit (times) */
/*4*/
if(len < LLL) queue[len++]=costLoc;
else { for (i=0;i<LLL-1;i++) queue[i]=queue[i+1]; queue[LLL-1]=costLoc; }
/*5*/
if(costLoc < costOpt) { costOpt=costLoc; for(i=0;i<swt;i++) LocOpt[i]=Loc[i]; }
if (costOpt==0) return(FALSE);
/*6*/
inprogress=TRUE; for (i=0;(i<len-1 && inprogress);i++)
			if (queue[i+1] >= queue[i]) inprogress=FALSE;
if(inprogress) return(TRUE);
if(len==LLL) return(FALSE);
if(clear++<MAXCLEAR) {queue[0]=queue[len-1]; len=1; return(TRUE);}
return(FALSE);
}

static void RandMoves() { int i;
			for(i=0; i<RRR; i++) Move(Rand(swt),Rand(hwt),TRUE); }

/****************/
static void PrintQueue(int t)
{
int i;
/*return;*/
printf("\n");
if(t>0) { for(i=0;i<queuelength;i++) printf("%6d ",queue[i]);
	for(i=queuelength;i<LLL;i++) printf("     - "); }
if(t>1) {i=Comm();printf("Imb=%5.2f%% Comm=%d\tImb=%d ",Imb(),i,costOpt-i);}
if(t>0) printf("\r%s\n%1$s",BL);
}

/*********************************************/
void HmeFinish() /* also used by X-interface */
{int i;
if(itersave<0) return;
if(costLoc > costOpt) { for(i=0;i<swt;i++) Loc[i]=LocOpt[i]; SetLoad(); }
iter=queuelength; PrintQueue(2);
iter=itersave; itersave=-1;
PrintQueue(0);
}

/************************************/
void Hme()
{
extern int pvm_lvgroup(char *gr);
int i=0, it=0, next, repalg=TRUE, was=FALSE;

ReadTime();
Initconfig();				/*krok 1*/
itersave=iter; /* must be after Initconfig() !!! */
iter=0;	/* iter/STAGES urcuje animacny krok */
if(me>0)	/* worker */
{ 
  for(i=0;i<me;i++)Rand(MAXINT); /* to be different workers */
  while(repalg) { 
    PG_start("spread");
    i=RecvStartLoc(&repalg);
    PG_end("spread");
    SetLoad();
    RandMoves(); costLoc=CostEval();
    next=repalg; while (next) {while(HMEmove(TRUE)); next=Exchange(TRUE);}
    if(killed) PG_start("kill");
    PG_start("best");
    if(repalg && !killed) SendLoc(costLoc,i);
    PG_end("best");
  }
}
else		/* master */
{
while(repalg && !Xstop)
  {  costLoc=CostEval();
    /*i=0;printf("\n");Animat(i++);	* nove okno */
    Animat(i++); PrintQueue(1);
    if(!was) { /* parallel also the first loop : */
      PG_start("spread");
      if(nptsk>1) {was=TRUE; SpreadStartLoc(repalg,it);}
      PG_end("spread");
    }	
    next=TRUE;
    while (next && !Xstop)
      {
	while(!Xstop && HMEmove(FALSE))Animat(i++);	/*krok 2*/
	if(!Xstop) next=Exchange(FALSE);		/*krok 3*/
	if(!Xstop) Animat(i++);
      }
    if(!Xstop) {
        PG_start("best");
	if(nptsk>1 && was) if(CollectLoc(costLoc,TH,it++))
		{ SetLoad(); costLoc=CostEval(); }	/* find the best */
        PG_end("best");
	repalg=Controlqueue();	/*krok 4,5,6*/
	iter=queuelength; PrintQueue(2);
        PG_start("spread");
	if(nptsk>1) {was=TRUE; SpreadStartLoc(repalg,it);}
        PG_end("spread");
	if (repalg) RandMoves();	/*krok 7*/
	}
  }
}
if(killed) PG_end("kill");
if(me==0){ SendKill(); SA_HME_deleteReady(); } /* clear receive buffers */
if(Xstop){if(!NoPVMrunning()){KillGroup(); pvm_lvgroup(GROUP);me=-1;}}
if(me<=0)HmeFinish();
free((void *)LocOpt); LocOpt=NULL;
}
