/* replacement for those PVM functions, which PG does not support */

#include "pmap.h"
#include "pvm3.h"

#define NGROUP 2
#define GR0 GROUP
#define GR1 GROUP1
#define MONITLEVEL 2		/* 0,1,2 */
/* 0: 	-> the utilization view shows 100% for a barrier period, not a reality !
   but the behavior is not changed, i.e. acts as if PG_PVM is not  defined */
/* 1: barrier via mcast				-> pg_mcast is verbose; is compatible with level 2 */
/* 2: barrier via mcast + mcast via send	-> no verbose output */
/* in all these levels pvm_bcast is replaced by : */

#if MONITLEVEL == 2
 /* pvm_mcast via pvm_send; pg_mcast is verbose ! */
 /* bez tohoto PG_PVM_MCAST nechutne vypisuje hlasenia o tom, komu 
    vsetkemu sa mcast-uje */
 /* asi dost zasahuje do povodnej kominikacnej schemy !!! */

static int my_mcast(int *tids, int ntask, int T)
 {int i,r,s,m;
  m=pvm_mytid();
  for(i=r=0;i<ntask;i++)if(tids[i]!=m && (s=pvm_send(tids[i], T))<0) r=s;
  return(r);
 }
#else
 #define my_mcast pvm_mcast	/* original pvm OR pg */
#endif


static int *gti[2];  /* group members tids */
static int gsi[2]; /* actual size of *gti table */
static int get_group(char *);
static void fill_tids(char *, int);


/*------------------------------------*/

int my_bcast(char *G, int T)
{int s,g;
 g=get_group(G);
 if((s=pvm_gsize(G))!=gsi[g]) fill_tids(G,s);
 return(my_mcast(gti[g],gsi[g], T));
}

static int get_group(char *G)
{ if(strcmp(G,GR0)==0) return(0);
  if(strcmp(G,GR1)!=0) EXM else return(1);
}

static void fill_tids(char *G, int s)
/* aktualizuje tid-y prislusnikov skupiny G */
{int i,t,e,g;
 g=get_group(G);
 if((gti[g] = (int *) realloc((void *)gti[g], s*sizeof(int)))==NULL)EXM
 for(i=e=0;i<s;i++)
   { while((t=pvm_gettid(G,i+e))<0)e++; gti[g][i]=t; }
 if(e>0)vypis("\n warning: nesuvisla grupa: %d\n",e);
 /* vypis(" Group size changing...%d -> %d\n",gsi[g],s); */
 gsi[g]=s;
}

/*-----------------------------------------------------------*/

#if MONITLEVEL == 0
 /* the utilization view shows 100% for a barrier period, not a reality ! */
 int my_barrier(char *G, int c)
 {int r; PG_start("barr"); r=pvm_barrier(G,c); PG_end("barr"); return(r); }
#else
 int my_barrier(char *G, int c)
 /* all group G first c instances must be involved! */
 {int s,g,i,mytid;
 
 PG_start("barr");
 g=get_group(G);
 /* vypis("bariera %d zacina  \n",g);*/
 
 if(pvm_getinst(G, (mytid=pvm_mytid()))>0) { 
   pvm_initsend(PvmDataDefault); pvm_pkint(&mytid,1,1);
   s=pvm_send( pvm_gettid(G, 0), g );
   pvm_recv( pvm_gettid(G, 0) , g );
 }
 else {
   for(i=1;i<c;i++) pvm_recv( -1, g );
   if((s=pvm_gsize(G))<c) {
     PG_start("wait");
     while((s=pvm_gsize(G))<c);
     PG_end("wait");
   }
   if((s=pvm_gsize(G))!=gsi[g]) fill_tids(G,s);
   pvm_initsend(PvmDataDefault); pvm_pkint(&mytid,1,1);
   s=my_mcast(gti[g],c, g); if(s<0)vypis("! MCAST error %d\n",s);
 }
 
 /* vypis("bariera %d konci\n",g);*/
 PG_end("barr");
 return(s);
}

#endif
