/* PVM-oriented functions for pmap.c & xpmap.c */

#include "pmap.h"
#include <sys/time.h>
#include <string.h>
#include <unistd.h>  /* getuid, sleep */

#define PROCN "T"
extern char **hwn;

#ifdef NOPVM
struct pvmhostinfo { int hi_tid; char *hi_name; char *hi_arch; int hi_speed; };
#else
#include "pvm3.h"
#endif

int narch=0;			/* for X-interface: not static! */
struct pvmhostinfo *hi=NULL;	/* for X-interface: not static! */

char *GetProcName(int i) {if(hgrd)return(hi[i].hi_name);
			  if(hwn!=NULL)return(hwn[i]);
			  sprintf(buff,"%s%d",PROCN,i);
			  return(buff);}


/* ============ substitutions for versions without PVM  ==================== */

#ifdef NOPVM
int NoPVM() { return(TRUE); }
void KillGroup(){}
int NoPVMrunning() { return(TRUE); }
void SpawnAdded(char *taskname, int rea){}
int GetHgInfo(){return(0);}
int GetHgTables(char *taskname){return(0);}
void SynchData(int tsk, int tgt){}
void SpreadData(){}
void GetData(){}
void SendTime(int t){}
int CollectTime(int myt){return(0);}
void SpreadStartLoc(int rep, int it){}
int RecvStartLoc(int *rep){return(0);}
void SendLoc(int cost, int it){}
int CollectLoc(int mycost, int th, int it){return(0);}
void SAspreadT(double max, double min){}
void SArecvT(double *max, double *min){}
void SAgetLoc(int who, int *map){}
int SAfindWho(){return(0);}
void SAsendCross(int who, int *map){}
void SAgetCross(int *map){}
int SAsynchro(double *T, int R){return(0);}
int SAsendLoc(int cost){return(0);}
int SAcollectLoc(int mycost,int *map){return(0);}
void SAready(int it){}
int SAwhoisReady(int a, int *m, int th){return(0);}
void SAdeleteReady(int it){}
int ProbeKill() {return(0);}
void SendKill() {}
void SA_HME_deleteReady() {}
void ReorganizeHW() {}
int pvm_exit() {return(0);}
int pvm_gsize(char *G) {return(0);}
int pvm_lvgroup(char *G) {return(0);}
int pvm_config( int *nhost, int *narch, struct pvmhostinfo **hostp ) {return(0);}
    
#else

/* ============== parallel part - PVM calls ... ============================ */

#define DEBUG FALSE
#define BLOCK 1024	/* test message size */
#define LOOPS 1		/* repeat transfer */
#define KILLTIME 10	/* repeat group killing */
static void GetHgRd();
static void SpreadHgRd();
static void Measure(int dest);
static void Recv_row(int dest);
static void Reply(int dest);
static void Send_row();
static void Send_eff(int eff1, int eff2);
static void Recv_eff(int dest);
static int get_efficiency();
static int CheckVersion();
static int mytid, child, myhost;

#ifdef MY_BCAST_BARRIER /* if PG_PVM is active to avoid receive errors */
 #define pvm_bcast my_bcast
 #define pvm_barrier my_barrier
 extern int my_bcast(char *G, int T);
 extern int my_barrier(char *G, int c);
#endif

int NoPVM() { return(FALSE); } /* for X-interface */

/* pvm_addhosts je deklarovana v "pvm3/src/lpvmgen.c" */
/* #include <sys/types.h>	*/

void KillGroup() /* killing all but me in the named GROUP & rejoint me */
{
int i,j,k,size,tid;
 cprintf("\nBREAK%s","");printf(": Group \"%s\" was in use: killing...\n",GROUP);
 sleep(1);
 for(k=0;k<KILLTIME && (size=pvm_gsize(GROUP))>1;k++) {
   for(i=j=0;i<size;i++) {
     while((tid=pvm_gettid(GROUP,j))<0 && j<100*size)j++;   /* overstep gap */
     if(j!=me && tid>=0)pvm_kill(tid);	/* without me ! */
     j++;
   sleep(1);
   }
 }
 if(size>1)
   {printf("group killing PVMerror: %d member(s) are not killed!\n",--size); exit(2);}
 pvm_lvgroup(GROUP); me=pvm_joingroup(GROUP); /* rejoint */
}

static int ChooseHost()
{int i,j,s;j=Rand(sumspeed);for(i=s=0;s<=j;i++) s+=hi[i].hi_speed;return(--i);}

static int SpawnTask(char *taskname, int i)
{
int j,k; char *n[2],num[32];
sprintf(num,"%d",hwt); n[0]=num; n[1]=NULL;
if(i<0) k=pvm_spawn(taskname, n, PvmTaskDefault,(char*)0, 1, &j); /*somewhere*/
else k=pvm_spawn(taskname, n, PvmTaskHost,hi[i].hi_name, 1, &j);
return(k);}

int NoPVMrunning()
{ 
  char n[32]; FILE *f; sprintf(n,"/tmp/pvmd.%d",(int)getuid());
  if((f = fopen(n, "r")) == NULL) return(TRUE); else {fclose(f); return(FALSE);}
}

void SpawnAdded(char *taskname, int rea) /* change "nptsk" */
{
int i,j; 
j=hwt-nptsk; if(!rea) j=-1;
if(me==0 && j>0 && hwt<=(NTASKperHOST*npvm)) {
 char num[10];sprintf(num," +%d",j+npvm);cprintf("%s",num);
 for(i=0;i<j;i++)	/* spawn also "hwt" value */
    if(SpawnTask(taskname,ChooseHost()) < 1) {
	printf("\nNO MORE REMOTE PROCESSES...%d < %d ",i,j);
	while((j=pvm_gsize(GROUP1)) < i && j>=0);  /* wait for all have run */
	for(j=0;j<i;j++)pvm_kill(pvm_gettid(GROUP1,j)); j=-1;
	}
 if(i==j) {	nptsk+=j; pvm_joingroup(GROUP1);
		pvm_barrier(GROUP1, j+1); pvm_lvgroup(GROUP1);
		}
 }
if(me>=nptsk){pvm_barrier(GROUP1, j+1); pvm_lvgroup(GROUP1);}
}

/* --------------------------------------------------------------------- */
static int Findhost(int tid)
{
int i,j, t;
 t=pvm_tidtohost(tid);i=-1; for (j=0; j<npvm; j++) if (hi[j].hi_tid == t) i=j;
 if (i<0) {printf("PVM-host error\n"); exit(2);} return(i);
}

/* ==================== GetHgInfo =========================================== */
/* ======= concact PVM - get "me", "npvm" ================================== */
int GetHgInfo()
{
#define skonci(XX) {printf("- %s -\n", XX );if(me>=0) {pvm_lvgroup(GROUP); \
  pvm_exit();}return(0);}
extern int pvm_catchout(FILE *ff);

me=myhost=mytid=-1; npvm=0; if(NoPVMrunning()) skonci("no PVM host");
mytid = pvm_mytid(); if(mytid<0) skonci("PVM not running");
if(DEBUG)pvm_catchout(stdout);
me = pvm_joingroup(GROUP); if(me<0) skonci("bad group server");
pvm_config(&npvm, &narch, &hi);
myhost = Findhost(mytid); if (myhost>=npvm) skonci("!2");
{int i;for(i=sumspeed=0;i<npvm;i++) sumspeed += hi[i].hi_speed;}
/* if(DEBUG)pvm_setopt(PvmDebugMask,1); */
if(nghbr==0) {nghbr=npvm-1; if(nghbr<0)nghbr++;}
return(npvm);
}

static char hiname[8];
static char* Hi(int i) { strncpy(hiname,hi[i].hi_name,7); return(hiname); }
char* Hname(int i) { return(Hi(myhost)); }


/* ==================== GetHgTables ========================================= */
/* V prvej faze sa na kazdom host-procesore 'nhost' spusti po jednom procese
   (z tohto programu) a tym sa zaruci, ze prvych 'nptsk' clenov grupy
   'GROUP' maju cisla 0..nptsk-1. Overi sa, ci je zhodna verzia.
   Kazdy si spusti dvojca-proces. Odmeria sa vykonnost procesora He[].
   Rozosle sa poziadavka na meranie -> hgrd.
  Dalsie fazy prebehnu len ak hgrd==TRUE :
   V druhej faze si dvojicky odmeraju komunikaciu.
   V tretej faze si postupne odmeraju komunikacie host-procesory medzi sebou.
   Vo stvrtej faze sa vratia vysledky merania procesu me=0 a ten ich zobrazi.
  Su 4 typy procesov (podla "me"): root, meraci, dvojca, pridavny. (#nptsk)
  Dvojca sa nekor moze pouzit a ak by ich pocet nestacil, nastartuju sa
   pridavne procesy (ak by ich vyslo menej nez NTASKperHOST na uzol).
*/
int GetHgTables(char *taskname)	/* hwt==npvm > 0 */
{
int i, j, k, e1=0,e2=0,e3=0, err=FALSE;

if(npvm<=0) return(0);
/* prva faza : ------------------------------------------------------------ */
if(me == 0) {
  for (k=i=0; i<npvm; i++) if (i != myhost)
  if(pvm_spawn(taskname, (char**)0, PvmTaskHost,hi[i].hi_name, 1, &j) <= 0) {
    cprintf("\nPVMerror: host \"%s\" cannot spawn an instance!",hi[i].hi_name);
    k++;
  }
  if(k>0) { KillGroup(); nptsk=npvm=0;if(hgrd)hwt=0; me=-1; pvm_exit(); return(0);}
}
if(DEBUG) printf("me=%d  mytid=0x%x  myhost=%s\n",me,mytid,hi[myhost].hi_name);
if(me < (nptsk=npvm)) {
  pvm_barrier(GROUP, nptsk); i=myhost;
  if(CheckVersion()) err=TRUE;
  if(pvm_spawn(taskname, (char**)0, PvmTaskHost,hi[i].hi_name, 1, &child)<=0) {
    cprintf("\nPVMerror: host \"%s\" cannot spawn its child!",hi[i].hi_name);
    err=TRUE;
  }
  if(err) { KillGroup(); nptsk=npvm=0; me=-1; pvm_exit(); return(0); }
  e1=get_efficiency(&e2);
}

if(me < (nptsk=2*npvm))pvm_barrier(GROUP, nptsk);
if(me ==  0)	SpreadHgRd(); 			/* root proces */
else if(me < 2*npvm) GetHgRd();	/* meraci proces alebo dvojca */
else {hgrd=FALSE; pvm_joingroup(GROUP1);}	/* pridavny proces */

if(me == 0 && !gred) printf(" #PVM=%d                  ",npvm);
if(hgrd)
{
hwt=npvm;
if((He = (int *) realloc((void *)He, 2*hwt*sizeof(int)))==NULL)EXM
if((Hg = (int *) realloc((void *)Hg, hwt*hwt*sizeof(int)))==NULL)EXM
for(i=0;i<npvm;i++) {He[i]=He[i+npvm]= 1; for(j=0;j<npvm;j++) Hg[i*hwt+j] = 0; }
if(me == 0 && !gred) {
  printf("\n");for (i=0; i<npvm; i++) printf("\t%7s", Hi(i)); printf("\n");}
/* druha faza : ----------------------------------------------------------- */
for (j=0; j<LOOPS; j++)
		if (me < npvm) Measure(child); else Reply(pvm_parent());
/*while((me<npvm) && pvm_gsize(GROUP) > npvm); ..caka sa na koniec dvojciat*/
/* tretia faza : ---------------------------------------------------------- */
if (me < npvm) for (j=0; j<LOOPS; j++) for (k=0; k<npvm; k++)	{
					pvm_barrier(GROUP, npvm); 
	if ( me == k ) for (i=0; i<npvm; i++) {if (i!=me)
					Measure(pvm_gettid(GROUP,i));}
	else Reply(pvm_gettid(GROUP, k));
								}
/* stvrta faza : ---------------------------------------------------------- */
if ( me == 0 ) for (i=1; i<npvm; i++) Recv_row(pvm_gettid(GROUP,i));
else if (me < npvm) Send_row();

if ( me == 0 ) { He[myhost]=e1; He[npvm+myhost]=e2;
		 for (i=1; i<npvm; i++) Recv_eff(pvm_gettid(GROUP,i));
		 for (e3=i=0; i<npvm; i++) if(e3<He[i]) e3=He[i]; /* maximum */
		 e3 *=100; for (i=0; i<npvm; i++) hi[i].hi_speed=e3/He[i];
		 for(i=sumspeed=0;i<npvm;i++) sumspeed += hi[i].hi_speed;
		 for (j=i=0; i<npvm; i++) j += He[i]; averspeed = j/npvm;	   
} /* replace speeds read from PVM database with measured ones */
else if (me < npvm) Send_eff(e1,e2);

if ( me == 0 && !gred)	{
  for (i=0; i<npvm; i++) { printf("%7s\t", Hi(i));
			   for (j=0; j<npvm; j++) printf("%7d\t",Hg[i*hwt+j] /= LOOPS);
			   printf("\n");
  }
}
if ( me == 0 && !gred)	{
  printf("\nspeed:\t");		for (j=0; j<npvm; j++) printf("%7d\t",hi[j].hi_speed);
  printf("\n1/efficiency:\n[ms]\t");  for (j=0; j<npvm; j++) printf("%7d\t",He[j]);
  printf("\n[us]\t");		for (j=0; j<npvm; j++) printf("%7d\t",He[npvm+j]);
  printf("\n");
}

if(me == 0 && gred) printf("... measuring of #%d PVM hosts is done\n",npvm);
}
/*Task_vypis();pvm_exit();exit(0);*/
/*if(me>=npvm) {pvm_lvgroup(GROUP); pvm_exit(); exit(0);} ...koniec dvojcata*/
return(npvm);
}

#define MSGTAG 5
/* Message Tag == 0 or 1 is reserved for my_barrier !!! */
#define STRIDE 1
#define SA_HME_RDY 100
#define COUNT BLOCK
static int mess[BLOCK];

/* old functioun using slow pvm_hostsync...
static void Measure(int dest)
{
int t, myhosttid, bufid; struct timeval start, stop, delta;
\*vypis("0x%x -> 0x%x\t",mytid,dest);*\
pvm_recv( dest, MSGTAG ); \* synchro *\
bufid=pvm_initsend( PvmDataDefault );
pvm_pkint( mess, COUNT, STRIDE );
pvm_hostsync((myhosttid=pvm_tidtohost(mytid)),&start,&delta);
pvm_setsbuf(bufid); \* hostsync pouziva r aj s buffer!! *\
pvm_send( dest, MSGTAG );		bufid=pvm_recv( dest, MSGTAG );	
pvm_hostsync(myhosttid,&stop,&delta);
pvm_setrbuf(bufid); \* hostsync pouziva r aj s buffer!! *\
\* pvm_upkint( mess, COUNT, STRIDE ); not needed *\
\*  t=1000000*delta.tv_sec + delta.tv_usec;			*\
\*  if (t>0) printf("<> +"); else printf("<> ");		*\
\*  printf("%4dus\t",1000000*delta.tv_sec + delta.tv_usec); 	*\
t = stop.tv_sec - start.tv_sec; t *= 1000;	\*  s -> ms *\
t += (stop.tv_usec - start.tv_usec)/1000;	\* us -> ms *\
Hg[myhost*hwt+Findhost(dest)] += t;
\* vypis("%s\t%dms\n", hi[Findhost(dest)].hi_name,t); *\
}
*/

static void Measure(int dest)
{
int t; struct timeval start, stop;
pvm_recv( dest, MSGTAG ); /* synchro */
pvm_initsend( PvmDataDefault ); pvm_pkint( mess, COUNT, STRIDE );
gettimeofday(&start, (struct timezone *) NULL);
pvm_send( dest, MSGTAG );		pvm_recv( dest, MSGTAG );	
gettimeofday(&stop, (struct timezone *) NULL);
t = stop.tv_sec - start.tv_sec; t *= 1000;	/*  s -> ms */
t += (stop.tv_usec - start.tv_usec)/1000;	/* us -> ms */
Hg[myhost*hwt+Findhost(dest)] += t;
}

static void Reply(int dest)
{
pvm_initsend( PvmDataDefault );	pvm_send( dest, MSGTAG ); /* synchro */
pvm_initsend( PvmDataDefault ); pvm_pkint( mess, COUNT, STRIDE ); /* prepare */
pvm_recv( dest, MSGTAG );
/* vypis("0x%x <= 0x%x\t",mytid,dest); */
/* pvm_bufinfo(bufid,&a,&b,&c); vypis("byt=%d tag=%d tid=0x%x\n",a,b,c); */
/* pvm_upkint( mess, COUNT, STRIDE ); not needed */
pvm_send( dest, MSGTAG ); /* reply */
}

static void Send_row()
{
pvm_initsend( PvmDataDefault );pvm_pkint( &Hg[myhost*hwt], npvm, STRIDE );
pvm_send( pvm_gettid(GROUP,0) , MSGTAG+1 );
}

static void Recv_row(int dest)
{
pvm_recv( dest, MSGTAG+1 );
pvm_upkint( &Hg[hwt*Findhost(dest)], npvm, STRIDE );
}

/******************************************************************************/
/* tu je vacsia kontrola na chybu: */
/*
static int iii;
#define III if(iii==0)iii=
#define Pvm_recv(A,B) iii=pvm_recv(A,MSGTAG+B); if(iii>0)iii=0
#define Pvm_initsend() pvm_initsend(PvmDataDefault); iii=0
*/
#define III
#define Pvm_recv(A,B) pvm_recv(A,MSGTAG+B)
#define Pvm_initsend() pvm_initsend(PvmDataDefault)

#define Pvm_probe(A,B) pvm_probe(A,MSGTAG+B)
#define Pk(A) III pvm_pkint(&A,1,STRIDE)
#define Pkd(A) III pvm_pkdouble(&A,1,STRIDE)
#define Pka(A,B) III pvm_pkint(A,B,STRIDE)
#define Kp(A) III pvm_upkint(&A,1,STRIDE)
#define Kpd(A) III pvm_upkdouble(&A,1,STRIDE)
#define Kpa(A,B) III pvm_upkint(A,B,STRIDE)
#define Pvm_bcast(A) III pvm_bcast(GROUP,MSGTAG+A)
#define Pvm_send(A,B) III pvm_send(A,MSGTAG+B)

void SynchData(int tsk, int tgt)		/* Loc[], Load[], ... */
{
int j;
Pvm_initsend();
Pk(tsk); Pk(tgt); Pvm_bcast(2);
for(j=0;j<nptsk-1;j++)
 {Pvm_recv(-1,2);
  Kp(tsk);Kp(tgt);
  if (tsk >= 0) 
  if (!Move(tsk,tgt,TRUE)) printf("\n!MOVING %d -> %d ERROR!",tsk,tgt);
 }
}

void SpreadData()
{
int m;
Pvm_initsend();
Pk(hwt);Pk(nptsk);Pk(npvm);Pk(swt);Pk(cht);Pk(sumload);Pk(fixed);Pk(start);
Pk(alpha);Pk(beta);Pk(dist);Pk(iter);Pk(diverg);m=(int)mode;Pk(m);Pk(averspeed);
Pka((int *)Hg,hwt*hwt);Pka(He,2*hwt);	Pka((int *)Cg,cht*3);	Pka(Sg,swt);
Pvm_bcast(3);
}

void GetData()
{
int m;
Pvm_recv(-1,3); /* hwt= ...below */ /* swt= ...below */ /* cht= ...below */
Kp(hwt);Kp(nptsk);Kp(npvm);Kp(swt);Kp(cht);Kp(sumload);Kp(fixed);Kp(start);
Kp(alpha);Kp(beta);Kp(dist);Kp(iter);Kp(diverg);Kp(m); mode=(char)m; Kp(averspeed);
if((Hg = (int *) realloc((void *)Hg, hwt*hwt*sizeof(int)))==NULL)EXM
if((He = (int *) realloc((void *)He,   2*hwt*sizeof(int)))==NULL)EXM
if((Cg = (int (*)[3]) realloc((void *)Cg, cht*sizeof(int[3])))==NULL)EXM
if((Sg   = (int *) realloc((void *)Sg,	swt*sizeof(int)))==NULL)EXM
if((Loc  = (int *) realloc((void *)Loc,	swt*sizeof(int)))==NULL)EXM
ReallocLoad(); /* also pvi, pvo */
Kpa((int *)Hg,hwt*hwt);	Kpa(He,2*hwt);	Kpa((int *)Cg,cht*3);	Kpa(Sg,swt);
}

static void SpreadHgRd()
{
Pvm_initsend();
Pk(hgrd); Pvm_bcast(4);
}

static void GetHgRd() { Pvm_recv(-1,4); Kp(hgrd);}

void SendTime(int t)
{ Pvm_initsend(); Pk(t); Pvm_send(pvm_gettid(GROUP,0), 5); }

int CollectTime(int myt)	/* my time spent */
{
int j,t,sum;
sum=myt;
for(t=j=0;j<nptsk-1;j++) 
 {Pvm_recv(-1,5); Kp(t); sum += t;}
return(sum);
}

/* ladiace nastroje :
void PPvm_spawn(char *task, char **argv, char *where,
		int flag, int ntask, int *tids)
{
int i;
i=pvm_spawn(task,argv,flag,where,ntask,tids);
if(pvm_tidtohost(*tids) != pvm_tidtohost(mytid))
	vypis("Bad spawn: child 0x%x is not with me=0x%x\n",child,mytid);
if(i<0) vypis("Pvm_spawn error: %d\n",i);
}
*//*
void Task_vypis()
{
int nt,i; struct pvmtaskinfo *tp=NULL;
pvm_tasks(0,&nt,&tp);
for(i=0;i<nt;i++)
vypis("mytid=0x%x parent=0x%x\t host=0x%x %s\n",
	tp[i].ti_tid,tp[i].ti_ptid,tp[i].ti_host,tp[i].ti_a_out);
}
*/

/***********************************************************************/
/*  H M E  pvm routines */
/************************/

void SpreadStartLoc(int rep, int it)
{ Pvm_initsend(); Pk(rep); Pk(it); Pka(Loc,swt); Pvm_bcast(21); }

int ProbeKill() { return(Pvm_probe(-1, 666)>0); }
void SendKill() { Pvm_initsend(); Pvm_bcast(666);}

int RecvStartLoc(int *rep)
{int master,i,it;
  i=0; Pvm_recv((master=pvm_gettid(GROUP,0)), 21); Kp(*rep); 
  while(Pvm_probe(master, 21)>0)
    { Pvm_recv(master, 21); Kp(*rep); if(*rep)i++; } /* skip some "iterations" */
  Kp(it); Kpa(Loc,swt); /* take last one */
  for(;i>0;i--) Pvm_recv(master,23); /* take away unusable replies */
  return(it);
}

void SendLoc(int cost, int it)
{
int who,master;
Pvm_initsend(); master=pvm_gettid(GROUP,0);
Pk(cost); Pk(it); Pk(me); Pvm_send(master, 22);
Pvm_recv(master,23);
Kp(who); if(who==me) { Pvm_initsend(); Pka(Loc,swt); Pvm_send(master,24); }
}

int CollectLoc(int mycost, int th, int it)	/* my result cost */
{
int i,j,t,min,who;
min=mycost; who=-1; j=0;
/* vypis("%ssyncing...\n%s",BL,BL); */
while(j==0 || j<(nptsk-1)/th) { /* wait for sufficient amount of results */
  j++; Pvm_recv(-1,22); Kp(t); Kp(i);
  /* if(i==it && min>t) {Kp(who); min=t;} * / * take care only for new results */
  if(min>t) {Kp(who); min=t;} /* take old good results also for claimed amount */
}
while(Pvm_probe(-1, 22)>0) /* take other new and old results into account */
	{j++; Pvm_recv(-1,22); Kp(t); Kp(i); if(min>t) {Kp(who); min=t;}}
Pvm_initsend();
Pk(who); Pvm_bcast(23); /* invite the best result */
if(who>0) { Pvm_recv( pvm_gettid(GROUP,who), 24); Kpa(Loc,swt); }
return(who>0);
}

/***********************************************************************/
/*  S A   pvm routines */
/************************/

void SAspreadT(double max, double min)
{ int i,j;
  for(i=1;i<nptsk;i++) {
    Pvm_initsend(); Pkd(max); Pkd(min); j=Rand(MAXINT); Pk(j);
    Pvm_send(pvm_gettid(GROUP,i),40);
  }
}

void SArecvT(double *max, double *min)
{ Pvm_recv(pvm_gettid(GROUP,0), 40); Kpd(*max); Kpd(*min); Kp(NewSeed);}

void SAgetLoc(int who, int *map)
{ Pvm_initsend(); Pk(who); Pvm_bcast(41);
  if(who>0) {Pvm_recv(pvm_gettid(GROUP,who), 42); Kpa(map,swt);}
}

int SAfindWho()
{
int who,master;
master=pvm_gettid(GROUP,0); Pvm_recv(master,41); Kp(who);
if(who==me) { Pvm_initsend(); Pka(Loc,swt); Pvm_send(master,42); }
return(who);
}

void SAsendCross(int who, int *map)
{ Pvm_initsend(); Pka(map,swt); Pvm_send(pvm_gettid(GROUP,who), 43); }

void SAgetCross(int *map)
{ Pvm_recv(pvm_gettid(GROUP,0), 43); Kpa(map,swt); }

void SAready(int it)
{ Pvm_initsend(); Pk(me); Pvm_send(pvm_gettid(GROUP,0), it+SA_HME_RDY); }

int SAwhoisReady(int it, int *m, int th)  /* wait for first 1/th ready results */
{int f; f=0;
while(f==0 || f<(nptsk-1)/th) {Pvm_recv(-1, it+SA_HME_RDY); Kp(m[f++]);}
while(Pvm_probe(-1, it+SA_HME_RDY)>0) {Pvm_recv(-1, it+SA_HME_RDY); Kp(m[f++]);}
return(m[Rand(f)]);
}

void SA_HME_deleteReady()
{int i,f=1;
 for(i=0;f>0;i++) {
   f=0; 
   while(Pvm_probe(-1, i+SA_HME_RDY)>0) {f++; Pvm_recv(-1, i+SA_HME_RDY);}
 }
}

/*--------------------------------*/


int SAsynchro(double *T, int R) /* R=TRUE: slower worker can skip some iterations */
{int master,cycl;
cycl=0;
if(me==0) { Pvm_initsend(); Pkd(*T); Pvm_bcast(44); }
else {
  Pvm_recv((master=pvm_gettid(GROUP,0)), 44);
  /* if the possible not ready partner is chosen, following MUST be disabled : */
  if(R) {
    while(Pvm_probe(master, 44)>0) {
      SAfindWho(); /* to take one (potential) call for crossing */     
      cycl++;
      Pvm_recv(master, 44);
    }
  }  
  Kpd(*T);
}
return(cycl);
}

int SAsendLoc(int cost)
{
int who,master;
master=pvm_gettid(GROUP,0);
Pvm_initsend();
Pk(cost); Pk(me); Pvm_send(master,45);
Pvm_recv(master,46); Kp(who);
if(who==me) { Pvm_initsend(); Pka(Loc,swt); Pvm_send(master,47); }
return(who);
}

int SAcollectLoc(int mycost,int *map)	/* the best map */
{
int j,t,min,who;
min=mycost; who=0;
for(j=0;j<nptsk-1;j++) 
 {Pvm_recv(-1,45); Kp(t); if(t<min){min=t; Kp(who);}}
Pvm_initsend();
Pk(who); Pvm_bcast(46);
if(who>0) { Pvm_recv(pvm_gettid(GROUP,who), 47); Kpa(map,swt); }
return(who);
}

/* ------------------ here is added efficiency measuring ----------------------- */

static void Send_eff(int e1, int e2)
{ Pvm_initsend(); Pk(e1); Pk(e2); Pvm_send( pvm_gettid(GROUP,0) , 39 ); }

static void Recv_eff(int dest)
{int i; Pvm_recv(dest, 39 );Kp(He[(i=Findhost(dest))]);Kp(He[npvm+i]); }

static int get_efficiency(int *e2)
{
#define LOOP 1000
#define INT 1000
#define FLO 1000
#define TEST  {int i,j,k=3; double d,kk=1.2345;\
  j=k; for(i=0;i<INT;i++) j*=k;\
       for(i=0;i<INT;i++) j/=k;\
  d=kk;for(i=0;i<FLO;i++) d*=kk;\
       for(i=0;i<FLO;i++) d/=kk;}

  int t, tp, o;
  struct timeval start, stop;
  
#ifdef PG_PVM
  pg_start("eff");
#endif
  gettimeofday(&start, (struct timezone *) NULL);
  TEST /* first */
  gettimeofday(&stop, (struct timezone *) NULL);
  t = (stop.tv_sec - start.tv_sec)*1000*1000;	/* s -> us */
  t += (stop.tv_usec - start.tv_usec);	/* us */
  tp=t;
  gettimeofday(&start, (struct timezone *) NULL);
  TEST /* second */
  gettimeofday(&stop, (struct timezone *) NULL);
  t = (stop.tv_sec - start.tv_sec)*1000*1000;	/* s -> us */
  t += (stop.tv_usec - start.tv_usec);	/* us */
  if(tp<t) *e2=tp; else *e2=t;
/* if one measuring was interrupted by timeslicing, other was not affected */

  gettimeofday(&start, (struct timezone *) NULL);
  for(o=0;o<LOOP;o++) TEST
  gettimeofday(&stop, (struct timezone *) NULL);
  t = (stop.tv_sec - start.tv_sec)*1000;	/*  s -> ms */
  t += (stop.tv_usec - start.tv_usec)/1000;	/* us -> ms */
#ifdef PG_PVM
  pg_end("eff");
#endif
  return(t);
}

/* -------- here is added checking of the version among PVM-instances  ----------- */
static int CheckVersion()
{ extern char buff[MAXBUFF];
  int i,j,k;
  if(me==0) { for(i=k=0;i<npvm-1;i++) {
		Pvm_recv(-1, 38); pvm_upkstr(buff); Kp(j);
		if(strncmp(version,buff,MAXBUFF)!=0) {
		  printf("%s [%s]: ",hi[myhost].hi_name,version);
		  cprintf("incompatible version%s","");
		  printf(" with %s [%s]\n",hi[j].hi_name,buff); k++;
		}
	      }
	      if(k>0) return(TRUE);
  }
  else { Pvm_initsend(); pvm_pkstr(version); Pk(myhost);
	 Pvm_send(pvm_gettid(GROUP,0), 38);
  }
  return(FALSE);
}

/* ------------------ detecting and changing the root PVM host ------------------ */
/* because the MASTER in GRP (application manager) is spawned at that PVM node
   where stdin/stdout/stderr is connected to and is managed in mapping process that
   it will be run on PVM root node (#0), the HW tables should take it into account
   i.e. "console" connected PVM host should have number #0  */

static void ChangeRoot(int ii)
{int i,j,m;
if(ii==0)return;
if(Load!=NULL){m=Load[0]; Load[0]=Load[ii]; Load[ii]=m; }
#if PVIOCHECK
if(pvi!=NULL){ m=pvi[0]; pvi[0]=pvi[ii]; pvi[ii]=m; }
if(pvo!=NULL){ m=pvo[0]; pvo[0]=pvo[ii]; pvo[ii]=m; }
#endif
if(He!=NULL){ m=He[0]; He[0]=He[ii]; He[ii]=m;
	      m=He[hwt]; He[hwt]=He[hwt+ii]; He[hwt+ii]=m; }
if(Hg!=NULL){;}
if(Loc!=NULL) { for(j=i=0;i<swt;i++) if(Loc[i]==ii) {j=i;break;}
		m=Loc[j];
		if(j>0) for(i=0;i<swt;i++) if(Loc[i]==0) {
		  Loc[i]=m;
		  Loc[j]=0;
		}
}
if(hwn!=NULL) {char *ss; ss=hwn[0]; hwn[0]=hwn[ii]; hwn[ii]=ss; }
}

void ReorganizeHW()
{
if(myhost==0)return;
printf("...reorganizing HW tables(0<->%d)\n",myhost);
ChangeRoot(myhost);
}

#endif
