/* function SimAnn for pmap.c & xpmap.c */

#include "pmap.h"

#define Probab_crossover 30	/* probability of crossover in % */
#define QdecrT 0.8		/* temperature decreasing coefficient */
#define QTQ 50			/* parameter for computing T_max */
#define QiQ 10			/* # of iterations */
		/* skip some iteration for slow worker? : set TH>1 ! */
#define TH 2		/* 1/TH  of workers should be ready for crossing */
/* #define abs(x) (((x)<0)?-(x):(x)) */

extern double exp(double x);
extern double log(double x);

static int counter_max, success_max, success, ddT;
static double T_max, T, T_min;
static int *map_1=NULL, *map_2=NULL, *Pool=NULL, *temp=NULL;
static int costLoc, costPool;
/* Pool je pracovny, map_x su pomocne*/
/*int Loc[NILTASK];	* optimalna konfiguracia, udrzujem costLoc so zmenou Loc */

/*====================================================================== */
/* vypocet hodnoty cost funkcie*/
static int SAComm(int *map)
{ int s,i;
for (s = i = 0; i < cht; i++) s += Cg[i][2] * Hg[map[Cg[i][0]]*hwt+map[Cg[i][1]]];
return(s); /* printf("\tComm=%3d %s\n",s,BL); */
}

static void SetLoadSA(int *map)
{ int i;
for(i=0; i<hwt; i++) Load[i]=0; for(i=0; i<swt; i++) Load[map[i]] += Sg[i];
}

static int Objective_funct(int *map)
{ SetLoadSA(map); return( (alpha*SAComm(map)) + (beta*ImbAbs()) ); }

/*========================================================================== */
static void Initconfig()
{ int i,j;
if((map_1 = (int *) realloc((void *)map_1, swt*sizeof(int)))==NULL)EXM
if(me==0)   /* master only */
 if((map_2 = (int *) realloc((void *)map_2, swt*sizeof(int)))==NULL)EXM
if((Pool  = (int *) realloc((void *)Pool, swt*sizeof(int)))==NULL)EXM

/* tu to muselo byt zvacsene o 1, (na int Pool[swt+1])
   pretoze na SUN4SOL2 to padalo niekde vo vnutri XtVaSetValues pri alloc pamat
   a toto pomohlo PRECO??? => po free(smernik) nenasledovalo smernik=NULL ! */

#if TH > 1 /* space for choosing one of ready partners (can be nptsk-1) */
 if((temp = (int *) realloc((void *)temp, nptsk*sizeof(int)))==NULL)EXM
#endif

for (j=0; j < swt; j++) { if(j==fixed) Loc[j] = 0; else Loc[j] = Rand(hwt); }
costLoc = Objective_funct(Loc);
for (j=0; j < swt; j++) { if(j==fixed) Pool[j] = 0; else Pool[j] = Rand(hwt); }
costPool = Objective_funct(Pool);
if (costPool < costLoc) {i=costLoc; costLoc=costPool; costPool=i;
    for(i=0; i<swt; i++) {j=Loc[i]; Loc[i]=Pool[i]; Pool[i]=j;} }

/* tu chybali {} a prepisovalo sa pole Loc aj Pool 1 prvok za hranicu !!! */

j = costPool-costLoc; T_max=j; T_max /= QTQ;
T_min = T_max * (exp(log(QdecrT)*(iter-1)));

counter_max =  success_max = hwt * swt; success_max /= 10; 
}
				     
/*=========================================================================== */
static void Metropolis(int *map)
{   int i, F, delta_F, prob;
#define PRO 100			/* Procent or Promile or ... precision */
#define EPRO 6	/* ln(PRO) : 6 -> less than 1/1000, 4 -> less than 1/100 */

F = Objective_funct(map);	/* changes Load[] !!! */
delta_F = F - costPool;
if (delta_F > EPRO*T) return; /* too bad solution */
prob=0; /* for getting better solution -> ddT not change */
if (delta_F <= 0 || Rand(PRO) < (prob=PRO*exp(-delta_F / T)) ) {
  costPool = F;
  for (i = 0; i < swt; i++) Pool[i] = map[i];
  success++; if (prob>ddT) ddT = prob;
  if (F < costLoc) { costLoc = F; for (i=0; i < swt; i++) Loc[i] = map[i]; } 
}
}

/*=========================================================================== */
static void  Mutation(int *f_in, int *f_out)
{   int i, k;
for (i = 0; i < swt; i++) f_out[i] = f_in[i];
i = Rand(swt); while (i == fixed)   i = Rand(swt);
k = Rand(hwt); while (k == f_in[i]) k = Rand(hwt);
f_out[i] = k;
}

/*=========================================================================== */
static void  Transposing(int *f_in, int *f_out)
{   int i, count, i1, i2;
#define TTT 200	/* limit */
for (i=0; i < swt; i++) f_out[i] = f_in[i];
i1 = i2 = 1; count = 0;
while (((f_out[i1] == f_out[i2])||(i1 == fixed)||(i2 == fixed)) && (count < TTT))
      { count++;	i1 = Rand(swt - 1);	i2 = i1 + 1 + Rand(swt - 1- i1); }
i = f_out[i1]; f_out[i1] = f_out[i2]; f_out[i2] = i;
}

/*=========================================================================== */
static void  Crossover(int *f_1_in, int *f_2_in, int *f_1_out, int *f_2_out)
{   int i, i1, i2;
#define CPY { f_1_out[i]=f_1_in[i]; f_2_out[i]=f_2_in[i]; } 
i1 = 1 + Rand(swt - 1);
i2 = i1 + 1 + Rand(swt - i1);
for (i=0; i < (i1 - 1); i++) CPY
for (i=i1-1; i < i2; i++) {
  if (i == fixed) CPY
  else {
    f_1_out[i] = f_2_in[i];
    f_2_out[i] = f_1_in[i];
  }
}
for (i=i2 ; i < swt; i++) CPY
}

/*=========================================================================== */
static void PrintPool(int t)
{
if(me>0) return;
printf("\n");
if(t>0) printf("%6d ",costPool);
if(t>1)
 printf("T=%4.3f cost=%5d Succ=%3d d=%2d    ",T,costLoc,success,ddT);
if(t>0) printf("\r%s\n%1$s",BL);
}

/*=============================================================== */
void SimAnn()
{
extern int pvm_lvgroup(char *gr);
int Cycle, counter, who, itersave, killed=FALSE;

ReadTime();
itersave=iter;	/* iter/STAGES urcuje animacny krok */
iter=QiQ; Initconfig();
Cycle=0;
if(me==0)SAspreadT(T_max,T_min);	/* sent Rand(MAXINT) */
else if(me>0) SArecvT(&T_max,&T_min);	/* recv NewSeed */
SetLoadSA(Loc);Animat(Cycle);PrintPool(1);
T = T_max;
while (T > T_min && !Xstop) { /* Metropolis pracuje s Pool : */
  counter = success = ddT = 0; Cycle++;
  while ((counter < counter_max) && (success < success_max) && !Xstop) {
    counter++;
    if (Rand(100) < 50)	Mutation(Pool,map_1);
    else		Transposing(Pool,map_1);
    Metropolis(map_1);
    if(me>0 && ProbeKill())  /* not needed computing */
      { PG_start("kill"); killed=TRUE; counter=counter_max; }
  }
  if(!Xstop) {
    if(me==0) {
      who=1+Rand(nptsk-1); if (Rand(100) >= Probab_crossover) who=0;
      if(who!=0) PG_start("cross");
#if TH > 1
      if(who>0)who=SAwhoisReady(Cycle,temp,TH); /* choose ready one instead */
      /* if above command is disabled, change to SAsynchro(&T,FALSE) !!! */
#endif      
      SAgetLoc(who,map_1); /* get partner for crossing: */
      if(who!=0) {
	Crossover(map_1,Pool,map_1,map_2);
	SAsendCross(who,map_2);
	Metropolis(map_1);
      }
      if(who!=0) PG_end("cross");
    }
    if(me>0) {
      SAready(Cycle); /* inform master me==0 */
      if(me==SAfindWho()) { 
	PG_start("cross");
	SAgetCross(map_1);
	Metropolis(map_1);
	PG_end("cross");
      }
    }
    SetLoadSA(Loc);Animat(Cycle);PrintPool(2);
			       
    T = QdecrT * T;
    if(me>=0) {
      PG_start("synch");
      Cycle += SAsynchro(&T,(TH>1));
      /* worker doesn't outrun master, but can skip some iter. */
      PG_end("synch");
    }
  }
}
if(killed) PG_end("kill");
if(me==0){ SendKill(); SA_HME_deleteReady(); } /* clear receive buffers */
if(Xstop){if(!NoPVMrunning()){KillGroup(); pvm_lvgroup(GROUP);me=-1;}}
else { PG_start("colres");
  if(me==0){ who=SAcollectLoc(costLoc,map_1); if(who>me)Metropolis(map_1); }
  if(me>0)SAsendLoc(costLoc);
  if(me<=0)/*vypis*/printf("\n\nFINAL COST=%d  \n%s%s",costLoc,BL,BL);
  PG_end("colres");
}
iter=itersave; PrintPool(0);

/* radsej to neuvolnovat, pri opakovanom pridelovani pamate by to bez vynulovania
   smernikov sposobilo crash programu ! */

free((void *)Pool); Pool=NULL;
if(me==0){free((void *)map_2); map_2=NULL;}
free((void *)map_1); map_1=NULL;

/**/
}

