/* functions SWtestHW, SWread, HWread and  ReadArg for pmap.c & xpmap.c */

/* use old-fashioned format for input files; data separator is ',' (comma):
   
   SW-graph file:
   <Ntask> <fixed> <load[0]> <load[1]> ... <load[Ntask-1]>
   <from[0]> <to[0]> <how[0]>  <from[1]> <to[1]> <how[1]> ...
   <from[?]> <to[?]> <how[?]>
   <data separator> <EOF> mark will finish this file
   
   HW-graph file:
   <hwt> <Hg[0][0]> <Hg[0][1]> <Hg[0][2]> ... <Hg[0][hwt-1]>
         <Hg[1][0]> <Hg[1][1]> <Hg[1][2]> ... <Hg[1][hwt-1]>
	 ...
	 <Hg[hwt-1][0]> <Hg[hwt-1][1]> <Hg[hwt-1][2]> ... <Hg[hwt-1][hwt-1]>
	 [ <He[0]> <He[1]> <He[2]> ... <He[hwt-1]> ]
	 <data separator> <EOF> mark will finish this file
   remark: part with He values can absent
   
   Legend:
   Ntask - #number of tasks
   fixed - index for fixed placed task (to processor node 0), -1 for none
   load[i] - computational load for i-th task
   from[i] - communication channel between tasks - source task index
   to[i]   - communication channel between tasks - destination task index
   how[i]  - communication channel between tasks - communication volume [bytes or time]
   data separator - comma-character, mandatory!!! also after last data item in the file
   EOF - end of file (mark/status)
   hwt - #number of processors (nodes)
   Hg[i][j] - communication throughput between processors (node) i and (node) j
   He[i] - time needed for computing an unit = 1/efficiency or 1/speed for (node) i
*/

#include "pmap.h"
#include <string.h>
#define NILCHAN 99999	/* limit for C_graph size == channels	=> 99999 */
#define HWTX "--#HW "
#define LNGTH MAXBUFF	/* string space size */
extern void GRPaddMaster(char *appn);
static char *gnout="hw.out";		/* PVM_HW result file name */
static char *namehw=NULL;		/* HW_graph file name */

/*******************/
static int Getname() /* buff */
{int i,c;
for (i=0; i<MAXBUFF-1 && (c=getc(fi)) != EOF && c != '\"'; i++) buff[i] =(char) c;
buff[i] = '\0';
return(i);
}

/***********************************************/
void Setgnout(int argc, char **argv) /* for saving old-fashioned Hw-graph */
{ if(argc>2 && argv[2][0]!='-') {gnout=argv[2];appname=gnout;} }

/*******************/
static void Setnamehw(const char *name)
{
char tx[LNGTH], *ss=NULL;

if (namehw==NULL || strlen(namehw) == 0) { 
  Getname();
  if ((ss=strrchr(buff,'/'))==NULL) {
    strcpy(tx,name);
    if ((ss=strrchr(tx,'/'))!=NULL) {
      *(++ss) = '\0';
      strcat(tx,buff); namehw=strdup(tx);
    }
  }
  if(!hgrd) { namehw=strdup(buff); return; }
  }
else Getname();
printf("Claimed HW_graph_file=%s will not be used!\n",buff);
}

/********************************************/
int SWtestHW()  /* namehw */
{int i,txm,c,f; /* check if HW-graph file name is written in SW-graph file */
 char tx[LNGTH];
 FILE *fff;

strcpy(tx,HWTX); txm = strlen(tx); i=TRUE;
if ((c = getc(fi)) == '-') {
  for (f=0; f<txm && c == tx[f]; f++) c = getc(fi);
  if (f == txm && c == '\"') {
    Setnamehw(tx);
    if((fff=fopen(namehw,"r"))!=NULL) {i=FALSE; fclose(fff);}
  }
}
fclose(fi);
return(i);
}

/*******************/
/* read first number after comments, try catch HW_graph file name */
static int Ntask(char *name)
{
char	tx[LNGTH];
int	c,b,k,f,txm;

strcpy(tx,HWTX); txm = strlen(tx); f = b = k = 0;
while ( (c = getc(fi)) != EOF )
 if (k == 0)
 { if (c >= '0' && c <= '9') {ungetc(c,fi); return(ReadInt());}
   else if (c == '-') { for (; f<txm && c == tx[f]; f++) c = getc(fi);
			if (f == txm && c == '\"') Setnamehw(name);
		      }
   else {if (b == 0) {if (c == '/') b = 1;}
	 else {if (c == '*') k = 1; if (c != '/') b = 0;}
	}
 }
 else	{if (b == 0) {if (c == '*') b = 1;}
	 else {if (c == '/') k = 0; if (c != '*') b = 0;}
	}
return(-1);
}

/*****************************************************************************/
int SWread(char *name) /* swt, cht, sumload, Sg[], Cg[] */
{
#define fif(X) if(X){cprintf("ERROR: bad SW_graph file !\n%s","");ex(3)}
int	i,j,s;
char *ss=NULL, *pp=NULL;
extern int *isalpha(int c);

if(isalpha(name[0])) buff[0]='\0'; else strcpy(buff,PREF); 
strcat(buff,name); if ((pp=strstr(buff,"."))!=NULL) *pp='_'; strcat(buff,"_"); 
strcat(buff,namehw); if ((pp=strstr(buff,"."))!=NULL) *pp='_'; 
strcat(buff,SUFF); grpname=strdup(buff); 
  
if(name[0]=='-') return(0);
if ((fi = fopen(name, "r")) == NULL) {
		cprintf("Cannot open %s SW_graph file !\n",name); ex(2)}
swt= Ntask(name); /* namehw */ fif(swt<1)
if((Sg  = (int *) realloc((void *)Sg, swt*sizeof(int)))==NULL)EXM
if((Loc = (int *) realloc((void *)Loc, swt*sizeof(int)))==NULL)EXM
for(i=0;i<swt;i++)Loc[i]=Sg[i]=0;
if ((ss=strrchr(name,'/'))==NULL) strcpy(buff,name); else strcpy(buff,++ss);
strcat(buff,".");
if ((ss=strrchr(namehw,'/'))==NULL) strcat(buff,namehw); else strcat(buff,++ss);
strcat(buff,".out"); nout=strdup(buff);
if ((fo = fopen(nout, "r")) != NULL) 
	{ printf("Result file %s exists, overwrite ? [y/n]y\b",nout); GETY }
if ((fo = fopen(nout, "w")) == NULL) 
	{cprintf("Cannot open %s as result file !\n",nout); ex(2)}
printf("<<< MAPPING >>> SW_graph=%s",name);
printf(" => HW_graph=%s",namehw);
if(namehw==NULL || strlen(namehw)==0) printf(">>>%s",gnout);
printf("\n---> result file: %s  ",nout);
printf("#tasks=%d",swt);
fixed = ReadInt(); fif(fixed>=swt)
/* if (swt > NILTASK) {cprintf("ERROR:%s too large file !\n","");ex(1)} */
for (sumload = s = i = 0; (s >= 0 && i < swt); i++)
 {Sg[i] = s = ReadInt(); sumload += s;}
fif(i != swt)
if((Cg = (int (*)[3]) realloc((void *)Cg, NILCHAN*sizeof(int[3])))==NULL)EXM
for (i = 0; (i < NILCHAN && s >= 0); i++)
 for (j = 0; j < 3; j++) Cg[i][j] = s = ReadInt();
cht= i; if (s < 0) --cht;  /* cht= ... */
for(i=0; i<cht; i++) for(j=0; j<2; j++) {s=Cg[i][j]; fif(s<0 || s>=swt)}
printf(" #channels=%d",cht);
/* if((Cg = (int (*)[3]) realloc((void *) Cg, cht*3*sizeof(int)))==NULL)EXM */
GRPaddMaster(NULL); /* MASTER swt++?,cht++? */
fclose (fi);
if (cht == NILCHAN) {cprintf("ERROR:%s too large file !\n","");ex(1)}
return(0);}

/*****************************************************************************/
int HWread(char sw)	/* set: hwt, Hg[], He[], averspeed */
    			/* read or WRITE! HW_file */
			/* npvm == number of PVM hosts */
{
int i,j;

/*if(sw!='-' && (npvm<2 || (namehw!=NULL && strlen(namehw)>0))*/
if(hgrd)
{
if(sw=='-' && (namehw!=NULL && strlen(namehw) > 0)) gnout=strdup(namehw);
i=TRUE; if((gfo = fopen(gnout, "r")) != NULL) { i=FALSE;
  printf("\nPVM-HW_graph file %s exists, overwrite ? [y/n]y\b",gnout); GETY }
if((gfo = fopen(gnout, "w")) == NULL) 
    printf("Cannot open %s as result PVM-HW_graph file !\n",gnout);
else { if(i)printf("\nCreating %s as result PVM-HW_graph file.\n",gnout);
       fprintf(gfo,"%d, ",npvm);
       if(npvm>1) for (i=0; i<npvm; i++) {
	 for (j=0; j<npvm; j++) fprintf(gfo,"%d,",Hg[i*hwt+j]);
	 fprintf(gfo,"\n   ");
       }
       if(npvm>1) { for (i=0; i<npvm; i++) fprintf(gfo,"%d,",He[i]);
		    fprintf(gfo,"\n   ");
       }
       else if(npvm==1) fprintf(gfo,"%d,\n   ",1);
fprintf(gfo,"#PVMhosts: ");
for(i=0; i<npvm; i++)fprintf(gfo,"%s ",GetProcName(i));
fprintf(gfo,"\n");fclose(gfo);
if(sw=='-') {cprintf("\tsaved to:%s\n",gnout);ex(0)}
	/* file saved: nothing to do */
fprintf(fo,"\n<============================\n");
fprintf(fo,"%d, ",npvm); for (i=0; i<npvm; i++)
 {for (j=0; j<npvm; j++) fprintf(fo,"%d,",Hg[i*hwt+j]); fprintf(fo,"\n   ");} fprintf(fo,"#PVMhosts: ");
for(i=0; i<npvm; i++)fprintf(fo,"%s ",GetProcName(i));
fprintf(fo,"\n============================>\n");
     }
}

else {
  if ((fi = fopen(namehw, "r")) == NULL) {
    cprintf(" ! Cannot open %s HW_graph file !\n",namehw); ex(2) }
  hwt= ReadInt();
  if((Hg = (int *) realloc((void *)Hg, hwt*hwt*sizeof(int)))==NULL)EXM
  for (i = 0; i < hwt; i++)  for (j = 0; j < hwt; j++) Hg[i*hwt+j] = ReadInt();
  if (Hg[hwt*hwt-1] <0) {cprintf("ERROR:%s bad HW_graph file !\n","");ex(3)}
  printf(" => #hw_nodes=%d",hwt);
  if((He = (int *) realloc((void *)He, 2*hwt*sizeof(int)))==NULL)EXM
  for (i = 0; i < hwt; i++) He[i] = ReadInt();
  if (He[hwt-1] <0) { for (i=0;i<hwt;i++) He[i]=1; averspeed = 1; } /* no success */
  else { for (averspeed=i=0;i<hwt;i++) averspeed +=He[i]; averspeed /= hwt; } 
  for (i=hwt;i< 2*hwt; i++) He[i] = 1;
}

ReallocLoad(); /* also pvi, pvo */
SetLoad();
return(0);
}

/*****************************************************************************/
int ReadArg(int argc,char *argv[])	/* namehw? , arg4, arg5, ok */
{
int i,j;
extern int toupper(int i);
if(argc<2)	{
  cprintf("usage:%s SW_graph_data_file [HW_graph_data_file [mode [comm [iter]]]]\n",argv[0]);
   cprintf("   or:%s  - [HW_graph_data_file] (for obtaining the HW_data from PVM)\n\n" ,argv[0]);
 printf("HW_graph_data_file = file_name OR \"-\" as working PVM\n");
  printf("mode =  quick: 0,1,2,3,4 (greedy)\n");
  printf("        smart: diffusion: D, Boillat: B  diffusion_fixed: F\n");
  printf("        heavy: heuristic_move_exchange: H\n");
  printf("        all: A\n");
  printf("comm =  communication_weight_magnifier\n");
  printf("iter =  iteration_loop_divisor\n");
  ex(3) /* ok */
}
if (argc > 2 && argv[2][0] != '-') namehw=strdup(argv[2]);
else if(hgrd) namehw=strdup("");
if (argc > 3) mode = toupper(argv[3][0]);
if (argc >4) for (arg4 = i = 0; (j = argv[4][i]) >= '0' && j <= '9'; i++)
     arg4 = arg4 * 10 + j - '0';
else arg4 = 1;
if (argc >5) for (arg5 = i = 0; (j = argv[5][i]) >= '0' && j <= '9'; i++)
     arg5 = arg5 * 10 + j - '0';
else arg5 = 1; if (arg5==0) arg5++;
return(0);}
