/* FilterTrace()  for pmap.c & xpmap.c */
/* it generates "~/pgmap" file with "task name & task load" lines
   first and inter-task communication value lines next */

/* #define BLABLA */

#include "pmap.h"
#include "pmap_grp.h"
#include <string.h>
  
#define MAG 10		/* load will be normalized up to MAG*100 (%) */
#define EOL 10
#define DELIMT ' '	/* in trace file */
#define DELIMP '\t'	/* in pgrc file */
#define Printf(A)	/* verbose? then define as "printf(A)" */
#define PRintf(A,B)	/* verbose? then define as "printf(A,B)" */
#define PRINtf(A,B,C,D)	/* verbose? then define as "printf(A,B,C,D)" */
#define PRINTf(A,B,C,D,E) /* verbose? then define as "printf(A,B,C,D,E)" */

static FILE *fti,*fto;

/* --------------------------- reads next text line into "buff[]" */
static int GetLine(FILE *ff)
{ int i,j;
  for(i=0;i<MAXBUFF;i++) {
    buff[i]=j=getc(ff); if(j==EOL){buff[i]='\0';i=MAXBUFF+1;}
  }
  if(i==MAXBUFF)buff[i-1]='\0'; /* line without EOL mark */
  return(strlen(buff));
}

/* --------- returns process name "vector" obtained from PGRC file */
static int ReadPGRC(char *name, char *ss)
{ char c, *pp=NULL; int i,j,a,b; FILE *f;
  char *scf=NULL;

sprintf(buff,"%%%ds",TASKNLGT-1); scf=strdup(buff);
ss = (char *) realloc((void *)ss, swt*TASKNLGT*sizeof(char));
if(ss==NULL)return(TRUE);
for(i=0;i<swt*TASKNLGT;i++) ss[i]='\0';
if((f = fopen(name, "r")) == NULL) { free(ss); ss=NULL; return(TRUE); }
for(i=0;i<swt && !feof(f);i++) {
  GetLine(f);
  if(sscanf(buff,"%d%d%n",&a,&b,&j)<2)
    { PRintf(" PGRC ERROR in line=%d\n",i+1); b=0; }
  else if(b>=swt)
    { PRINTf("PGRC ERROR line=%d b=%d > swt=%d\n \
              %s\n",i+1,b,swt,buff); b=0; }
  else { pp=buff+j; sscanf(pp,scf,&ss[b*TASKNLGT]); }
/*  printf("%d %s\n",b,&ss[b*TASKNLGT]); */
}
c=getc(f); /* one char after EOL */
if(!feof(f))
    printf("Warning: some trace user-event data were not read!\n");
fclose(f);
return(FALSE);
}


/* ------------------------------------------------------------------- */
static int CompareCg(int c1, int (*C1)[3], int c2, int (*C2)[3])
{ int i,j,f,t,h;
  if(c1!=c2)return(FALSE);
  for(i=0; i<c1; i++) {
    if(C1[i][0]<0) return(FALSE);
    f=C1[i][0];
    t=C1[i][1];
    h=C1[i][2];
    for(j=0; j<c2; j++)
      if(C2[j][0]==f && C2[j][1]==t && C2[j][2]==h) j=c2+2;
    if(j<=c2)return(FALSE);
  }
  return(TRUE);
}
	 	 
	 
/* ------------------------------------------------------------------- */
static void FillCg(int from, int to, int how, int (*C_g)[3], int *ch_t)
{ int i,j; 

for(i=j=0; i<cht; i++) {
  if(C_g[i][0]<0) { C_g[i][0]=from; C_g[i][1]=to; C_g[i][2]=how; i=cht; (*ch_t)++;}
  else if(C_g[i][0]==from && C_g[i][1]==to) { C_g[i][2] += how; i=cht; };
}
}


/* ------------- analyses trace file ------------------------ */
int FilterTrace(char *iname, char *pname, char *oname,
		int (*Cg)[3], int *Sg, char *swn)
{
#define MXdt 4
int dt[MXdt];		/* data field array */
int i,j,li,err, *ass=NULL; /* processor-to-process translator */
int *as_=NULL;		/* process-to-task translator */
int rt,re,pr;		/* record type, event type, processor id */
double ts;		/* timestamp */
int ps,nf,dd;		/* process id, number of data fields, data descriptor */

int cht_=0, cht__=0, swt_=0, swnt=0;
int (*Cg_)[3]=NULL;	/* starage for eachchannel : summ of bytes received */
int (*Cg__)[3]=NULL;	/* starage for eachchannel : summ of bytes sent */
float *Sg_=NULL;	/* starage for each process : summ of time = load */
float *Id_=NULL;	/* starage for each process : summ of time = idle */
float *Ov_=NULL;	/* starage for each process : summ of time = overhead */
float *startSg=NULL;	/* temporary starage for each process */
float *startId=NULL;	/* temporary starage for each process */
float *startOv=NULL;	/* temporary starage for each process */
char *pp=NULL, *sf=NULL;		/* temp.stor. for scanf control string */
char *uev=NULL, *x0="?", *xx=NULL;	/* (user event) - process name vector */
double delta;

if((fti = fopen(iname, "r")) == NULL) return(FALSE);
if((fto = fopen(oname, "w")) == NULL) return(FALSE);
if((sf = (char *) realloc((void *)sf, MAXBUFF*sizeof(char)))==NULL) return(FALSE);
if((ass = (int *) realloc((void *)ass, swt*sizeof(int)))==NULL) return(FALSE);
if((as_ = (int *) realloc((void *)as_, swt*sizeof(int)))==NULL) return(FALSE);
if((Cg_ = (int (*)[3]) realloc((void *)Cg_, cht*sizeof(int[3])))==NULL) return(FALSE);
if((Cg__ = (int (*)[3]) realloc((void *)Cg__, cht*sizeof(int[3])))==NULL) return(FALSE);
if((Sg_ = (float *) realloc((void *)Sg_, swt*sizeof(float)))==NULL) return(FALSE);
if((Id_ = (float *) realloc((void *)Id_, swt*sizeof(float)))==NULL) return(FALSE);
if((Ov_ = (float *) realloc((void *)Ov_, swt*sizeof(float)))==NULL) return(FALSE);
if((startSg = (float *) realloc((void *)startSg, swt*sizeof(float)))==NULL) return(FALSE);
if((startId = (float *) realloc((void *)startId, swt*sizeof(float)))==NULL) return(FALSE);
if((startOv = (float *) realloc((void *)startOv, swt*sizeof(float)))==NULL) return(FALSE);
if((uev = (char *) realloc((void *)uev, swt*TASKNLGT*sizeof(char)))==NULL) return(FALSE);
if((err=ReadPGRC(pname,uev))) printf("\nWARNING: Bad or missing \"%s\" \
PGRC_process_name file!\n",pname);

if(!err) {
  for(i=0;i<swt;i++) Id_[i]=Sg_[i]=Ov_[i]=startSg[i]=startId[i]=startOv[i]=0.0;
  for(i=0;i<cht;i++) Cg__[i][0]=Cg_[i][0]=-1;
  for(i=0;i<swt;i++) as_[i]=ass[i]=-1;
  li=0;
  while(!feof(fti)) {
    if(GetLine(fti)>0) li++;  
    i=sscanf(buff,"%d%d%lf%d%d%d%d%n",&rt,&re,&ts,&pr,&ps,&nf,&dd,&j);
    pp=buff+j;
    if(i==7 || (i==6 && nf==0)) {
      if(nf>0 && dd==2) /*read other int data */
	for(i=0;i<nf && i<MXdt;i++) { sscanf(pp,"%d%n",&dt[i],&j); pp += j; }
      if(rt>=0) printf("user record\n");
      else if(rt<-200) printf("statistic record\n");
      else if(rt<-100) printf("statistic record\n");
      else if(rt==-7) printf("event message record\n");
      else if(rt==-6) printf("event data descriptor record\n");
      else if(rt==-5) printf("event label record\n");
      else
	/* event record : */
	/* count sum of usage time for each process - as load */
	/* in future: take into account also wait for communication */ 
	{ 
	  if(re>=0) { /* ------------------ user event ------------ */
	    Printf("user event\n");
	    if(re>=swt) {if(!err)printf("WARNING: unidentified user event %d!\n",re);err=TRUE;}
	    else {
	      if(pr>=swt || pr<0){err=TRUE;
				  printf("!!!process %d >= swt\n%s",pr,BL);}
	      else {
		if(rt==-2) Printf("mark:");
		else if(rt==-3) {
		  Printf("entry:");
		  if(ass[pr]<0)ass[pr]=re; /* assign processor to PGRC name */
		  else if(ass[pr]!=re){err=TRUE;
				       printf("!!!process %d <> %d\n%s",re,pr,BL);}
		  /* startSg[pr]=ts; */
		  swnt++;
		}
		else if(rt==-4) {
		  Printf("exit:");
		  if(ass[pr]!=re){err=TRUE;
				  printf("!.!process %d <> %d\n%s",re,pr,BL);}
		  /* Sg_[pr] += ts - startSg[pr]; */
		}
	      }
	      if(uev==NULL) xx=x0;
	      else xx=&uev[re*TASKNLGT];
	      PRINtf(" %s processor=%d %lf\n",xx,pr,ts);
	    }
	  }
	  else if(re<-1000){ printf("select event\n");}
	  else if(re<-901){ printf("tracing event\n");}
	  else if(re==-901) {  /* ------------------ tracing event ------------ */
	    Printf("tracing event\n");
	    if(pr>=swt || pr<0){err=TRUE;
				printf("!!!tracing %d >= swt\n%s",pr,BL);}
	    else {
	      if(rt==-2) Printf("mark:");
	      else if(rt==-3) {
		Printf("entry:");
		startSg[pr]=ts;
	      }
	      else if(rt==-4) {
		Printf("exit:");
		Sg_[pr] += ts - startSg[pr];
		swt_++;
	      }
	    }
	  }
	  else if(re<-600) { printf("idle/overhead event\n");}
	  else if(re==-503){ Printf("spawn event\n");}
	  else if(re<-500) { printf("resource event\n");}
	  else if(re<-400) { printf("clock synchro event\n");}
	  else if(re<-200) { printf("i/o event\n");}
	  else if(re<-50)  {
	    Printf("receive event\n");
	    if(re!=-52)printf("-rec proc=%d ev=%d %f ",pr,re,ts);
	    if(pr>=swt || pr<0){err=TRUE;
				printf("!!!receive %d >= swt\n%s",pr,BL);}
	    else {
	      if(rt==-2) printf(":mark");
	      else if(rt==-3) {
		if(re!=-52)printf(":entry\n");
		startId[pr]=ts;
	      }
	      else if(rt==-4) {
		delta = ts - startId[pr];
		if(re!=-52)printf(":exit delta=%f -\n",delta);
		Id_[pr] += delta; /* [0]=length, [1]=type, [2]=who */
		if(nf>=3) FillCg(dt[2],pr,dt[0],Cg_,&cht_);
	      }
	    }
	  }
	  else if(re<-20)  {
	    Printf("send event\n");
	    if(re!=-21)printf("send proc=%d ev=%d %f ",pr,re,ts);
	    if(pr>=swt || pr<0){err=TRUE;
				printf("!!!send %d >= swt\n%s",pr,BL);}
	    else {
	      if(rt==-2) printf(":mark\n");
	      else if(rt==-3) {
		if(re!=-21)printf(":entry\n");
		startOv[pr]=ts;
		if(nf>=3) FillCg(pr,dt[2],dt[0],Cg__,&cht__);
	      }
	      else if(rt==-4) {
		delta = ts - startOv[pr];
		if(re!=-21)printf(":exit delta=%f\n",delta);
		Ov_[pr] += delta;
	      }
	    }
	  }
	  else if(re<-10)  { printf("interprocess event\n");}
	  else { printf("all event\n");}
	}
	
    }
    else if(i==6 && nf>0 && pp!=NULL) {
      i=sscanf(pp,"%s",sf); printf("scanf control: %s\n",sf);
    }
    else if(!feof(fti)) { err=TRUE; printf("error record in line %d\n",li); break; }
  }
}
fclose(fti);




/* check processor-to-process translator : */
if(!err) for(i=0;i<swt;i++) if(ass[i]<0) {
  err=TRUE;
  printf("\nWARNING: bad process names in trace file!");
  for(i=0;i<swt;i++)ass[i]=i;
}

/* set name translator : */
if(!err) for(i=0;i<swt;i++) for(j=0;j<swt;j++) {
  if(strcmp(&uev[ass[i]*TASKNLGT], &swn[j*TASKNLGT])==0) {
    as_[i]=j; j=swt;
  }
}
if(!err) for(i=0;i<swt;i++) if(as_[i]<0) {
  err=TRUE;
  printf("\nWARNING: process names in trace file differ from application names!");
  for(i=0;i<swt;i++) as_[i]=i;
}

/* check i/o symmetry : */
if(!err && !CompareCg(cht_,Cg_,cht__,Cg__)) { 
  err=TRUE;
  printf("Trace file error - i/o not symmetric!\n");
}
					 
/* ----- calculate real load and normalize up to 100.00% : ---- */
if(!err) for(i=0;i<swt;i++) { Sg_[i] -= Id_[i]; Sg_[i] -= Ov_[i]; } 
delta=0.0; 
if(!err) for(i=0;i<swt;i++) if(delta<Sg_[i]) delta=Sg_[i];
delta /=100;


/* flush output file : */ /* only process load, for old compatibility */
if(!err) for(i=0;i<swt;i++) {
  if(uev==NULL || ass[i]<0) xx=x0; 
  else xx=&uev[ass[i]*TASKNLGT];
  fprintf(fto,"%s %.2f\n",xx,Sg_[i]/delta);
}
					 

#ifdef BLABLA
if(!err) {
  /* ----------- PRINT TRACE RESULTS ------------ */
  sprintf(buff,"%%d %%d %%%ds ",TASKNLGT-1);
  strcat(buff,"= %lf idle=%lf overhead=%lf\n");
  printf("\n[pgrc appl]\n");
  for(i=0;i<swt;i++) {
    if(uev==NULL || ass[i]<0) xx=x0; 
    else xx=&uev[ass[i]*TASKNLGT];
    printf(buff,ass[i],as_[i],xx,Sg_[i],Id_[i],Ov_[i]);
  }
  printf("channels = %d\n",cht_);
  for(i=0;i<cht_;i++) 		
     printf("%d-%d:%d ",Cg_[i][0],Cg_[i][1],Cg_[i][2]);
  printf("\n");
}
#endif
					 

/* flush results : */
if(!err) {
  if(cht_==cht && swt_==swt && swnt==swt) {
    for(i=0;i<swt;i++) Sg[as_[i]]=MAG*(Sg_[i]/delta);
    for(i=0;i<cht;i++) {
      Cg[i][0]=as_[Cg_[i][0]];
      Cg[i][1]=as_[Cg_[i][1]];
      Cg[i][2]=Cg_[i][2];
    }
  }
  else { printf("Trace file is not apropriate for the application!");
	 if(swt_!=swt)printf(" Tasks in trace = #%d!",swt_);
	 if(swnt!=swt)printf(" Task names in trace = #%d!",swnt);
	 if(cht_!=cht)printf(" Channels in trace = #%d!",cht_);
	 printf("\n");
	 err=FALSE;
  }
}


fclose(fto);
free(Sg_); Sg_=NULL;
free(Cg_); Cg_=NULL;
free(Cg__); Cg__=NULL;
if(err)unlink(oname);
return(!err);
}
