/* the utility for adding a PVM host from a command line */

#include "pvm3.h"
#include <string.h>
#include <stdio.h>	/* FILE */

#ifndef FALSE
#define FALSE 0
#define TRUE 1
#endif

#define MXCOLMN 80		/* line length */
#define TX "adding hosts..."
char *BL="\033[A";	/* Back Line */

int NoPVMrunning()
{extern uid_t getuid(void); 
  char n[32]; FILE *f; sprintf(n,"/tmp/pvmd.%d",(int)getuid());
  if((f = fopen(n, "r")) == NULL) return(TRUE); else {fclose(f); return(FALSE);}
}

int main(int argc, char *argv[]) 
{
  int i, inf[1];
  char *host=NULL, line[MXCOLMN+1], line1[MXCOLMN+1];
  
  if(NoPVMrunning()) {printf("PVM not running!\n");return(1);}
  strcpy(line,TX);
  printf("%s\n%s",line,BL);
  for(i=1;i<argc;i++) {
    host=argv[i];
    if(strlen(line)>=MXCOLMN-10) { printf("\n"); strcpy(line,TX); }
    strcpy(line1,line);
    strncat(line1,host,MXCOLMN-strlen(line1));
    printf("%s\n%s",line1,BL);
    pvm_addhosts(&host,1,inf);
    if(inf[0]<0) switch (inf[0]) {
		 case PvmDupHost: 
		   strcpy(line1,"*");strcat(line1,host);
		   strncat(line,line1,MXCOLMN-strlen(line)); break;
		 default: 
		   strcpy(line1,"!");strcat(line1,host);strcat(line1,"!");
		   strncat(line,line1,MXCOLMN-strlen(line)); break;
    }
    else strncat(line,host,MXCOLMN-strlen(line));
    strncat(line," ",MXCOLMN-strlen(line));
    printf("%s\n%s",line,BL);
  }
  printf("\n");
  return(0);
}
