/*  Program for Calculating the Chromatic Number of a Graph (De Bruijn Alg.) */
/*                 GRCOL Header File 1995 febr. 13                           */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
/* #include <malloc.h> */
#include <math.h>
#include <memory.h>
#include <ctype.h>

/*#include <pvm3.h> */

#define MAX_NR_PROC 10           
#define MAXBUFFSIZE 256
#define MAXGRAPHSIZE 30

#define TIDS_INIT 0               /* message tags */
#define GRAPH_SEND 1
#define CHRNR_SEND 2
                        /* structure definitions */
struct Node {int label; int edges[MAXGRAPHSIZE]; struct Node *next;};

struct SearchTree {int action; struct Node *graph; int chrnr; 
                   int p1; int p2;
                   struct SearchTree *prev; struct SearchTree *next;
                 };

                       /* global variables */
extern int nproc;
extern int info_mod; 

                       /* function templates */  
struct Node *parent_init (char *);
void grcol_err (int);
struct Node *graph_read (FILE *);
int graph_pack (struct Node *, int[]);
struct Node *graph_unpack (int[]);
int find_points (struct SearchTree *);
struct SearchTree *join_points (struct SearchTree *);
int clique_size (struct Node *);
struct SearchTree *merge_points (struct SearchTree *);
struct SearchTree *backtr (struct SearchTree *);
struct Node *copyNode (struct Node *, struct Node *);
void *allocMem (unsigned int, size_t);
void freeMem (void *);
void trace_info (int, struct SearchTree *, char *, int);

/* End */

















