/* {[(  LIBRARY    GRCOL_LIB.C File 1997 marc. 15.                           */

#include "grcol.h"

/******************                                  ***************************/
struct Node *parent_init (char *filename)
{ 
   FILE *inpf;
   int iii, bufid;

   inpf = fopen (filename, "r");    /* Open the graph file */
   if (inpf == NULL) grcol_err (1);

   return (graph_read (inpf));
}

/******************                                  ***************************/
struct Node *graph_read (FILE *inpf)
{  int iii;
   char buff[MAXBUFFSIZE+1], *str;
   struct Node *root, *work;

   root = work = (struct Node *) allocMem (1, sizeof (struct Node));

   while (fgets (buff, MAXBUFFSIZE, inpf) != NULL)
   {  work->next = (struct Node *) allocMem (1, sizeof (struct Node));
      work = work->next;
      str = strtok (buff, ":");
      work->label = atoi (str);
      iii = 0;
      while ( (str = strtok (NULL, ",")) != NULL )
      {  (work->edges)[iii++] = atoi (str);
      }
      (work->edges)[iii] = -1;   /* 'end' stamp */
   }
   work = root->next;
   freeMem (root);
   return (work);
}

/******************                                  ***************************/
int graph_pack (struct Node *graph, int buffer[])
{  
   int iii, jjj;
   int node_nr;
   struct Node *cur = graph;

   iii = 0;                     /* how many nodes has the graph? */
   while (cur != NULL) 
   {  cur = cur->next;
      iii++;
   }
   node_nr = iii;
   cur = graph;

   buffer[0] = node_nr;
   iii = 1;

   while (cur != NULL)
   {  
      buffer[iii++] = cur->label;

      for (jjj=0; jjj<MAXGRAPHSIZE; jjj++)
        buffer[iii++] = cur->edges[jjj];

      cur = cur->next; 
   }

   return (0);
}

struct Node *graph_unpack (int buffer[])
{  
   int iii, jjj, kkk, node_nr, res;
   struct Node *root, *cur;

   root = cur = (struct Node *) allocMem (1, sizeof (struct Node));

   node_nr = buffer[0];
   iii = 1;

   for (kkk=0; kkk<node_nr; kkk++)
   {   
      cur->next = (struct Node *) allocMem (1, sizeof (struct Node));
      cur = cur->next;
    
      cur->label = buffer[iii++];

      for (jjj=0; jjj<MAXGRAPHSIZE; jjj++)
          cur->edges[jjj] = buffer[iii++];
   }

   cur = root->next;
   freeMem (root);
   return (cur);
}

/******************************************************************************/

int find_points (struct SearchTree *setr)
{
   int p1, p2, iii;
   struct Node *g1, *g2;

   g1 = setr->graph;
   do
   {  g2 = g1;
      while ( (g2 = g2->next) != NULL )
      {
         p2 = g2->label;
         iii = -1;
         while ( ((p1 = g1->edges[++iii]) != -1) && (p1 != p2) ) ;
         if (p1 == -1)              /* free pair found! */
         {  setr->p1 = g1->label;
            setr->p2 = g2->label;
            return (1);
         }
      }
    } while ( (g1 = g1->next) != NULL );

   return (0);
}

/******************                                  ***************************/
struct SearchTree *join_points (struct SearchTree *setr)
{  int iii=-1, p1;
   struct SearchTree *work;
   struct Node *ori, *neww, *root;
                                                     /* Initializing */
   setr->next = work = 
        (struct SearchTree *) allocMem (1, sizeof (struct SearchTree));
   setr->action = 2;
   work->action = 1;
   work->chrnr = MAXGRAPHSIZE;
   work->prev = setr;
   work->next = NULL;

   ori = setr->graph;                              /* Copy the graph */
   root = neww = (struct Node *) allocMem (1, sizeof (struct Node));
   while (ori != NULL)
   {  neww = copyNode (neww, ori);
      ori = ori->next;
   }
   work->graph = neww = root->next;
   freeMem (root);

   p1 = setr->p1;                                 /* add a new edge */
   while (neww != NULL)
   {  if (neww->label == p1) 
      {  while (neww->edges[++iii] != -1) ;
         neww->edges[iii] = setr->p2;
         neww->edges[iii+1] = -1;
         break;
      }
      neww = neww->next;
   }
   return (work);
}

/******************                                  ***************************/
int clique_size (struct Node *graph)
{  int iii=0;

   while (graph != NULL)
   {  iii++;
      graph = graph->next;
   }
   return (iii);
}

/******************                                  ***************************/
struct SearchTree *merge_points (struct SearchTree *setr)
{  int iii, jjj, p1, p2;
   struct SearchTree *work;
   struct Node *ori, *neww, *root, *g1;
                                                  /* Initializing */
   setr->next = work = 
      (struct SearchTree *) allocMem (1, sizeof (struct SearchTree));
   setr->action = 3;
   work->action = 1;
   work->chrnr = MAXGRAPHSIZE;
   work->prev = setr;
   work->next = NULL;

   ori = setr->graph;                           /* Copy the graph */
   root = neww = (struct Node *) allocMem (1, sizeof (struct Node));

   while (ori != NULL) 
   {  if (ori->label == setr->p2)         /* copy the edges to g1 */
      {  iii = -1;
         while ( (p2 = ori->edges[++iii]) != -1 )
         {  jjj = -1;
            while ( ((p1 = g1->edges[++jjj]) != -1) && (p1 == p2) ) ;
            if (p1 == -1)
            {   g1->edges[jjj] = p2;
                g1->edges[jjj+1] = -1;
            }
         }
      }
      else 
      {  neww = copyNode (neww, ori); /* this will be the merged point */
         if (ori->label == setr->p1) g1 = neww; 
      }
      ori = ori->next;
   }
   work->graph = neww = root->next;
   freeMem (root);

   return (work);
}

/******************                                  ***************************/
struct SearchTree *backtr (struct SearchTree *setr)
{
   struct SearchTree *work;
   struct Node *g1, *g2;

   work = setr->prev;                       /* one level upward */
   work->chrnr =  minim (setr->chrnr, work->chrnr);
   g1 = setr->graph;
   freeMem (setr);

   while ( (g2 = g1->next) != NULL)
   {  freeMem (g1);
      g1 = g2;
   }
   freeMem (g1);
   return (work);
}

/******************                                  ***************************/
struct Node *copyNode (struct Node *neww, struct Node *ori)
{  int iii;
   struct Node *work;
   
   neww->next = work = (struct Node *) allocMem (1, sizeof (struct Node));
   work->label = ori->label;
   work->next = NULL;
   for (iii=0; iii<MAXGRAPHSIZE; iii++)
   {   work->edges[iii] = ori->edges[iii];
   }
   return (work);
}

/******************                                  ***************************/
void *allocMem (unsigned int n, size_t size)
{
    void        *p;

    if ((p = calloc (n, size)) == NULL)
        printf ("Out of memory");
    return p;

}

/******************                                  ***************************/
void freeMem (void *pt)
{                           /*ide kellene a != NULL vizsgalat!!!!!!!! */
   free (pt);
}

/******************                                  ***************************/
void grcol_err (int code)
{
   printf ("\n-----------> Error, Code %d !", code);
   exit(0);
}
/******************                                  ***************************/
int minim (int a, int b)
{
   if (a<b) return (a);
   else return (b);
}

/******************                                  ***************************/
void trace_info (int loc, struct SearchTree *setr, char *process, int inf2)
{ 
   int iii;
   char work[256], *str;
   struct Node *gr = setr->graph;

   switch (loc)
   {   case 1:
          grp_printf ("\n\t%s:", process);
          break;

       case 2:
          grp_printf ("\n %s ----> Join", process);
          return;

       case 22:
          grp_printf ("\n ----> Send graph from process: %s", process);
          return;

       case 3:
          grp_printf ("\n %s Complete graph!", process);
          return;

       case 4:
          grp_printf ("\n %s ----> Merge", process);
          return;

       case 5:
          grp_printf ("\n %s ----> Back", process);
       
          return;

       case 6:
          grp_printf ("\n Process %s send %d as chrnr to boss.\n", process, inf2);
          return;

       default: 
          grp_printf ("\n Location code ???");     
   }

   switch (setr->action)
   {  case 1 : grp_printf ("New");
               break;
      case 2 : grp_printf ("Left");
               break;
      case 3 : grp_printf ("Both");
               break;
      default: grp_printf ("???");
               break;
   }
   grp_printf ("\tChr Nr: %d,\tpoint1: %d,\tpoint2: %d",
              setr->chrnr, setr->p1, setr->p2);

/*   if (info_mod < 2) return; */

   grp_printf ("\n\t");
   while (gr != NULL)
   {   grp_printf ("| %.2d:", gr->label);
       for (iii = 0; iii<MAXGRAPHSIZE; iii++)
       {  if (gr->edges[iii] == -1) break;
          else grp_printf (" %.2d", gr->edges[iii]);
       }
       gr = gr->next;
   } 

   return;
 }

/* End )]} */
