/*
 * Grapnel API for Grapnel environment (ddstuff_srv.h)
 *
 * Copyright (c) Drotos Daniel, University of Miskolc. 1994,98
 *
 */

/* This file is part of Grapnel API for GRAPNEL environment.

   The GRAPNEL system is part of SEPP project. This project is
   supported by the EC within COPERNICUS Research Project
   No. 5383. The grp2c (Grapnel Compiler) translates GRP files,
   generated by the Graphical Program Editor (GRED), into C
   source. Latest version of the grapnel compiler is available on site
   mazsola:

   http://mazsola.iit.uni-miskolc.hu/~dani/grp2c
*/
/*@1@*/

#ifndef DDstuffSrvHeader
#define DDstuffSrvHeader

#include "grptyps.h"


extern int  TapeLevel;  /* Level of tape event generation */
extern int  Debug;      /* Run application with debugging facilities */
extern int  Verbose;    /* Print out what is going on */
extern int  Force;      /* Do not check version numbers */
extern int  SkipMap;    /* Do not read mapping file */
extern int  NoGRED;     /* Program started by hand, not by GRED */
extern long TimeLimit;  /* After TimeLimit secs are elapsed, stop */
extern int  FirstPar;	/* Index of first param passed to processes */


extern struct TProcessInfo *stat_pinf;

/* `Internal' functions */

extern struct TProcessInfo *
grp_pinfbyname(struct TProcessInfo *pinfs, char *name);
extern struct TProcessInfo *
grp_pinfbytid(struct TProcessInfo *pinfs, int tid);
extern int grp_open_file(struct TProcessInfo *pinf, char *name, char *mode);
extern int grp_close_file(struct TProcessInfo *pinf, int fd);
extern FILE *grp_getfile(struct TProcessInfo *pinf, int fd);

/* Reading mapping file */

extern int ReadMapFile(struct TProcessInfo pinfs[], char *AppName);

/* Initialization routine of the Grapnel programs. It parses parameters
   of the program */

extern void Init(int argc, char *argv[], char *VerGrp2c, char *Headers);

#endif

/* End of ddstuf_srv.h */
