/*
 * Grapnel API for Grapnel environment (grapnel_cl.h)
 *
 * Copyright (c) Drotos Daniel, University of Miskolc. 1994,98
 *
 */

/* This file is part of Grapnel API for GRAPNEL environment.

   The GRAPNEL system is part of SEPP project. This project is
   supported by the EC within COPERNICUS Research Project
   No. 5383. The grp2c (Grapnel Compiler) translates GRP files,
   generated by the Graphical Program Editor (GRED), into C
   source. Latest version of the grapnel compiler is available on site
   mazsola:

   http://mazsola.iit.uni-miskolc.hu/~dani/grp2c
*/
/*@1@*/

/* Original copyright (c) Peter Mork, Drotos Daniel 1994,97  */

#ifndef PVM_GRAPNEL_CL_HEADER
#define PVM_GRAPNEL_CL_HEADER

#include "grptyps.h"

/* global variables */

extern int  server;		/* server process task id   */

/*
 * Function declarations
 *___________________________________________________________________________
 *
 * Documentation of these functions is at
 *
 * http://mazsola.iit.uni-miskolc.hu/~dani/grp2c
 * 
 */

/* Initialization and administration */

extern void grp_start(void);
extern void grp_exit(int code);
extern void grp_init_channel(struct Tchannel *ch, int nuof_channs);
extern int  grp_BeginBlock(int Type, int iID, int gen_event);

/* Sending */

extern void grp_pre_send(struct Tchannel *ch, int magic);
extern void grp_pack(void *data, int n, int type);
extern int  grp_post_send(struct Tchannel *ch, int magic);

/* Receiving */

extern int  grp_pre_recv(struct Tchannel *ch, int *magic);
extern void grp_unpack(void *data, int no, int type);
extern int  grp_post_recv(struct Tchannel *ch);

/* ALT */

extern int  grp_pre_mrecv(struct Tchannel **ch, int *which);
extern int  grp_post_mrecv(struct Tchannel **ch, int *which, int block_send);

/* Multicast */

extern int  *grp_pre_mcast(struct Tchannel *ch, int *ch_no);
extern void grp_mcast(struct Tchannel *ch, void *data, int type);
extern void grp_post_mcast(int *mcast, int ch_no);

/* User functions */

extern int  grp_fopen(char *name, char *mode);
extern int  grp_fclose(int fd);
extern void grp_fprintf(int fd, char *format, ...);
extern void grp_printf(char *format, ...);
extern void grp_scanf(char *msg, void *data, int type);
extern void grp_fatal(char *format, ...);

#endif

/* End of grapnel_cl.h */
