/*
 * Grapnel API for Grapnel environment (grapnel_srv.h)
 *
 * Copyright (c) Drotos Daniel, University of Miskolc. 1994,98
 *
 */

/* This file is part of Grapnel API for GRAPNEL environment.

   The GRAPNEL system is part of SEPP project. This project is
   supported by the EC within COPERNICUS Research Project
   No. 5383. The grp2c (Grapnel Compiler) translates GRP files,
   generated by the Graphical Program Editor (GRED), into C
   source. Latest version of the grapnel compiler is available on site
   mazsola:

   http://mazsola.iit.uni-miskolc.hu/~dani/grp2c
*/
/*@1@*/

/* Original copyright (c) Peter Mork, Drotos Daniel 1994,97  */

#ifndef PVM_GRAPNEL_SRV_HEADER
#define PVM_GRAPNEL_SRV_HEADER

#include "grptyps.h"

/*
 * Function declarations
 *___________________________________________________________________________
 *
 * Documentation of these functions is at
 *
 * http://mazsola.iit.uni-miskolc.hu/~dani/grp2c
 * 
 */

/* Functions for common use */

extern char *grp_version(int *High, int *Low, int *PatchLevel);

/* Functions for server program */

extern int  grp_create_proc(struct TProcessInfo pinf, int flag,
			    int argc, char *argv[]);
extern int  grp_stop_process(int tid);
extern void grp_create_channel(struct TProcessInfo src,
			       struct TProcessInfo dest,
			       int msgtag);
extern void grp_report_channel(int msgtag,
			       char *fromproc, int fromSID, int fromType,
			       char *toproc, int toSID, int toType);
extern void grp_server(int NuOfProc/*, FILE *fp*/);
extern int  grp_start_server(void);


#endif

/* End of grapnel_srv.h */
