/*
 * Grapnel API for Grapnel environment (grptyps.h)
 *
 * Copyright (c) Drotos Daniel, University of Miskolc. 1994,98
 *
 */

/* This file is part of Grapnel API for GRAPNEL environment.

   The GRAPNEL system is part of SEPP project. This project is
   supported by the EC within COPERNICUS Research Project
   No. 5383. The grp2c (Grapnel Compiler) translates GRP files,
   generated by the Graphical Program Editor (GRED), into C
   source. Latest version of the grapnel compiler is available on site
   mazsola:

   http://mazsola.iit.uni-miskolc.hu/~dani/grp2c
*/
/*@1@*/

#ifndef GRPTYPS_HEADER
#define GRPTYPS_HEADER

/* General definitions */

#define TRUE        1
#define True        1 
#define true        1
#define FALSE       0
#define False       0
#define false       0

#define STR_LEN     1024 /* Longest printf argument       */


/* Message tags for internal use */

#define GRP_PRINT   	1
#define GRP_EXIT    	2
#define GRP_CHINIT  	3
#define GRP_ACK     	4
#define GRP_DEBUG   	5
#define GRP_FATAL   	6
#define GRP_SYNC    	7
#define GRP_SCANF	8
#define GRP_MCHINIT	9
#define GRP_SRVID	10
#define GRP_GETPINF	11
#define GRP_NOTIFY	12
#define GRP_OPEN	13
#define GRP_CLOSE	14


/* Possible reasons of process' finish */

#define REASON_EXIT	0	/* grp_exit() called (GRP_EXIT sent) */
#define REASON_FATAL	1	/* grp_fatal() called (GRP_FATAL sent) */
#define REASON_ERROR	2	/* unknown reason (GRP_NOTIFY sent) */

/* Type of ProcessInfo structure.
   It is used to store information about processes
   in the Grapnel Programming Environment */

/* list of opened files for a process */

struct pfile {
  FILE *f;
  struct pfile *next;
};

struct TProcessInfo
{
  char *Name;    	/* Name of the process */
  int  numid;		/* Numerical ID of the process, comes from GRP file */
  int  tid;      	/* Process Identification Number */
  int  Info;     	/* TRUE if process is started successfully */
  char *cpu;     	/* Where to start the process (can be NULL) */
  struct pfile *files; /* List of opened files */
  struct TProcessInfo *next;
};


/*
  Channel definition (2nd version). 
  It is used in processes to define an array of channels
*/

struct Tchannel
{
  int  msgtag;   /* Message tag: channel identifier */
  int  Type;     /* Type of the port */
  /*char *Name;*/ /* Name of the port */
  int  SID;      /* ID of the port */
  char *ToName;  /* Name of the process where the channel is going */
  int  remote;   /* Process ID of connected process */
  int  ToSID;    /* Port ID of connected port */
};


/* Supported types in channel communication */

/*#define TYPE_MASK   7*/
#define BYTE        0
#define DOUBLE      1
#define FLOAT       2
#define INT         3
#define LONG        4
#define STR         5
#define UNKNOWN	    6

/* Supported type of communication  */

#define COMM_MASK   8
#define C_SYNC      0
#define C_NOSYNC    8


/*
  How many additional information will be sent with messages 
*/

#define MagicNothing	0x00	/* Nothing */
#define MagicTypes	0x01	/* Type of data */
#define MagicBlocked	0x80	/* Communication is blocked */


/* Code definitions for monitoring/visualisation support */

#define CODE_XXX	0
#define CODE_PROCICON	514
#define CODE_SEQ	1025
#define CODE_CAI	1541
#define CODE_CAO	2053
#define CODE_CAIALT	2565
#define CODE_CONDS	3113
#define CODE_CONDE	3633
#define CODE_RES	4161
#define CODE_LOOPS	4617
#define CODE_LOOPE	5137
#define CODE_INPORT	5763
#define CODE_OUTPORT	6275
#define CODE_INOUTPORT	6787
#define CODE_GLOBAL	7297
#define CODE_LOCAL	7809
#define CODE_PARAMS	8321
#define CODE_STP	8769
#define CODE_DPS	9217
#define CODE_DUMMYS	10113
#define CODE_DUMMYE	10625
#define CODE_GRPH	10817

#define event_GRAPNEL   87
#define event_PROCNAME	88
#define event_CHANNEL	89

#endif

/* End of grptyps.h */
