#ifndef MDBG_H
#define MDBG_H

#include "types.h"

#include "errors.h"

void dbg_copy_info_code(code_info *dest, code_info src);
int dbg_attach(int tid,code_info *nfo);
int dbg_set_break(int tid,code_info src);
int dbg_interrupt(int tid,code_info *nfo);
int dbg_info_break(int brek, brkpt_info *nfo);
int dbg_info_stack(int tid,int count, stack_info *nfo);
int dbg_info_process(int tid, proc_info *nfo);
int dbg_clear_break(int brek);
int dbg_continue(int tid);
int dbg_info_locals(int tid, locals_info *nfo);
int dbg_info_args(int tid, args_info *nfo);
int dbg_get_var(int tid, char *varname, char *response);
int dbg_set_var(int tid, char *varname, char *value);
int dbg_kill(int tid);
int dbg_detach(int tid);
int dbg_next(int tid);
int dbg_finish(int tid);
int dbg_return(int tid,char *exp);
int dbg_step(int tid);
int dbg_run(int tid);
int dbg_get_news(news_info *nfo);
int dbg_init(char *mach);
int dbg_end(void);

#endif
