/*
 * grp2c translator for Grapnel environment, parser (pappcl.h)
 *
 * Copyright (c) Drotos Daniel, University of Miskolc. 1994,98
 *
 */

/* This file is part of parser library which is part of grp2c
   translator program for GRAPNEL environment.

   The GRAPNEL system is part of SEPP project. This project is
   supported by the EC within COPERNICUS Research Project
   No. 5383. The grp2c (Grapnel Compiler) translates GRP files,
   generated by the Graphical Program Editor (GRED), into C
   source. Latest version of the grapnel compiler is available on site
   mazsola:

   http://mazsola.iit.uni-miskolc.hu/~dani/grp2c
*/
/*@1@*/

#ifndef PAppClHeader
#define PAppClHeader

#include "ddconfig.h"

#include "parstyps.h"
#include "pobj.h"
#include "pproccl.h"
#include "pgroupcl.h"
#include "pwindcl.h"
#include "pparamcl.h"
#include "psrccl.h"

typedef class TprsApplication *PprsApplication;
typedef class TprsAppColl     *PprsAppColl;


class TprsApplication: public TObject
{
public:
  char		 *Name; // Never NULL
  PprsGroupColl  Headers[prsthLast+1];
  PprsProcColl   ProcColl;
  PprsWindowColl Windows;
  int            IntForProcNumID;

          TprsApplication(char *AName);
  virtual ~TprsApplication(void);

  virtual int            Init(void);

  virtual PprsGroupColl  MakeGroupColl(int i);
  virtual PprsWindowColl MakeWindowColl(void);
  virtual PprsProcColl   MakeProcColl(void);

  virtual void           ShowData(FILE *To, char *Pre);
  virtual void           WriteGRP(FILE *To, int Ind);
  virtual void           ShowTasks(FILE *To);
};


class TprsAppColl: public TCollection
{
public: 
  PprsApplication Active;
  PprsGroup       ActiveGroup;

  PCollection     ItemStack;     // Needed by parser
  PprsItem        ProgramItem;   // Needed by parser
  PCollection     ItemCollStack; // Needed by parser

          TprsAppColl(TIndex ALimit, TIndex ADelta);
  virtual ~TprsAppColl(void);
  
  // Making and handling applications

          PprsApplication ActivateApp(char *name);
  virtual PprsApplication MakeApplication(char *name);
          PprsApplication FoundAppByName(char *name);

  // Processing header and screen section

          PprsGroup       ActivateGroup(int  Section,      // Header Section
					char *GroupName);
          PprsGroup       ActivateGroup(char *WindowName,  // Screen Section
					char *GroupName);

          PprsValueColl   StartNewParam(char *AName);
          PprsParam       AddParam(PprsParam param);
  virtual PprsParam       MakeParam(long AValue);
  virtual PprsParam       MakeParam(double AValue);
  virtual PprsParam       MakeParam(char *AValue);

  // Processing processes

          PprsProcess     ActivateProc(char *name, int numid);
          PprsProcess     AddProc(PprsProcess proc);
          void            finish_procgrp(void);
          PprsProcess     GetActiveProc(void);

          void            InsertProcessHeader(prsTPHeaderType HeaderType, 
					      PprsSource src);

  // Processing ports

  virtual PprsPort        MakePort(prsTPortRec rec);
          bool            AddPort(PprsPort port);
  virtual PPortRefAndSrc  MakePortRef(PprsPort port);
          void            AddSourceToLastPort(PprsSource src);
          void            AddGuardToLastPort(PprsSource src);
          bool            AddPortRef(int PortNum);

  // Processing program items

          PprsItem        StartParseItem(int          AID, 
					 prsTProgType AType,
					 char         *AName);
  virtual PprsItem        MakeProgramItem(int AID, prsTProgType  AType);
          void            SetSourceOfPrgItem(PprsSource src);
          bool            EndParseItem(void);
          void            SetItemOption(iopType what, iopValue val, void *inf);

  // Connections

  virtual PprsConn        MakeConnection(prsTConnType AType,
					 int          ANum,
					 int          AiID,
					 PprsSource   Src);
          void            AddConnection(PprsConn Conn);

  // Reports

  virtual void            ShowData(FILE *To, char *Pre);
  virtual void            WriteGRP(FILE *To, int Ind);
  virtual void            ShowTasks(FILE *To);
};


#endif

/* End of pappcl.h */
