/*
 * grp2c translator for Grapnel environment, parser (parscl.h)
 *
 * Copyright (c) Drotos Daniel, University of Miskolc. 1994,98
 *
 */

/* This file is part of parser library which is part of grp2c
   translator program for GRAPNEL environment.

   The GRAPNEL system is part of SEPP project. This project is
   supported by the EC within COPERNICUS Research Project
   No. 5383. The grp2c (Grapnel Compiler) translates GRP files,
   generated by the Graphical Program Editor (GRED), into C
   source. Latest version of the grapnel compiler is available on site
   mazsola:

   http://mazsola.iit.uni-miskolc.hu/~dani/grp2c
*/
/*@1@*/

#ifndef PParsClHeader
#define PParsClHeader

#include "ddconfig.h"

#include "parstyps.h"
#include "pobj.h"
#include "pappcl.h"
#include "ppgroupcl.h"


typedef class TParser *PParser;

class TParser: public TObject
{
public: 
  PUnsortedStrings InFiles;         // Always unsorted strings
  char		   *InFile;         // Name of the actual input file
  TIndex           ActualInFile;    // Index of actual input file
  // Temps to store parameters and other data during parsing
  // These are for error reports
  int		   ProgNumber;      // Holds prog item ID or 0 during parse
  long		   LineNum;         // Where error occured
  int		   ErrorCode;       // Error code of parser 
  int              ErrorTemp;       // Temp to store prsError

  bool             ShowDt;          // Report data structures
  bool             ShowGRP;         // Produce GRP output
  bool             ShowTask;        // Produce Task Graph
  bool		   Debug;           // Can be an option
  bool             EmacsErr;        // Errors in Emacs form
  char             DealParam;       // a= append, o= redefine, e= error

  PprsAppColl      Apps;            // Made by "MakeAppColl()"

          TParser(void);
  virtual ~TParser(void);

  // Initialization

  virtual int         Init(void);
  virtual PprsAppColl MakeAppColl(void);
          void        AddInFile(char *FileName);
  	  int	      LoadInFiles(char *fname);

  // Parsing

          int         Parsing(void);
          bool        NextInFile(void);

  // Making elements

  virtual PprsProcGroup make_ProcGroup(int type, char *name, int id);

  // Reports

  virtual void        ShowData(FILE *To);
  virtual void        WriteGRP(FILE *To);
  virtual void        ShowTasks(FILE *To);
};


#endif

/* End of parscl.h */
