/*
 * grp2c translator for Grapnel environment, parser (parstyps.h)
 *
 * Copyright (c) Drotos Daniel, University of Miskolc. 1994,98
 *
 */

/* This file is part of parser library which is part of grp2c
   translator program for GRAPNEL environment.

   The GRAPNEL system is part of SEPP project. This project is
   supported by the EC within COPERNICUS Research Project
   No. 5383. The grp2c (Grapnel Compiler) translates GRP files,
   generated by the Graphical Program Editor (GRED), into C
   source. Latest version of the grapnel compiler is available on site
   mazsola:

   http://mazsola.iit.uni-miskolc.hu/~dani/grp2c
*/
/*@1@*/

#ifndef ParsTypsHeader
#define ParsTypsHeader

#include "ddconfig.h"
#include "psrccl.h"


#define byte			unsigned char

#if __CHAR_UNSIGNED__
#define fchar			int
#else
#define fchar			char
//#define fchar			int
#endif

#ifndef ObjTypsHeader
#define TRUE			1
#define FALSE			0
#define bool			int
#endif


enum    prsTPHeaderType {phtGlobal, phtLocal , phtHeads};
#define prsthEditor     0
#define prsthMapping    1
#define prsthDebug      2
#define prsthMonitor    3
#define prsthHardware   4
#define prsthLast       4
enum    prsTProgType    {ptSEQ    ,
			 ptCAI    , ptCAO    , ptCAIALT,
			 ptLOOPB  , ptLOOPE  ,
			 ptSWITCHB, ptSWITCHE,
			 ptIFB    , ptIFE,
		         ptGRAPHIC,
		         ptDUMMYB , ptDUMMYE};
enum    prsTPortType    {prtIn    , prtOut   , prtInOut,
		         prtMulticast, prtScatter, prtReduce, prtGather};
enum    prsTComputation {comNone, comSum, comProd, comAvg};
enum    prsTDataType    {dtChar   , dtInt    , dtFloat,
			 dtDouble , dtUnknown};
enum    prsTConnType    {ctIn     , ctOut};

enum    iopType		{iopBlocking, iopGuard};

enum	iopValue	{iopBlocked, iopUnblocked};

#include "pobj.h"

typedef struct
{
  char            *Name;
  prsTPortType    Type;
  prsTComputation Computation;
  int	          SID;
  char	          *ProcName;
  int             ProcID;
  int	          ToSID;
  PCollection     TypeList;
}
  prsTPortRec, *prsPPortRec;

/* Internal data type for parser to represent type of DataTypeNum rule */

typedef struct
{
  int        Integer;
  PprsSource Source;
} prsDataTypeNum;

#define prsIDsize		256
#define prsStrParamSize		1024

#define ceOK			0
#define ceStartApp		1
#define ceEndApp		2
#define ceNotEnoughMemory	3
#define ceTempFileOpen		4
#define cePortUndefined         5
#define ceInitApp		6
#define ceBadInvoke		7
#define ceSwitchToApp		8
#define ceErrorOpenFile         9

#define prsNuOfErrors1 10

#define ceNeedApplication	100
#define ceNeedColon		101
#define ceNeedID		102
#define ceNeedBraceOpen 	103
#define ceNeedBraceClose	104
#define ceNeedHeaderPart	105
#define ceNeedSection		106
#define ceNeedSectionName	107
#define ceNeedGroup		108
#define ceNeedEqu		109
#define ceNeedSemicolon 	110
#define ceNeedParam		111
#define ceEndlessString 	112
#define ceTooLongString 	113
#define ceNeedProgramPart	114
#define ceNeedAppPart		115
#define ceNeedProcess		116
#define ceNeedHeaderSection	117
#define ceNeedPrgHeaderType	118
#define ceNeedPortSection	119
#define ceNeedPortDef		120
#define ceNeedPortNum		121
#define ceNeedProc		122
#define ceNeedPortId		123
#define ceNeedProgramSection	124
#define ceNeedProgItem		125
#define ceNeedItemNum		126
#define ceNeedCC		127
#define ceNeedPort		128
#define ceNeedConnectionDef	129
#define ceNeedCID		130
#define ceNeedPCNR		131
#define ceNeedWindow		132
#define ceNeedFileName		133
#define ceNeedPrgItemParam	134
#define ceNeedDataType		135
#define ceNeedType		136
#define ceNeedBlockNum		137
#define ceNeedCase		138
#define ceNeedCaseNum		139
#define cePortRedefined		140
#define ceTypeRedefined		141
#define ceBlockRedefined	142
#define ceCaseRedefined		143
#define ceNeedConnection	144
#define ceNeedConnNum		145
#define ceNeedConnID		146
#define ceNeedBracketOpen	147
#define ceNeedBracketClose	148
#define ceNeedVarName		149
#define ceNeedVarNum		150
#define ceBadCSource            151
#define ceNeedCSource		152
#define ceNeedItemName          153
#define ceNeedItemParam         154
#define ceBadGraph              155
#define ceNoProcOfItem          156
#define ceUnstackedItem         157
#define ceNestToBad             158
#define ceNotInGroup            159
#define ceParamRedefined        160
#define ceBadDataType		161
#define ceNeedProcNumID		162
#define ceNeedProcName		163
#define ceNeedProcOrGroup	164
#define ceNeedRankNumber	165
#define ceNeedRankOrHeader	166
#define ceNeedComputation	167
#define ceNeedParenOpen		168
#define ceNeedParenClose	169

#define prsNuOfErrors2 70


#endif

/* End of parstyps.h */
