/*
 * grp2c translator for Grapnel environment, parser (pconnscl.h)
 *
 * Copyright (c) Drotos Daniel, University of Miskolc. 1994,98
 *
 */

/* This file is part of parser library which is part of grp2c
   translator program for GRAPNEL environment.

   The GRAPNEL system is part of SEPP project. This project is
   supported by the EC within COPERNICUS Research Project
   No. 5383. The grp2c (Grapnel Compiler) translates GRP files,
   generated by the Graphical Program Editor (GRED), into C
   source. Latest version of the grapnel compiler is available on site
   mazsola:

   http://mazsola.iit.uni-miskolc.hu/~dani/grp2c
*/
/*@1@*/

#ifndef PConnsClHeader
#define PConnsClHeader

#include "ddconfig.h"

#include "pobj.h"
#include "parstyps.h"
#include "psrccl.h"


typedef class TprsConn *PprsConn;


class TprsConn: public TObject
{
public:
  prsTConnType Type;    // Type of the connection
  int          Num;     // Number of the connection within prg item
  int          iID;     // Unique identifier
  PprsSource   Source;  // Attached source code

          TprsConn(prsTConnType AType,
		   int          ANum,
		   int          AiID,
		   PprsSource   ASrc);
  virtual ~TprsConn(void);

  virtual bool IsInput(void);
  virtual bool IsOutput(void);
  virtual bool Match(PprsConn Conn);

  virtual void ShowData(FILE *To, char *Pre);
  virtual void WriteGRP(FILE *To, int Ind);
};


#endif

/* End of pconnscl.h */
