/*
 * grp2c translator for Grapnel environment, parser (pgroupcl.h)
 *
 * Copyright (c) Drotos Daniel, University of Miskolc. 1994,98
 *
 */

/* This file is part of parser library which is part of grp2c
   translator program for GRAPNEL environment.

   The GRAPNEL system is part of SEPP project. This project is
   supported by the EC within COPERNICUS Research Project
   No. 5383. The grp2c (Grapnel Compiler) translates GRP files,
   generated by the Graphical Program Editor (GRED), into C
   source. Latest version of the grapnel compiler is available on site
   mazsola:

   http://mazsola.iit.uni-miskolc.hu/~dani/grp2c
*/
/*@1@*/

#ifndef PGroupClHeader
#define PGroupClHeader

#include "ddconfig.h"

#include "parstyps.h"
#include "pobj.h"
#include "pparamcl.h"


typedef class TprsGroup     *PprsGroup;
typedef class TprsGroupColl *PprsGroupColl;


class TprsGroup: public TObject
{
public:
  char        *Name;
  PCollection Params; // Coll of TprsValueColl (see pparamscl.h)

          TprsGroup(char *AName);
  virtual ~TprsGroup(void);

          PprsValueColl GetParam(char *AName);
          void          DeleteParam(char *AName);
  virtual void          ShowData(FILE *To, char *Pre);
  virtual void          WriteGRP(FILE *To, int Ind);
};


class TprsGroupColl: public TCollection
{
public:
  int Type;

          TprsGroupColl(TIndex ALimit, TIndex ADelta, int AType);
  virtual ~TprsGroupColl(void);

  // Making new group

          PprsGroup     GetGroup(char *name);
          PprsValueColl GetValueColl(char *GroupName,
				     char *ParamName);
          bool          GetValue(char *GroupName,
				 char *ParamName,
				 int  ParamNum,
				 long &Value);
          bool          GetValue(char   *GroupName,
				 char   *ParamName,
				 int    ParamNum,
				 double &Value);
          bool          GetValue(char *GroupName,
				 char *ParamName,
				 int  ParamNum,
				 char *Value);

  virtual PprsGroup     MakeGroup(char *name);

  virtual void          ShowData(FILE *To, char *Pre);
  virtual void          WriteGRP(FILE *To, int Ind);
};


#endif

/* End of pgroupcl.h */
