/*
 * grp2c translator for Grapnel environment, parser (pitemscl.h)
 *
 * Copyright (c) Drotos Daniel, University of Miskolc. 1994,98
 *
 */

/* This file is part of parser library which is part of grp2c
   translator program for GRAPNEL environment.

   The GRAPNEL system is part of SEPP project. This project is
   supported by the EC within COPERNICUS Research Project
   No. 5383. The grp2c (Grapnel Compiler) translates GRP files,
   generated by the Graphical Program Editor (GRED), into C
   source. Latest version of the grapnel compiler is available on site
   mazsola:

   http://mazsola.iit.uni-miskolc.hu/~dani/grp2c
*/
/*@1@*/

#ifndef PItemsHeader
#define PItemsHeader

#include "ddconfig.h"

#include <stdio.h>

#include "pobjt.h"
#include "psrccl.h"
#include "pconnscl.h"
#include "parstyps.h"

typedef class TprsItem     *PprsItem;
typedef class TprsItemColl *PprsItemColl;

#include "pproccl.h"


/*									   */
/***************************************************************************/
/*							      TProgramItem */
/***************************************************************************/
/*									   */


class TprsItem: public TObject
{
public:
  char         *Name;
  prsTProgType Type;
  int	       iID;
  prsTProgType Pair;
  struct
    {
      iopValue   Blocking;
      PprsSource Guard;
    } Options;
  
  //  char         *FileNames[2];
  PprsSource   Sources[2];
  PCollection  Connections;
  PCollection  Ports;          // PPortRefAndSrc (see pportcl.h)
  PprsItemColl NestedItems;    // Collection for nested blocks

          TprsItem(prsTProgType AType, int AID);
  virtual ~TprsItem(void);

  virtual int  Init(void);

  virtual void SetOption(iopType what, iopValue val, void *inf);

  virtual void ShowData(FILE *To, char *Pre);
  virtual void WriteGRP(FILE *To, int Ind);
};


/*									    *
  ==========================================================================*
						Collection of program items *
  ==========================================================================*
                                                                            *
*/

class TprsItemColl: public TSortedCollection
{
public:
          TprsItemColl(TIndex ALimit, TIndex ADelta);
  virtual ~TprsItemColl(void);
  
  virtual int	   Compare(void *Key1, void *Key2);
	  void	   InsertItem(PprsItem Item);
  virtual void	   *KeyOf(void *Item);

  virtual void     ShowData(FILE *To, char *Pre);
  virtual void     WriteGRP(FILE *To, int Ind);
};


#endif

/* End of pitemscl.h */
