/*
 * grp2c translator for Grapnel environment, parser (pobj.h)
 *
 * Copyright (c) Drotos Daniel, University of Miskolc. 1994,98
 *
 */

/* This file is part of parser library which is part of grp2c
   translator program for GRAPNEL environment.

   The GRAPNEL system is part of SEPP project. This project is
   supported by the EC within COPERNICUS Research Project
   No. 5383. The grp2c (Grapnel Compiler) translates GRP files,
   generated by the Graphical Program Editor (GRED), into C
   source. Latest version of the grapnel compiler is available on site
   mazsola:

   http://mazsola.iit.uni-miskolc.hu/~dani/grp2c
*/
/*@1@*/

#ifndef PObjHeader
#define PObjHeader

#include "ddconfig.h"

#include "pobjt.h"

typedef class TObject		*PObject;
typedef class TCollection	*PCollection;
typedef class TSortedCollection *PSortedCollection;
typedef class TStringCollection *PStringCollection;
typedef class TUnsortedStrings	*PUnsortedStrings;

/*									    #
  ==========================================================================#
								    TObject #
  ==========================================================================#
									    #
*/

class TObject
{
public:
          TObject(void);
  virtual ~TObject(void);

  virtual int Init(void);
};


/*									    #
  ==========================================================================#
								Tcollection #
  ==========================================================================#
									    #
*/

class TCollection: public TObject
{
protected:
  void		   **Items;
  TIndex	   Count;
  TIndex	   Limit;
  TIndex	   Delta;

public:
		   TCollection(TIndex ALimit, TIndex ADelta);
  virtual      	   ~TCollection(void);

	  void	   *At(TIndex index);
  virtual TIndex   IndexOf(void *Item);
  virtual TIndex   index_of(void *Item);
	  int	   GetCount(void);

	  void	   Pack(void);
  virtual void	   SetLimit(TIndex ALimit);

	  void	   AtFree(TIndex Index);
	  void	   AtDelete(TIndex Index);
	  void	   Delete(void *Item);
	  void	   DeleteAll(void);
//	  void	   Free(void *Item);
//	  void	   FreeAll(void);

	  void	   AtInsert(TIndex Index, void *Item);
	  void	   AtPut(TIndex Index, void *Item);
  virtual TIndex   Insert(void *Item);

	  void	   *FirstThat(TTestFunc Test, void *Arg);
	  void	   *LastThat(TTestFunc Test, void *Arg);
	  void	   ForEach(TAppFunc Action, void *Arg);

	  void	   Error(TIndex Code, TIndex Info);
private:
  virtual void	   FreeItem(void *Item);
};


/*									    #
  ==========================================================================#
							  TSortedCollection #
  ==========================================================================#
									    #
*/

class TSortedCollection: public TCollection
{
public:
  bool		   Duplicates;

          TSortedCollection(TIndex ALimit, TIndex ADelta);
  virtual ~TSortedCollection(void);
  
  virtual bool	   Search(void *Key, TIndex& Index);
  virtual TIndex   IndexOf(void *Item);
  virtual TIndex   Insert(void *Item);
  virtual void	   *KeyOf(void *Item);
private:
  virtual int	   Compare(void *Key1, void *Key2)= 0;
};


/*									    #
  ==========================================================================#
							  TStringCollection #
  ==========================================================================#
									    #
*/

class TStringCollection: public TSortedCollection
{
public:
          TStringCollection(TIndex ALimit, TIndex ADelta);
  virtual ~TStringCollection(void);
  
private:
  virtual int	   Compare(void *Key1, void *Key2);
  virtual void	   FreeItem(void *Item);
};


/*									    #
  ==========================================================================#
							   TUnsortedStrings #
  ==========================================================================#
									    #
*/

class TUnsortedStrings: public TStringCollection
{
public:
          TUnsortedStrings(TIndex ALimit, TIndex ADelta);
  virtual ~TUnsortedStrings(void);
  
private:
  virtual int	   Compare(void *Key1, void *Key2);
  virtual bool	   Search(void *Key, TIndex &Index);
};


#endif

/* End of pobj.h */
