/*
 * grp2c translator for Grapnel environment, parser (pparamcl.h)
 *
 * Copyright (c) Drotos Daniel, University of Miskolc. 1994,98
 *
 */

/* This file is part of parser library which is part of grp2c
   translator program for GRAPNEL environment.

   The GRAPNEL system is part of SEPP project. This project is
   supported by the EC within COPERNICUS Research Project
   No. 5383. The grp2c (Grapnel Compiler) translates GRP files,
   generated by the Graphical Program Editor (GRED), into C
   source. Latest version of the grapnel compiler is available on site
   mazsola:

   http://mazsola.iit.uni-miskolc.hu/~dani/grp2c
*/
/*@1@*/

#ifndef PParamClHeader
#define PParamClHeader

#include "ddconfig.h"

#include <stdio.h>

#include "parstyps.h"
#include "pobj.h"


typedef class TprsParam       *PprsParam;
typedef class TprsIntParam    *PprsIntParam;
typedef class TprsFloatParam  *PprsFloatParam;
typedef class TprsStringParam *PprsStringParam;

typedef class TprsValueColl   *PprsValueColl;


class TprsParam: public TObject
{
public:
          TprsParam(void);
  virtual ~TprsParam(void);

  virtual void PrintValue(FILE *To);
  virtual void ShowData(FILE *To, char *Pre);
  virtual bool GetValue(long *val);
  virtual bool GetValue(double *val);
  virtual bool GetValue(char **val);
};

class TprsIntParam: public TprsParam
{
public:
  long Value;

          TprsIntParam(long AValue);
  virtual ~TprsIntParam(void);

  virtual void PrintValue(FILE *To);
  virtual void ShowData(FILE *To, char *Pre);
  virtual bool GetValue(long *val);
  virtual bool GetValue(double *) {return(FALSE);}
  virtual bool GetValue(char **) {return(FALSE);}
};

class TprsFloatParam: public TprsParam
{
public:
  double Value;

          TprsFloatParam(double AValue);
  virtual ~TprsFloatParam(void);

  virtual void PrintValue(FILE *To);
  virtual void ShowData(FILE *To, char *Pre);
  virtual bool GetValue(double *val);
  virtual bool GetValue(long *) {return(FALSE);}
  virtual bool GetValue(char **) {return(FALSE);}
};

class TprsStringParam: public TprsParam
{
public:
  char *Value;

          TprsStringParam(char *AValue);
  virtual ~TprsStringParam(void);

  virtual void PrintValue(FILE *To);
  virtual void ShowData(FILE *To, char *Pre);
  virtual bool GetValue(char **val);
  virtual bool GetValue(long *) {return(FALSE);}
  virtual bool GetValue(double *) {return(FALSE);}
};


class TprsValueColl: public TCollection
{
public: 
  char *Name; // Name of parameter (it has list of values)

          TprsValueColl(char *AName);
  virtual ~TprsValueColl(void);

  virtual void ShowData(FILE *To, char *Pre);
  virtual void WriteGRP(FILE *To, int Ind);
};

#endif

/* End of pparamcl.h */
