/*
 * grp2c translator for Grapnel environment, parser (ppgroupcl.h)
 *
 * Copyright (c) Drotos Daniel, University of Miskolc. 1994,98
 *
 */

/* This file is part of parser library which is part of grp2c
   translator program for GRAPNEL environment.

   The GRAPNEL system is part of SEPP project. This project is
   supported by the EC within COPERNICUS Research Project
   No. 5383. The grp2c (Grapnel Compiler) translates GRP files,
   generated by the Graphical Program Editor (GRED), into C
   source. Latest version of the grapnel compiler is available on site
   mazsola:

   http://mazsola.iit.uni-miskolc.hu/~dani/grp2c
*/
/*@1@*/

#ifndef PProcGroupClHeader
#define PProcGroupClHeader

#include "ddconfig.h"

#include <stdio.h>

#include "parstyps.h"
#include "pobj.h"
#include "pproccl.h"
#include "pappcl.h"


typedef class TprsProcGroup  *PprsProcGroup;

class TprsProcGroup: public TprsProcess
{
public:
  int group_type;
  PprsProcColl Processes;

  TprsProcGroup(int Atype, char *AName, int numid);
  virtual ~TprsProcGroup(void);

  virtual int          Init(void);

  virtual PprsItemColl MakeItemColl(void);
  virtual PprsProcColl mk_proccoll(void);

  virtual bool         IsGroup(void);
  virtual char        *show_name_title(void);
  virtual int	       nuof(void);

  virtual void         ShowData(FILE *To, char *Pre);
  virtual void         WriteGRP(FILE *To, int Ind);
  virtual void         ShowTasks(FILE *To, PprsApplication app);
  virtual char        *grouptype_name(void);

  virtual PprsProcess  AddProcess(PprsProcess proc);
};


#endif


/* End of ppgroupcl.h */
