/*
 * grp2c translator for Grapnel environment, parser (pportcl.h)
 *
 * Copyright (c) Drotos Daniel, University of Miskolc. 1994,98
 *
 */

/* This file is part of parser library which is part of grp2c
   translator program for GRAPNEL environment.

   The GRAPNEL system is part of SEPP project. This project is
   supported by the EC within COPERNICUS Research Project
   No. 5383. The grp2c (Grapnel Compiler) translates GRP files,
   generated by the Graphical Program Editor (GRED), into C
   source. Latest version of the grapnel compiler is available on site
   mazsola:

   http://mazsola.iit.uni-miskolc.hu/~dani/grp2c
*/
/*@1@*/

#ifndef PPortClHeader
#define PPortClHeader

#include "ddconfig.h"

#include "parstyps.h"
#include "psrccl.h"

typedef class TPortRefAndSrc *PPortRefAndSrc;
typedef class TPortData      *PPortData;
typedef class TprsPort       *PprsPort;
typedef class TprsPortColl   *PprsPortColl;


/*									    #
  ==========================================================================#
						        Reference to a port #
  ==========================================================================#
									    #
  This object is used in ProgramItem
*/

class TPortRefAndSrc: public TObject
{
public:
  PprsPort    Port;
  PCollection Sources; // Collection of prsSources
  PprsSource  Guard;   // Can be NULL

          TPortRefAndSrc(PprsPort APort, PCollection ASources);
  virtual ~TPortRefAndSrc(void);

  virtual void ShowData(FILE *To, char *Pre);
  virtual void WriteGRP(FILE *To, int Ind);
};


/*									    #
  ==========================================================================#
						      Data type of the Port #
  ==========================================================================#
									    #
*/

class TPortData: public TObject
{
public:
  prsTDataType Type;
  int          Num;
  PprsSource   Src;

          TPortData(prsTDataType AType, int ANum, PprsSource ASrc);
  virtual ~TPortData(void);

  virtual void WriteGRP(FILE *To, int Ind);
};


/*									    #
  ==========================================================================#
								       Port #
  ==========================================================================#
									    #
*/

class TprsPort: public TObject
{
public:
  char             *Name;
  prsTPortType	   Type;
  int		   SID;
  char		   *ProcName;	// Can be NULL!!
  int              ProcID;
  int		   ToSID;	// Can be unknown
  bool		   Flag;
  char		   *TypeString;
  PCollection      DataTypes;    // PPortData
  int              MsgTag;       // Offset from GRP_CHAN
  prsTComputation  Computation;

          TprsPort(char            *AName,
		   prsTPortType    AType,
		   int             ASID,
		   char            *ToProc,
		   int             ToProcID,
		   int             AToSID,
		   PCollection     ADataTypes,
		   prsTComputation AComputation);
  virtual ~TprsPort(void);

  virtual void ShowData(FILE *To, char *Pre);
  virtual void WriteGRP(FILE *To, int Ind);
};


/*									    #
  ==========================================================================#
							Collection of ports #
  ==========================================================================#
									    #
*/

class TprsPortColl: public TSortedCollection
{
public:
          TprsPortColl(TIndex ALimit, TIndex ADelta);
  virtual ~TprsPortColl(void);
  
  virtual int	   Compare(void *Key1, void *Key2);
          PprsPort GetByNum(int ASID);
	  void	   InsertItem(PprsPort Item);
  virtual void	   *KeyOf(void *Item);

  virtual void     ShowData(FILE *To, char *Pre);
  virtual void     WriteGRP(FILE *To, int Ind);
};


#endif

/* End of pportcl.h */
