/*
 * grp2c translator for Grapnel environment, parser (pproccl.h)
 *
 * Copyright (c) Drotos Daniel, University of Miskolc. 1994,98
 *
 */

/* This file is part of parser library which is part of grp2c
   translator program for GRAPNEL environment.

   The GRAPNEL system is part of SEPP project. This project is
   supported by the EC within COPERNICUS Research Project
   No. 5383. The grp2c (Grapnel Compiler) translates GRP files,
   generated by the Graphical Program Editor (GRED), into C
   source. Latest version of the grapnel compiler is available on site
   mazsola:

   http://mazsola.iit.uni-miskolc.hu/~dani/grp2c
*/
/*@1@*/

#ifndef PProcClHeader
#define PProcClHeader

#include "ddconfig.h"

#include <stdio.h>

#include "parstyps.h"
#include "pobj.h"
#include "pportcl.h"

typedef class TprsProcess  *PprsProcess;
typedef class TprsProcColl *PprsProcColl;


#include "pitemscl.h"

class TprsProcess: public TObject
{
public:
  char	       *Name;
  int	       NumID;
  int	       Rank;
  PprsProcess  parent;		// in groups it points to parent group

  PCollection  Globals;		// HeaderSection
  PCollection  Locals;
  PCollection  Heads;
  PprsPortColl Ports;		// PortSection
  PprsItemColl PrgItems;	// ProgramSection

  PStringCollection depend;	// Filenames that this process depends on

          TprsProcess(char *AName);
  virtual ~TprsProcess(void);

  virtual int          Init(void);

  virtual PprsItemColl MakeItemColl(void);
  virtual PprsPortColl MakePortColl(void);
  virtual void         depend_on(char *fname);

  virtual bool         IsGroup(void);
  virtual char        *show_name_title(void);
  virtual int	       nuof(void);

  virtual void         ShowData(FILE *To, char *Pre);
  virtual void         WriteGRP(FILE *To, int Ind);
  virtual void         show_name(FILE *To, char sep);
};


class TprsProcColl: public TCollection
{
public:
  PprsProcess	Active;
  PCollection   GroupStack;

          TprsProcColl(TIndex ALimit, TIndex ADelta);
  virtual ~TprsProcColl(void);
  
          PprsProcess ActivateProc(char *name, int numid);
          PprsProcess AddProc(PprsProcess proc);
          void        finish_procgrp(void);
          PprsProcess FoundProcByName(char *name);
          PprsProcess FoundProcByID(int pid);
          PprsProcess FoundProc(char *name, int pid);

  virtual PprsProcess MakeProcess(char *name);

  virtual int	      nuof(void);

  virtual void        ShowData(FILE *To, char *Pre);
  virtual void        WriteGRP(FILE *To, int Ind);
};

#endif


/* End of pproccl.h */
