/*
 * grp2c translator for Grapnel environment, parser (psrccl.h)
 *
 * Copyright (c) Drotos Daniel, University of Miskolc. 1994,98
 *
 */

/* This file is part of parser library which is part of grp2c
   translator program for GRAPNEL environment.

   The GRAPNEL system is part of SEPP project. This project is
   supported by the EC within COPERNICUS Research Project
   No. 5383. The grp2c (Grapnel Compiler) translates GRP files,
   generated by the Graphical Program Editor (GRED), into C
   source. Latest version of the grapnel compiler is available on site
   mazsola:

   http://mazsola.iit.uni-miskolc.hu/~dani/grp2c
*/
/*@1@*/

#ifndef PSrcClHeader
#define PSrcClHeader

#include "ddconfig.h"

#include <stdio.h>

#include "pobj.h"

typedef class TprsMacro  *PprsMacro;
typedef class TprsSource *PprsSource;


class TprsMacro: public TObject
{
public:
          TprsMacro(void);
  virtual ~TprsMacro(void);

  virtual void ShowData(FILE *To, char *Pre);
};


/*									    *
  ==========================================================================*
                                                             Source element *
  ==========================================================================*
									    *
*/

class TprsSource: public TObject
{
public:
  char             *SourceString;
  int              Size;
  int              Eof;
  PCollection      Macros;
  char             *CharPtr;

          TprsSource(void);
          TprsSource(char *FileName);
  virtual ~TprsSource(void);
  
  virtual bool AddChar(char c);
  virtual void ShowData(FILE *To, char *Pre);
  virtual bool SpaceOnly(void);

  virtual FILE        *fOpen(const char *mode);
  virtual signed char Getc(FILE *fds);
  virtual int         fClose(FILE *fds);
  virtual int         fPrintf(FILE *To);
};


#endif

/* End of psrccl.h */
