/*
 * grp2c translator for Grapnel environment, parser (putils.h)
 *
 * Copyright (c) Drotos Daniel, University of Miskolc. 1994,98
 *
 */

/* This file is part of parser library which is part of grp2c
   translator program for GRAPNEL environment.

   The GRAPNEL system is part of SEPP project. This project is
   supported by the EC within COPERNICUS Research Project
   No. 5383. The grp2c (Grapnel Compiler) translates GRP files,
   generated by the Graphical Program Editor (GRED), into C
   source. Latest version of the grapnel compiler is available on site
   mazsola:

   http://mazsola.iit.uni-miskolc.hu/~dani/grp2c
*/
/*@1@*/

#ifndef PUtilsHeader
#define PUtilsHeader

#include "ddconfig.h"

#include <stdio.h>

#include "parstyps.h"
#include "psrccl.h"

extern int  TempCategory;

extern char *GetErrorString(int errorcode);
extern char *NewString(char *str);
extern void DisposeString(char *str);

extern int  StrLen(const char *S);
extern char *StrCpy(char *TO, void *FROM);
extern char *StrCat(void *TO, void *FROM);
extern char *StrStr(const char *HAYSTACK, const char *NEEDLE);
extern int  StrCmp(char *S1, char *S2);

extern int  LinesInString(char *str);
//extern void MakeTempFileName(char *Where);
//extern void RemoveTempFiles(void);
extern char *GetDataTypeName(prsTDataType AType);
extern void Indent(FILE *To, int Ind);
extern bool fprintfile(FILE *To, char *What);
extern bool fprintsrc(FILE *To, PprsSource What);
extern void Grp2cInitSignal(void);

#endif

/* End of putils.h */
