/*
 * Grapnel API with PVM target for Grapnel environment (pvm_grpdef.h)
 *
 * Copyright (c) Drotos Daniel, University of Miskolc. 1994,98
 *
 */

/* This file is part of Grapnel API with PVM target for GRAPNEL
   environment.

   The GRAPNEL system is part of SEPP project. This project is
   supported by the EC within COPERNICUS Research Project
   No. 5383. The grp2c (Grapnel Compiler) translates GRP files,
   generated by the Graphical Program Editor (GRED), into C
   source. Latest version of the grapnel compiler is available on site
   mazsola:

   http://mazsola.iit.uni-miskolc.hu/~dani/grp2c
*/
/*@1@*/

#ifndef PVM_GRAPNEL_DEFHEADER
#define PVM_GRAPNEL_DEFHEADER

#include "pvm3.h"

/* General definitions */

/*#define OK          FALSE*/
/*#define TIMEOUT     TRUE*/

#define SEND_MODE   PvmDataDefault

/* Options of process creation */

#define GRP_PcDefault 0
#define GRP_PcDebug   PvmTaskDebug

/*
   Channels are identified by pvm message tags.
   The 16th bit of the message tag is used to send 
   syncronisation messages. Therefore the number 
   of available channels is limited to 2^16
*/ 

#define GRP_MCAST   50       /* channel id for multicasting         */
#define GRP_CHAN    100      /* start number for channel allocation */
#define CHAN_ACK    0x10000  /* assuming 4 bytes long integers      */

#endif

/* End of grpdef.h */
