#ifndef __SLIB2_H
#define __SLIB2_H

#define DBG_OK 1
#define DBG_INEXISTENT_TASK -1
#define DBG_NOT_ON_DEBUG -2
#define DBG_ALREADY_ON_DEBUG -3
#define DBG_UNKNOWN -4
#define DBG_INEXISTENT_BREAK -5
#define DBG_GDB_TIMEOUT -6
#define DBG_INEXISTENT_TASK_ON_PVM -7
#define DBG_ATTACHER_ERROR -8
#define DBG_UNKNOWN_PLACE -9
#define DBG_BREAK_FAILED -10
#define DBG_NOT_READY -11

#define DBG_STATE_READY 1
#define DBG_STATE_RUNNING 2
#define DBG_STATE_STOPPED 3
#define DBG_STATE_DEAD 4

#define DBG_BREAK 1
#define DBG_WATCH 2
#define DBG_TEMP_BREAK 3

#define DBG_BREAK_STATE_ENABLED 1
#define DBG_BREAK_STATE_DISABLED 2
#define DBG_BREAK_STATE_IGNORED 3
#define DBG_BREAK_STATE_TEMPIGNORED 4
#include <maxdefs.h>
#define MAXPRID 100


typedef struct code_info
{
  int line_no; /* <=0 ignore */
  char source_file[120]; /* =="" NULL */ 
  char function_name[100];  /*=="" ignore*/
} code_info;

typedef struct var_info
{
  char name[100];
  char value[MAXVALUE];
} var_info;

typedef struct proc_info
{
  int status;
  int bwpid;
  code_info cinfo;
  char symbols[80];
} proc_info;



typedef struct locals_info
{
  int nvars;
  var_info vars[MAXARGS]; 
} locals_info;

typedef struct args_info
{
  int nargs;
  var_info args[MAXARGS]; 
} args_info;

typedef struct stack_info
{
  char source_file[160];
  char function_name[100];
  var_info vars[MAXARGS];
  int nvars;
} stack_info;


/* NOVAS ESTRUTURAS !!!!!!!!!!!!!!!!!!!!!!!!!!! */
#include <rs.h>
typedef brkpt_info2
brkpt_info;

typedef news_new_proc2
news_new_proc;

typedef news_info2
news_info;

int dbg_get_special_info(code_info *cnfo,char *procid);


int dbg_set_tid_proc(int tid, char prid[MAXPRID]);
int dbg_init(void);
int dbg_end(void);
int dbg_attach(char *procid, code_info *info);
int dbg_detach(char *procid);
int dbg_kill(char *procid);
int dbg_get_news(news_info *nfo) ;
int dbg_set_break(char *procid,code_info *nfo);
int dbg_set_cond_break(char *procid,code_info *nfo,char *exp);
int dbg_set_temp_break_func(char *procid,char *function_name);
int dbg_set_watch(char *procid,char *exp);
int dbg_disable_break(int brkptid);
int dbg_enable_break(int brkptid);
int dbg_ignore_break(int brkptid,int count);
int dbg_clear_break(int brkptid);
int dbg_select_frame(char *procid, int count);
int dbg_return(char *procid,char *exp, code_info *nfo);
int dbg_print(char *procid, char *fmt, char *exp, char *value);
int dbg_get_var(char *procid, var_info *var);
int dbg_set_var(char *procid, var_info *var);
int dbg_info_break(int brkptid,brkpt_info *info);
int dbg_info_stack(char *procid, int count, stack_info *info);
int dbg_info_locals(char *procid, locals_info *info);
int dbg_info_args(char *procid, args_info *info);
int dbg_info_process(char *procid, proc_info *info);
int dbg_run(char *procid);
int dbg_next(char *procid);
int dbg_step(char *procid);
int dbg_finish(char *procid);
int dbg_continue(char *procid);
int dbg_interrupt(char *procid,code_info *nfo);
int dbg_kill_server(void);
int dbg_get_procid(int pos, char *procid);

#endif
