#ifndef DBG_TYPES_H
#define DBG_TYPES_H
#include "maxdefs.h"

typedef struct code_info
{
  int line_no; /* <=0 ignore */
  char source_file[80]; /* =="" NULL */ 
  char function_name[80];  /*=="" ignore*/
} code_info;

typedef struct var_info
{
  char name[100];
  char value[MAXVALUE];
} var_info;

typedef struct news_new_proc
{
  int tid;
} news_new_proc;

typedef struct news_info
{
  int type;
  union {
    news_new_proc proc;
  } news;
} news_info;

typedef struct proc_info
{
  int status;
  int bwpid;
  code_info cinfo;
  char symbols[80];
} proc_info;

typedef struct brkpt_info
{
  int type;
  int process;
  code_info where;
  char condition[160];
  int state;
  int hits;
} brkpt_info;

typedef struct locals_info
{
  int nvars;
  var_info vars[MAXARGS]; 
} locals_info;

typedef struct args_info
{
  int nargs;
  var_info args[MAXARGS]; 
} args_info;

typedef struct stack_info
{
  char source_file[160];
  char function_name[100];
  var_info args[MAXARGS];
  int nvars;
} stack_info;

#endif
