/*
 *    Application program buffer. Generated by grp2c 0.32.13.
 *________________________________________________________________________
 *
 */

/* Default target is PVM */

#ifndef TARGET
#define TARGET pvm
#endif

#include <stdio.h>
#include <stdlib.h>
#include <sys/time.h>
#include <time.h>

#include "ddconfig.h"
#if TARGET == pvm
#include "pvm_grpdef.h"
#elif TARGET == mpi
#include "mpi_grpdef.h"
#elif TARGET == qnx
#include "qnx_grpdef.h"
#elif
#endif
#include "grptyps.h"
#include "grapnel.h"
#include "grapnel_srv.h"
#include "ddstuff.h"
#include "ddstuff_srv.h"
#include "slib.h"
#include "gred.h"

/* Instrumentation */

#define TapeInstrumented 1

#define        NeedInstrument
#define        VerGrp2cHi  0
#define        VerGrp2cLo  32
#define        VerGrp2cPat 13
char           *VerGrp2c=  "0.32.13";
FILE	       *fp;
int	       paretn, mytid;
struct timeval start_clock;
long	       offset;

struct TProcessInfo Pinf_Stat[]=
{
  {"Producer", 0, 0, FALSE, NULL, NULL, NULL},
  {"Consumer", 2, 0, FALSE, NULL, NULL, NULL},
  {"Buffer", 4, 0, FALSE, NULL, NULL, NULL},
  {NULL, 0, 0, 0, NULL, NULL, NULL}
};

/*
 * Service function. Called after a process has been stopped.
 *________________________________________________________________________
 *
 */

int srv_ProcessStopped(int tid, int exit_reason, int exit_code)
{
  int  i;
  char *n= "\0";

  i= 0;
  while (stat_pinf[i].Name &&
         (stat_pinf[i].tid != tid))
    i++;
  if (stat_pinf[i].Name)
    n= stat_pinf[i].Name;

  if (Debug)
    dbg_block_kill(n);
  if (!NoGRED)
    gred_proc_end(Debug, stat_pinf[i].numid, exit_reason, exit_code);
}


/*
 * Checking version numbers
 *________________________________________________________________________
 *
 */

int CheckVersions(void)
{
  int h, l, p, okay= TRUE;
  char *ver;

  ver= grp_version(&h, &l, &p);
  if ((h != VerGrp2cHi) ||
      (l != VerGrp2cLo) ||
      (p != VerGrp2cPat))
    {
      okay= FALSE;
      fprintf(stderr, "Incorrect version (%d) of Grapnel Library", ver);
      fprintf(stderr, ", required: %s\n", VerGrp2c);
    }
  if ((VerGrp2cHi  != GrpVersionHi) ||
      (VerGrp2cLo  != GrpVersionLo) ||
      (VerGrp2cPat != GrpVersionPat))
    {
      okay= FALSE;
      fprintf(stderr, "Incorrect version (%s) of Header Files", GrpVersion);
      fprintf(stderr, ", required: %s\n", VerGrp2c);
    }
  return(okay);
}


/*
 * Starting and stopping all processes
 */

void
start_processes(struct TProcessInfo *pinfs,
		int argc, char *argv[],
		int *succ, int *failed)
{
  int i;

  for (i= 0; pinfs[i].Name; i++)
    {
      if (pinfs[i].next)
	start_processes(pinfs[i].next, argc, argv, succ, failed);
      else
	{
	  pinfs[i].tid= grp_create_proc(pinfs[i],
					Debug?GRP_PcDebug:GRP_PcDefault,
					argc-FirstPar, &argv[FirstPar]);
	  if (Debug)
	    dbg_set_tid_proc(pinfs[i].tid, pinfs[i].Name);
          if (!NoGRED)
            gred_proc_start(Debug, pinfs[i].numid, pinfs[i].tid);
	  if (pinfs[i].tid < 0)
	    {
	      fprintf(stderr, "Process (%s) allocation error!\n",
		      pinfs[i].Name);
	      pinfs[i].Info= FALSE;
	      if (failed)
		(*failed)++;
	    }
	  else
	    {
	      pinfs[i].Info= TRUE;
	      if (succ)
		(*succ)++;
	    }
	}
    }
}


void
stop_processes(struct TProcessInfo *pinfs)
{
  int i;

  for (i= 0; pinfs[i].Name; i++)
    {
      if (pinfs[i].next)
	stop_processes(pinfs[i].next);
      else
	{
	   if (pinfs[i].Info)
	     {
	       grp_stop_process(pinfs[i].tid);
               srv_ProcessStopped(pinfs[i].tid, REASON_ERROR, 0);
	     }
	}
    }
}


/*
 * Main function of the application.
 *________________________________________________________________________
 *
 */

void main(int argc, char *argv[])
{
tape_start(&argc,argv,10000,20,2,15);
{
  int  NuOfProc= 0, failed= 0;
  char prt_buff[STR_LEN];
  int  msgtag= GRP_CHAN;
  int  i;
  struct timeval StartTime;

#ifdef PgInstrumented
#ifdef NeedInstrument
  pg_start("buffer");
#endif
#endif

  stat_pinf= Pinf_Stat;
  grp_start_time(&StartTime);
  Init(argc, argv, VerGrp2c, GrpVersion);
  if (!Force && !(CheckVersions()))
    exit(2);
  gettimeofday(&start_clock, (struct timezone*)0);
  if (!SkipMap)
    ReadMapFile(/*StatProcs,*/ stat_pinf, "buffer");

  if (!(grp_start_server()))		  /* Enroll into target system */
    {
#if TARGET == pvm
      fprintf(stderr, "pvm not responding.\n");
#elif TARGET == mpi
      fprintf(stderr, "mpi not responding.\n");
#elif TARGET == qnx
      fprintf(stderr, "qnx not responding.\n");
#endif
      exit(1);
    }
  if (Debug)
    dbg_init();
  if (!NoGRED)
    gred_init(Debug);

  if (Verbose)
    printf("\nProcess allocating...\n");

  start_processes(stat_pinf, argc, argv, &NuOfProc, &failed);

  if (Verbose)
    printf("Process allocation is done: %d allocated, %d not.\n",
         NuOfProc, failed);
  if (failed &&
      !Force)
    {
       fprintf(stderr, "Failed to start %d process(es). Exiting.\n",
              failed);
       stop_processes(stat_pinf);
      exit(1);
    }

  grp_create_channel(stat_pinf[0],
                     stat_pinf[2],
                     GRP_CHAN+0);
  grp_report_channel(GRP_CHAN+0,
                     "Producer", 0, 1,
                     "Buffer", 0, 0);
  grp_create_channel(stat_pinf[2],
                     stat_pinf[1],
                     GRP_CHAN+1);
  grp_report_channel(GRP_CHAN+1,
                     "Buffer", 1, 1,
                     "Consumer", 0, 0);
  grp_create_channel(stat_pinf[1],
                     stat_pinf[2],
                     GRP_CHAN+2);
  grp_report_channel(GRP_CHAN+2,
                     "Consumer", 1, 1,
                     "Buffer", 4, 0);

  /*
     The GRAPNEL main loop starts here.
     The main program polls the pvm for any I/O request.
     If there is no more process the main terminates.
  */

  if (Verbose)
    printf("\n\nPolling for request...\n");

  grp_server(NuOfProc/*, fp*/);

#ifdef PgInstrumented
#ifdef NeedInstrument
  pg_end("buffer");
#endif
#endif
  if (Debug)
    dbg_end();
  if (!NoGRED)
    gred_end(Debug);
}Tpvm_exit(0,0,0);}
