#
# Makefile to handle programs generated by grp2c.
#

# Set prefix to directory where the grp2c package is installed to.
# When grp2c is invoked, -R option can specify this directory.
# ARCHDIR specifies name of architecture dependent derictory where
# some stuffs can be found. It should be a target independent name.

ARCHDIR		= $$PVM_ARCH
#ARCHDIRNAME	= SUN4SOL2
ARCHDIRNAME	= $(shell echo $(ARCHDIR))

prefix		= %s
bindir		= $(prefix)/bin/$(ARCHDIR)
libdir		= $(prefix)/lib/$(ARCHDIR)
includedir	= $(prefix)/include

# Set datadir to directory where makefile templates can be found.
# When grp2c is invoked, -D option can specify this directory.

datadir		= %s

# Include platform specific part of the Makefile rules. Following include
# file should specify at least CC and LIBS macros

include $(datadir)/$(ARCHDIRNAME)/grp2c.pl.mk

# Set installdir to directory where the binaries should be installed to.
# When grp2c is invoked, -I option can specify this directory.

installdir	= %s

SHELL		= /bin/sh
GRP2C		= $(bindir)/grp2c

TARGET		= %s

# Include target specific part

include $(datadir)/grp2c.mk.$(TARGET)

# Special libraries and include paths can be specified here:

USERLIBS	=
USERLIBDIRS	=
USERINCLUDES	=

# Debugger facilities and other stuffs

DBGLIBS		= -lslib
DBGLIBDIRS	= -L$$GRADE_ROOT/lib/$(ARCHDIR)
GREDLIBS	= -lgred
GREDLIBDIRS	= -L$$GRADE_ROOT/lib/$(ARCHDIR)

# Libraries for normal compilation. There are common libraries linked
# to everything and special libs linked to server or clients only

LIBS		= -lnsl -lsocket  -lgrp$(TARGET) $(TARGETLIBS) \
		  $(USERLIBS) $(DBGLIBS) $(GREDLIBS)
LIBSSRV		= -lgrp$(TARGET)_srv
LIBSCL		= -lgrp$(TARGET)_cl
LIBDIRS		= $(USERLIBDIRS) $(TARGETLIBDIRS) -L$(libdir) \
		  $(DBGLIBDIRS) $(GREDLIBDIRS)

# Libraries to produce TAPE-PVM version

LIBS_t		= -lnsl -lsocket  -lgrp$(TARGET)_t $(TARGETLIBS_t) \
		  $(USERLIBS) $(DBGLIBS) $(GREDLIBS)
LIBSSRV_t	= -lgrp$(TARGET)_srv_t
LIBSCL_t	= -lgrp$(TARGET)_cl_t
LIBDIRS_t	= $(USERLIBDIRS) $(TARGETLIBDIRS_t) -L$(libdir) \
		  $(DBGLIBDIRS) $(GREDLIBDIRS)

# Libraries to produce PG-PVM version

LIBS_p		= -lnsl -lsocket  -lgrp$(TARGET)_p $(TARGETLIBS_p) \
		  $(USERLIBS) $(DBGLIBS) $(GREDLIBS)
LIBSSRV_p	= -lgrp$(TARGET)_srv_p
LIBSCL_p	= -lgrp$(TARGET)_cl_p
LIBDIRS_p	= $(USERLIBDIRS) $(TARGETLIBDIRS_p) -L$(libdir) \
		  $(DBGLIBDIRS) $(GREDLIBDIRS)

CPPFLAGS	=  $(TARGETINCLUDES) \
		  -I$(includedir) -I$(includedir)/$(ARCHDIR) \
		  -I$$DDBG_ROOT/include $(USERINCLUDES) -I$$GRADE_ROOT/include
CPPFLAGS_t	=  $(TARGETINCLUDES_t) \
		  -I$(includedir) -I$(includedir)/$(ARCHDIR) \
		  -I$$DDBG_ROOT/include $(USERINCLUDES) -I$$GRADE_ROOT/include
CPPFLAGS_p	=  $(TARGETINCLUDES_p) \
		  -I$(includedir) -I$(includedir)/$(ARCHDIR) \
		  -I$$DDBG_ROOT/include $(USERINCLUDES) -I$$GRADE_ROOT/include
CFLAGS		= $(OPT) -DTARGET=$(TARGET)
