typedef struct adj_node{
   int node;
   struct adj_node *next ;
} adj_node;
 
typedef struct task_node{
    int number ;
    char *label;
    struct task_node *next ; 
} task_node ;


typedef struct exec_node{
  double org_time;  /* original recorded time stamp */
  double adj_time;  /* adjusted time stamp */
  struct exec_node *next; /* next event task on the same process */
  struct exec_node *send; /* points to remote event task for a send */
  char *trace_line; /* PICL trace line describing this event */
} exec_node ;

 
typedef struct post_msg{
   int state;
   int sender ;
   int tag;
   struct post_msg *next ;
   struct exec_node *counter ;
} post_msg ;
 
typedef struct line_node{
   int line ;
   double ftime;
} line_node ;

typedef struct tid_node{
	int tid;
	struct tid_node *next ;
} tid_node;

#define pg_max(A,B)  (((A) > (B)) ? (A) : (B) )
#define pg_abs(A) (((A) < 0 ) ? (-A) : (A) )
#define pg_time_def() ((PG_SEC == -1) ? 0 : 1 )

/**********************/
/* TASK STATUS LABELS */
#define DEAD		0
#define ALIVE		1
#define MURDERED	2


/* Tacyon removal routine */
extern void pg_top_sort( int max_node, struct exec_node *PG_PC[] );

