#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <sys/time.h>
#include "pvm3.h"
#include "pg_pvm.h"
#include "pgtags.h"

static int STID ;
static struct pvmtaskinfo *taskp;

static char
*strip_path( char *prg )
{
char *tmp;
char c;
int i,n;
 
   tmp = (char *)calloc(256,sizeof(char));
   for ( i=0,n=0 ; prg[n] != '\0'; n++ ){
       if ( prg[n] == '/' ){
         i = 0;
         continue ;
       }
       tmp[i] = prg[n];
       ++i;
   }
   tmp[i] = '\0' ;
   return tmp;
}

static int
find_pg_serv( void )
{
int np;
int i;
char *prg;
 
     pvm_mytid();
     pvm_tasks(0,&np,&taskp);
     for (i=0;i<np;i++){
        prg = strip_path(taskp[i].ti_a_out) ;
        if (strcmp(prg,"pg_serv") == 0){
           STID = taskp[i].ti_tid ;
           return 1;
        }
     }
     return 0;
}

static int
process_query( void )
{
int i;
int serv_cmd;
int rtids, tid;
int utasks;
char label[256];
int bufid;
struct timeval tmout;
 
    pvm_initsend(PvmDataDefault);
    serv_cmd = PgQuery;
    pvm_pkint(&serv_cmd,1,1);
    pvm_send(STID,PG_CMDTAG);
 
    tmout.tv_sec = 1;
    tmout.tv_usec = 0;
    /* receive from server */
    if ((bufid=pvm_trecv(STID,PG_CMDTAG,&tmout)) > 0){
       pvm_upkint(&rtids,1,1);
       for(i=0;i<rtids;i++){
          pvm_upkint(&tid,1,1);
       }
       pvm_upkint(&utasks,1,1);
       for(i=0;i<utasks;i++){
          pvm_upkstr(label);
       }
       return rtids ;
    }else{
       return -1;
    }
}

main()
{
int no;

   if ( find_pg_serv() ){
      no = process_query();
      printf("%d",no);
   }else{
      printf("0");
   }
}
