/*
	   Topological sort routine for removing tacyons
		Author: Edward Walker
      Organization: National Supercomputing Research Centre
      Date: April 1996
*/
/************************************************************/
#include <stdio.h>
#include "pg_pvm.h"
#include "pg_serv.h"

static void 
pg_follow_link( struct exec_node *counter, double timestmp, int follow )
{
struct exec_node *count, *recv;

   for ( count=counter; count != NULL; count=count->next ){
      /* update adj time here */
		if ( follow ){
         if ( count->adj_time >= timestmp ) return ;
		}
      count->adj_time = pg_max( count->adj_time, timestmp );
      timestmp = count->adj_time ;
      if ( count->send != NULL ){
         recv = count->send ;
         /* assured communication delay > 1us */
         if ( recv->adj_time < timestmp ){
            pg_follow_link( recv, timestmp+MICRO, 1 );
         }
      }
   }	
}

void 
pg_top_sort(int max_node, struct exec_node *PG_PC[])
{
int node;

   for ( node = 0; node <= max_node; node++ ){
      pg_follow_link(PG_PC[node], 0.0, 0);	 
   }
}

