#include <stdio.h>
#include "pvm3.h"
#include "pg_proto.h"

#define MAXLIST	100009
#define SMALL 2000 /* Since insertion sort is quicker for small values */

static int mytid, parentid, tid;
static char label[256];

void quicksort(int);
void pivot(int *, int, int, int *);
void insert(int *, int, int);

main(int argc, char *argv[])
{
int i=0,j=0, T[MAXLIST];
FILE *df;

mytid = pvm_mytid();
parentid = pvm_parent();
sprintf(label,"%x", mytid);

pg_start("task");
if (parentid < 0) {

	 if (argc != 2) 
	    fprintf(stderr,"Usage:  %s filename\n",argv[0]);
	 else {

	     if ((df = fopen(argv[1],"r")) == 0) {
		     fprintf(stderr," file %s doesn't exist\n",argv[1]);
		     pvm_exit();
			  exit(0);
	     }
	     while (fscanf(df,"%i",&T[j++]) != EOF)
		  {
				if ( j >= MAXLIST ){
					fprintf(stderr,"Error: MAXLIST is too small ! \n");
               pvm_exit();
					exit(0);
				}
		  }
	
	     pvm_spawn("quicksort", (char**)0, 0, "", 1, &tid);
		    
	     i=j-2;
	     pvm_initsend(PvmDataDefault);
	     pvm_pkint( &i, 1, 1);
	     pvm_pkint( T, j-1, 1);
	     pvm_send(tid, 0);
	    
        pg_start("wait");
	     pvm_recv(tid, 0);
	     pvm_upkint( T, j-1, 1);
        pg_end("wait");
	    
        /*
	     fprintf(stderr," The sorted array is :\n");
	     for (i=0; i < j-1; ++i)
		  fprintf(stderr,"%d\n",T[i]);
	     fprintf(stderr,"*** TOTAL = %d\n",j-1);
        */
	 }
}else{
	quicksort(parentid);
}
pg_end("task"); 
pvm_exit();

}

void
quicksort(int parentid)
{
int tids[2];
int j, l, s,*t;
int low_tid, up_tid;
int ntasks;

pvm_recv(parentid, 0);
pvm_upkint( &j, 1, 1);
t = (int*)calloc(j+1, sizeof(int));
pvm_upkint( t, j+1, 1);
	
pivot(t, 0, j, &l);
	
ntasks = 2;
if ( l <= SMALL ) --ntasks;
if (j-l <= SMALL) --ntasks;

if ( ntasks > 0 ){
     pvm_spawn("quicksort", (char**)0, 0, "", ntasks, tids);
     if ( l > SMALL && j-l > SMALL ){ 
        low_tid = tids[0];
        up_tid = tids[1];
     }else if ( l > SMALL ) {
        low_tid = tids[0];
     }else if ( j-1 > SMALL ){
        up_tid = tids[0];
     }
     
}

fprintf(stderr,"After pivot l is %d j is %d\n",l,j);

if (l > SMALL){
   /* pg_start("send_low"); */
	s=l-1;
	pvm_initsend(PvmDataDefault);
	pvm_pkint( &s, 1, 1);
	pvm_pkint( t, s+1, 1);
	pvm_send(low_tid, 0);
   /* pg_end("send_low"); */
}
if (j-l > SMALL){
   /* pg_start("send_up");*/
	s=j-l-1;
	pvm_initsend(PvmDataDefault);
	pvm_pkint( &s, 1, 1);
	pvm_pkint( &t[l+1], s+1, 1);
	pvm_send(up_tid, 0);
   /* pg_end("send_up");*/
}

if (l > SMALL) {
   pg_start("wait_low");
	pvm_recv(low_tid, 0);
	pvm_upkint( t, l, 1);
   pg_end("wait_low");
}else{
   pg_start("sort_low");
   insert(t,0,l-1);
   pg_end("sort_low");
}
if (j-l > SMALL) {
   pg_start("wait_high");
	pvm_recv(up_tid, 0);
	pvm_upkint( &t[l+1], s+1, 1);
   pg_end("wait_high");
}else{
   pg_start("sort_high");
   insert(t,l+1,j);
   pg_end("sort_high");
}
    
pvm_initsend(PvmDataDefault);
pvm_pkint( t, j+1, 1);
pvm_send(parentid, 0);

}

void
pivot(int *t, int i, int j, int *l)
{
int p, k, hold;

p = t[i];
k =i; *l = j+1;
do k++; while (t[k] <= p && k < j);
do (*l)--; while (t[*l] > p);
while (k < *l) {
	hold = t[k];
	t[k] = t[*l];
	t[*l] = hold;
	do k++; while (t[k] <= p);
	do (*l)--; while (t[*l] > p);
}
hold = t[i];
t[i] = t[*l];
t[*l] = hold;

}

void
insert(int *t, int i, int j)
{
int k, x, l;

for (k=i+1; k <= j; k++) {
	x = t[k]; l = k-1;
	while (l > i-1 && x < t[l]) {
	    t[l+1] = t[l];
	    l--;
   }
	t[l+1] = x;
}

}

