#include <stdio.h>
#include <stdlib.h>

#define MAXP	126

static void
CreatePosFile( char *ifile, char *ofile )
{
FILE *ifp, *ofp;
char line[256], type[100];
double x_axis, y_axis;
double x_pos, y_pos;
double x[MAXP], y[MAXP];
int i, max_node=0 ;

    for(i=0;i<MAXP;i++){
       x[i] = 0.0; y[i] = 0.0;
    }
    ifp = fopen(ifile,"r");
    ofp = fopen(ofile,"w");
    while(fgets(line,256,ifp)!=NULL){
        sscanf(line,"%s", type );
        if ( strcmp(type,"graph") == 0 ){
           sscanf(line,"%*s %*f %lf %lf", &x_axis, &y_axis );
        }else if ( strcmp(type,"node") == 0 ){
           sscanf(line,"%*s %d %lf %lf", &i, &x_pos, &y_pos );
           if ( i >= MAXP ) exit(0);
           /* for animation file with x-y borders 0.2 <-> 0.8 */
           x[i] = x_pos/x_axis*(0.8-0.2)+0.2;
           y[i] = ((0.8-0.2)-(y_pos/y_axis*(0.8-0.2)))+0.2;
           if ( i > max_node ) max_node = i ;
        }
    }
    for(i=0;i<=max_node;i++){
       fprintf(ofp,"%lf %lf\n", x[i], y[i] );
    }
    fclose(ifp);
    fclose(ofp);
}

main(int argc,char **argv)
{
char pfile[256];

    if ( argc < 2 ){
        fprintf(stderr,"usage: %s dot_plain_file\n", argv[0] );
    }else{
       strcpy(pfile,argv[1]);
       CreatePosFile(pfile,"pganim"); 
    }   
}
