#include <stdio.h>
#include <stdlib.h>
#include <signal.h>
#include <string.h>
#include <ctype.h>
#include "pvm3.h"
#include "pg_pvm.h"
#include "pgtags.h"

static char input[256] ;
static int STID ;
static struct pvmtaskinfo *taskp;

static char
*strip_path( char *prg )
{
char *tmp;
char c;
int i,n;
 
   tmp = (char *)calloc(256,sizeof(char));
   for ( i=0,n=0 ; prg[n] != '\0'; n++ ){
       if ( prg[n] == '/' ){
         i = 0;
         continue ;
       }
       tmp[i] = prg[n];
       ++i;
   }
   tmp[i] = '\0' ;
   return tmp;
}

static int 
find_pg_serv( void )
{
int np;
int i;
char *prg;

     pvm_mytid();
     pvm_tasks(0,&np,&taskp);
     for (i=0;i<np;i++){
        prg = strip_path(taskp[i].ti_a_out) ;
        if (strcmp(prg,"pg_serv") == 0){
           STID = taskp[i].ti_tid ;
           return 1;
        }
     } 
     return 0;
}

static
readcmd(void)
{
int c;
int flag=0;
int i=0;
 
   while((c=getchar()) != '\n'){
     if ( isalnum(c) ){
        flag = 1;
        input[i++] = (char)c ;
     }else{
        if ( flag ) break ;
     } 
   }
   input[i] = '\0' ;
}

static int
s_query( void )
{
int i;
int serv_cmd;
int rtids, tid;
int utasks;
char label[256];
int bufid;
struct timeval tmout;

    pvm_initsend(PvmDataDefault);
    serv_cmd = PgQuery;
    pvm_pkint(&serv_cmd,1,1);
    pvm_send(STID,PG_CMDTAG);

    tmout.tv_sec = 1;
    tmout.tv_usec = 0;
    /* receive from server */
    if ((bufid=pvm_trecv(STID,PG_CMDTAG,&tmout)) > 0){
       pvm_upkint(&rtids,1,1);
       for(i=0;i<rtids;i++){
          pvm_upkint(&tid,1,1);
       }
       pvm_upkint(&utasks,1,1);
       for(i=0;i<utasks;i++){
          pvm_upkstr(label);
       }
       return rtids ;
    }else{
       return -1;
    }
}

static int 
process_query( void )
{
int i;
int serv_cmd;
int rtids, tid;
int utasks;
char label[256];
struct timeval tmout;

    pvm_initsend(PvmDataDefault);
    serv_cmd = PgQuery;
    pvm_pkint(&serv_cmd,1,1);
    pvm_send(STID,PG_CMDTAG);

    printf("Logging ... \n");
    tmout.tv_sec = 2;
    tmout.tv_usec = 0;
    /* receive from server */
    if ( pvm_trecv(STID,PG_CMDTAG,&tmout) > 0 ){
       pvm_upkint(&rtids,1,1);
       printf("Registered Tasks: %d \n", rtids );
       if ( rtids > 0 ) printf("-> ");
       for(i=0;i<rtids;i++){
          pvm_upkint(&tid,1,1);
          printf("%x ", tid );
       }
       if ( rtids > 0 ) printf("\n");
       pvm_upkint(&utasks,1,1);
       printf("User Tasks: %d\n", utasks );
       if ( utasks > 0 ) printf("-> ");
       for(i=0;i<utasks;i++){
          pvm_upkstr(label);
          printf("%s ", label );
       }
       if ( utasks > 0 ) printf("\n");
   }else{
       printf("quit and try again later dude \n");
   }
}

main(int argc, char **argv)
{
int serv_cmd;
int info ;
struct timeval tmout;
int c;
int query_flag = 0;
int no;

while ( (c=getopt( argc, argv, "s")) != EOF ){
    switch(c){
       case 's':
			 query_flag = 1;
			 break;
	 }
}

if ( find_pg_serv() ){
	if ( query_flag ){
      no = s_query(); 
		printf("%d", no );
	}else{
      printf("PG server %x found ... \n", STID );
      while(1){
         printf("pg_pvm> ");
         readcmd();
         if ( strcmp(input,"quit") == 0 ){
            printf("goodbye \n");
            break ;
         }else if ( strcmp(input,"halt") == 0){
            pvm_initsend(PvmDataDefault);
            serv_cmd = PgHalt ;
            pvm_pkint(&serv_cmd,1,1);
            pvm_send(STID,PG_CMDTAG);
            tmout.tv_sec = 2;
            tmout.tv_usec = 0;
            if ( pvm_trecv(STID,PG_CMDTAG,&tmout) <= 0){
               printf("PG server may not be halted properly dude\n");
               printf("Try to kill it instead ... \n"); 
					pvm_sendsig(STID,SIGKILL);
            }
            break;
         }else if ( strcmp(input,"query") == 0){
            process_query();   
         }else if ( strcmp(input,"help") == 0){
            printf("query - PG server logging activity \n");
            printf("halt - halt PG server \n");
            printf("quit - quit the console \n");
         }
      }
	}
}else{
   if ( query_flag ){
		printf("0");
   }else{
      fprintf(stderr,"PG server not found !\n");
   }
}

pvm_exit();

}
