#include <stdio.h>
#include <stdlib.h>
#include "pvm3.h"
#include "pg_pvm.h"
#include "pgtags.h"

static char *pvm_root;
static char *pvm_arch;
static char *host ;
static struct pvmtaskinfo *taskp ;

static char
*strip_path( char *prg )
{
char *tmp;
char c;
int i,n;
 
   tmp = (char *)calloc(256,sizeof(char));
   for ( i=0,n=0 ; prg[n] != '\0'; n++ ){
       if ( prg[n] == '/' ){
         i = 0;
         continue ;
       }
       tmp[i] = prg[n];
       ++i;
   }
   tmp[i] = '\0' ;
   return tmp;
}

static int
find_pg_serv()
{
int i, np;
int mytid ;
char *prg;

   mytid = pvm_mytid();
   pvm_tasks(0,&np,&taskp);
   for (i=0;i<np;i++){
      prg = strip_path(taskp[i].ti_a_out) ;
      if ( strcmp(prg,"pg_serv") == 0 ){
         return 1;
      } 
   }
   return 0;  
}

main()
{
char cmd[256];
FILE *fp;
int tid;
int info ;

if ( !find_pg_serv() ){
   pvm_root = getenv("PVM_ROOT");
   if ( pvm_root == NULL ){
      fprintf(stderr,"PVM_ROOT must be set! \nexiting ... \n");
      exit(0); 
   }
   /* printf("pvm_root = %s \n", pvm_root ); */
   pvm_arch = getenv("PVM_ARCH"); 
   if ( pvm_arch == NULL ){
      sprintf(cmd,"%s/lib/pvmgetarch", pvm_root );
      fp = popen(cmd,"r");
      pvm_arch = (char *)calloc(256,sizeof(char)); 
      fscanf(fp,"%s", pvm_arch );
      pclose(fp);
   }
   /* printf("pvm_arch = %s \n", pvm_arch ); */
   host = getenv("HOST");
   /* printf("host = %s \n", host ); */
   sprintf(cmd,"%s/pg/lib/%s/pg_serv",pvm_root,pvm_arch);
   info = pvm_spawn(cmd,0,PvmTaskHost,host,1,&tid);
   if ( info != 1 ){
      fprintf(stderr,"PG server not started properly ...\n");
   }else{
      printf("waiting for ACK from server \n");
      pvm_recv(tid,PG_CMDTAG); 
      printf("PG server %x started ... \n", tid );
   }
}else{
   fprintf(stderr,"PG server already started !\n");
}
pvm_exit();
}
