/* TAPE/PVM %W% %G% */

#include <stdlib.h>
#include <stdio.h>
#include <string.h>

/* Programme de mise en place de la trace
*
*    Usage : tapepp [-onom_de_fichier] [-mmasque] [-fnom_de_fichier]
*                   [-Pnb_phase_max] [-Atemps_attente] [-Enb_echange]  source
*
*   -o nom_de_fichier : si on veut donner un nom de fichier specifique en sortie
*   -m masque : masque est un entier, designe le type de trace desiree
*   -f nom_de_fichier : nom de fichier contenant la table des fichiers
*   -P nb_phase_max : nombre maximum de phase
*   -A temps_attente : temps d'attente entre deux echanges pour le calcul des 
*                      coefficients lineaires de l'horloge globale
*   -E nb_echange : nombre d'echange pour le calcul des coefficients lineaires de
*                      l'horloge globale
*
*/

/* default tapepp file table (relative to $HOME) */
#define TAPEDB "/pvm3/tapelib/tapepp.tab"

/* default buffer size (in bytes) */
#define DEFAULTBSIZE 10000

/* default max. number of phases */
#define DEFAULTPHASE 20

/* default delay (secs) between successive exchanges for clock synchro */
#define DEFAULTDELAY 2

/* default number of message exchanges (per phase) for clock synchro */
#define DEFAULTEXCH  15

extern  int taille_buf_defaut;
extern  int masque_util;
extern  int nb_phase_defaut;
extern  int temps_attente_defaut;
extern  int nb_pingpong_defaut;

void aff_aide()
{ printf("\n Bad usage of tapepp \n\n");
  printf("---------------------------------------------------------------------\n");
  printf("-- Syntax  : tapepp [options] source.c                             --\n");
  printf("---------------------------------------------------------------------\n");
  printf("--                                                                 --\n");
  printf("-- Options :                                                       --\n");
  printf("--                                                                 --\n");
  printf("-- -o<file>    use file as output                                  --\n");
  printf("-- -m<mgroups> module group names (ABC...)                         --\n");
  printf("-- -f<dbase>   use dbase as source code data base                  --\n");
  printf("-- -T<size>    use size in bytes as buffer size                    --\n");
  printf("-- -P<nbphas>  max number of phases                                --\n");
  printf("-- -A<delay>   delay (s) between 2 clock synchro. messages         --\n");
  printf("-- -E<nbxchg>  number of message exchanges for clock synchro       --\n");
  printf("--                                                                 --\n");
  printf("---------------------------------------------------------------------\n");
}

int analyse_ligne_commande(int argc,char **argv,char **file_source,
        char **file_dest,char **file_bdf,char **langage)
{	/* renvoi 0 si une erreur */
char *abs_source;
char param_op[80],chaine[40];
char flag_dest,flag_masque,flag_bdf,flag_taillebf,flag_nbphase;
char flag_attente,flag_pingpong;
int i;

   flag_taillebf=0;
   flag_nbphase=0;
   flag_dest=0;
   flag_masque=0;
   flag_bdf=0;
   flag_attente=0;
   flag_pingpong=0;
   if (argc == 1) 
      {    /* pas assez d'arguments */
      aff_aide();
      return 0;
      }
   else
   {
	/* on lit le langage en eliminant le 1er caractere - de l'option */
   /* strcpy((*langage)++,argv[1]); */
   strcpy(*langage,"pvm");

	/* initialisation des variables a leur valeur par defaut */
   if((*file_bdf=getenv("HOME"))==NULL) {
      fprintf(stderr,"environment variable HOME undefined\n");
      exit(2);
    }
   strcat(*file_bdf,TAPEDB);
   masque_util=-1;
   taille_buf_defaut=DEFAULTBSIZE;
   nb_phase_defaut=DEFAULTPHASE;
   temps_attente_defaut=DEFAULTDELAY;
   nb_pingpong_defaut=DEFAULTEXCH;

	/* recuperation du dernier parametre: le nom du fichier source */
   strcpy(*file_source,argv[argc-1]);
	/*fichier destination par defaut avec suffix _t*/
   for(i=strlen(*file_source)-1;(i>=0)&&((*file_source)[i]!='.');i--);
   if((i==-1)||(i==strlen(*file_source)-1)) {
      fprintf(stderr,"unknown file type %s.\n",*file_source);
      exit(1);
    }   
   strcpy(*file_dest,*file_source);
   strcpy(&((*file_dest)[i]),"_t");
   strcat(*file_dest,&((*file_source)[i]));

        /* build absolute name of source file */
   abs_source=malloc(strlen(*file_source));
   if( (abs_source=getenv("PWD"))!=NULL ) {
     strcat(abs_source,"/");
     strcat(abs_source,*file_source);
     *file_source=abs_source;
   }
     
	/* recuperation des parametres optionnels */
   for(i=1;i<(argc-1);i++)
      {
      strcpy(param_op,argv[i]);
      if (param_op[0]!='-')
	 i=argc;
      else
	 {
         switch (param_op[1])
	    {
	    case 'o':
	       if (flag_dest)
		  i=argc;
	       else
		  {
		  strcpy(*file_dest,param_op);
		  *file_dest+=2;
		  flag_dest=1;
		  }
	       break;

	    case 'm':
	       if (flag_masque)
		  i=argc;
	       else
		  {
		  int k=0;
		  char *tmp;
		  strcpy(chaine,param_op);
		  tmp=chaine+2;
		  masque_util=0;
		  for(k=0;k<strlen(tmp);k++)
		    if(isupper(tmp[k]))
		      masque_util |= 1<<tmp[k]-'A';
		    else {
		      masque_util = -1;
		      fprintf(stderr,"tapepp: error in group mask, using default.\n");
		      break;
		    }
                  flag_masque=1;
		  }
	       break;

            case 'f':
	       if (flag_bdf)
		  i=argc;
	       else
		  {
		  strcpy(*file_bdf,param_op);
		  *file_bdf+=2;
		  flag_bdf=1;
		  }
	       break;

            case 'T':
	       if (flag_taillebf)
		  i=argc;
	       else
		  {
		  strcpy(chaine,param_op);
                  taille_buf_defaut=atoi(chaine+2);
                  flag_taillebf=1;
		  }
               break;

            case 'P':
	       if (flag_nbphase)
		  i=argc;
	       else
		  {
		  strcpy(chaine,param_op);
                  nb_phase_defaut=atoi(chaine+2);
                  flag_nbphase=1;
		  }
               break;

            case 'E':
	       if (flag_pingpong)
		  i=argc;
	       else
		  {
		  strcpy(chaine,param_op);
                  nb_pingpong_defaut=atoi(chaine+2);
                  flag_pingpong=1;
		  }
               break;

            case 'A':
	       if (flag_attente)
		  i=argc;
	       else
		  {
		  strcpy(chaine,param_op);
                  temps_attente_defaut=atoi(chaine+2);
                  flag_attente=1;
		  }
               break;
            }
         }
      }
   if (i<argc)
      return 1;
   else
      return 0;
   }
}

