/* TAPE/PVM %W% %G% */

#ifndef _CLOCKSTATS_H_
#define _CLOCKSTATS_H_
 
#define ADDED_OK     -1
#define ADDED_FAILED -2

struct point {   /* sample point for clock synchro */
  double X;      /* time on reference clock */
  double Y;      /* estimated corresponding time on other host */
};

/* res_somme keeps information of per-machine clock statistics */

struct res_somme 
{
int ttid;            /* tid of machine's clock_synchro task */
int dtid;            /* tid of machine's daemon, ADDED_OK, ADDED_FAILED */
char *name;          /* machine's name */
char util;
double SX;           /* statistics for clock synchonization */
double SY;
double SXY;
double SXX;
double SYY;
struct point *win;  /* pointer to the smoothing table (window) */
int *rnk;           /* pointer to the table of ranks */
};

/* coef_corel contains the result of the clock statistics accumulated
   in the corresponding res_somme structure */

struct coef_corel
{
int dtid;           /* tid of machine's daemon */
double pente;       /* drift coefficient (very close to 1) */
double origine;     /* offset coefficient */
double sigma2;
double var_pente;   /* variance on drift */
double var_origine; /* variance on offset */
};

#endif
