/* TAPE/PVM @(#)tape_clock.c	1.1 10/19/94 */
#include <stdio.h>
#include <sys/time.h>

/* the tape_clock routine returns current local time (relative
   to some time basis which is of no importance) in a struct
   timeval.
*/


void tape_clock(struct timeval *tp)


/* default implementation using gettimeofday */

#ifdef DefaultArchitecture
  {
    /* wee keep calling the time function until success */
    while(gettimeofday(tp,0));
  }
#endif



/* IBM RS6000 specific implementation (tested on IBM Sp1 Nodes) */

#ifdef RsArchitecture
  {
    double second();
    double date;
    date=second();
    tp->tv_sec=(int) date;
    tp->tv_usec=(int) ((date - (int)date)*1000000.0);
  }
#endif

/* other specifics go here */
