/* TAPE/PVM %W% %G% */

#include <sys/time.h>

#include "pvm3.h"

#include "tape.h"
#include "tape_globals.h"
#include "tape_events.h"
#include "tape_classes.h"

#define masc_pvm classe_buffer

int Tpvm_mkbuf(int numfile,int numline,int masc,int encoding)
{
int ret;
struct timeval tp;

if((masc&(mselect>>nb_classe))&&(masc_pvm&mselect)) {

  tape_clock(&tp);
  ret=pvm_mkbuf(encoding);

  tape_event(event_mkbuf,taskid,numfile,numline,tp.tv_sec-base_s,tp.tv_usec,
	     "%d %d",ret,encoding);
}
else
  ret=pvm_mkbuf(encoding);

return ret;
}

int Tpvm_freebuf(int numfile,int numline,int masc,int bufid)
{
int ret;
struct timeval tp;

if((masc&(mselect>>nb_classe))&&(masc_pvm&mselect)) {

  tape_clock(&tp);
  ret=pvm_freebuf(bufid);

   tape_event(event_freebuf,taskid,numfile,numline,tp.tv_sec-base_s,tp.tv_usec,
	      "%d %d",ret,bufid);
}
else
  ret=pvm_freebuf(bufid);

return ret;
}

int Tpvm_getsbuf(int numfile,int numline,int masc)
{
int ret;
struct timeval tp;

if((masc&(mselect>>nb_classe))&&(masc_pvm&mselect)) {

  tape_clock(&tp);
  ret=pvm_getsbuf();

  tape_event(event_getsbuf,taskid,numfile,numline,tp.tv_sec-base_s,tp.tv_usec,
	     "%d",ret);
}
else
  ret=pvm_getsbuf();

return ret;
}

int Tpvm_getrbuf(int numfile,int numline,int masc)
{
int ret;
struct timeval tp;

if((masc&(mselect>>nb_classe))&&(masc_pvm&mselect)) {

  tape_clock(&tp);
  ret=pvm_getrbuf();

  tape_event(event_getrbuf,taskid,numfile,numline,tp.tv_sec-base_s,tp.tv_usec,
	     "%d",ret);
}
else
  ret=pvm_getrbuf();

return ret;
}

int Tpvm_setsbuf(int numfile,int numline,int masc,int bufid)
{
int ret;
struct timeval tp;

if((masc&(mselect>>nb_classe))&&(masc_pvm&mselect)) {

  tape_clock(&tp);
  ret=pvm_setsbuf(bufid);

  tape_event(event_setsbuf,taskid,numfile,numline,tp.tv_sec-base_s,tp.tv_usec,
	     "%d %d",ret,bufid);
}
else
  ret=pvm_setsbuf(bufid);

return ret;
}

int Tpvm_setrbuf(int numfile,int numline,int masc,int bufid)
{
int ret;
struct timeval tp;

if((masc&(mselect>>nb_classe))&&(masc_pvm&mselect)) {

  tape_clock(&tp);
  ret=pvm_setrbuf(bufid);

  tape_event(event_setrbuf,taskid,numfile,numline,tp.tv_sec-base_s,tp.tv_usec,
	     "%d %d",ret,bufid);
}
else
  ret=pvm_setrbuf(bufid);

return ret;
}

int Tpvm_initsend( int numfile, int numline, int masc, int encoding )
{
int ret;
struct timeval tp;

if((masc&(mselect>>nb_classe))&&(masc_pvm&mselect)) {

  tape_clock(&tp);
  ret = pvm_initsend (encoding);

  tape_event(event_initsend,taskid,numfile,numline,tp.tv_sec-base_s,tp.tv_usec,
	     "%d %d",ret,encoding);
}
else
  ret = pvm_initsend (encoding);

return ret;
}

