/* TAPE/PVM %W% %G% */

#include <sys/time.h>

#include "pvm3.h"

#include "tape.h"
#include "tape_globals.h"
#include "tape_events.h"
#include "tape_classes.h"

#define masc_pvm classe_group

int Tpvm_barrier( int numfile, int numline, int masc, char *group, int count )
{
int ret;
struct timeval tp,tp2;

if((masc&(mselect>>nb_classe))&&(masc_pvm&mselect))
  {
    tape_clock(&tp);
    
    ret=pvm_barrier(group,count);

    tape_clock(&tp2);
    tape_clockdiff(&tp2,&tp);

    tape_event(event_barrier,taskid,numfile,numline,tp.tv_sec-base_s,tp.tv_usec,
	       "%d %s %d %d %d",ret,group,tp2.tv_sec,tp2.tv_usec,count);
  }
else
  ret=pvm_barrier(group,count);

return ret;
}

int Tpvm_getinst(int numfile,int numline,int masc,char *group,int tid)
{
int ret;
struct timeval tp;

if((masc&(mselect>>nb_classe))&&(masc_pvm&mselect)) {

  tape_clock(&tp);
  ret=pvm_getinst(group,tid);

  tape_event(event_getinst,taskid,numfile,numline,tp.tv_sec-base_s,tp.tv_usec,
	     "%d %s %d",ret,group,tid);
}
else
  ret=pvm_getinst(group,tid);

return ret;
}

int Tpvm_bcast(int numfile,int numline,int masc,char *group,int msgtag)
{
int ret;
int bufid;
int bytes;
struct timeval tp,tp2;

if((masc&(mselect>>nb_classe))&&(masc_pvm&mselect)) {

  tape_clock(&tp);
  ret=pvm_bcast(group,msgtag);

  tape_clock(&tp2);
  tape_clockdiff(&tp2,&tp);

  bufid = pvm_getsbuf();
  pvm_bufinfo(bufid,&bytes,0,0);
  tape_event(event_bcast,taskid,numfile,numline,tp.tv_sec-base_s,tp.tv_usec,
	     "%d %s %d %d %d %d",ret,group,tp2.tv_sec,tp2.tv_usec,msgtag,bytes);
}
else
  ret=pvm_bcast(group,msgtag);

return ret;
}

int Tpvm_gettid(int numfile,int numline,int masc,char *group,int inum)
{
int ret;
struct timeval tp;

if((masc&(mselect>>nb_classe))&&(masc_pvm&mselect)) {

  tape_clock(&tp);
  ret=pvm_gettid(group,inum);

  tape_event(event_gettid,taskid,numfile,numline,tp.tv_sec-base_s,tp.tv_usec,
	     "%d %s %d",ret,group,inum);
}
else
  ret=pvm_gettid(group,inum);

return ret;
}

int Tpvm_gsize(int numfile,int numline,int masc,char *group)
{
int ret;
struct timeval tp;

if((masc&(mselect>>nb_classe))&&(masc_pvm&mselect)) {

  tape_clock(&tp);
  ret=pvm_gsize(group);

  tape_event(event_gsize,taskid,numfile,numline,tp.tv_sec-base_s,tp.tv_usec,
	     "%d %s",ret,group);
}
else
  ret=pvm_gsize(group);

return ret;
}

int Tpvm_joingroup(int numfile, int numline, int masc, char *group)
{
int ret;
struct timeval tp;

if((masc&(mselect>>nb_classe))&&(masc_pvm&mselect)) {

  tape_clock(&tp);
  ret = pvm_joingroup(group);

  tape_event(event_joingroup,taskid,numfile,numline,tp.tv_sec-base_s,tp.tv_usec,
	     "%d %s",ret,group);
}
else
  ret = pvm_joingroup(group);

return ret;
}

int Tpvm_lvgroup(int numfile,int numline,int masc,char *group)
{
int ret;
struct timeval tp;

if((masc&(mselect>>nb_classe))&&(masc_pvm&mselect)) {

  tape_clock(&tp);
  ret = pvm_lvgroup(group);

  tape_event(event_lvgroup,taskid,numfile,numline,tp.tv_sec-base_s,tp.tv_usec,
	     "%d %s",ret,group);
}
else
  ret = pvm_lvgroup(group);

return ret;
}


