/* TAPE/PVM %W% %G% */

#include <sys/time.h>

#include "pvm3.h"

#include "tape.h"
#include "tape_globals.h"
#include "tape_events.h"
#include "tape_classes.h"

#define masc_pvm classe_info

#ifdef pvm3_2_6
#define PVMHOSTINFO hostinfo
#define PVMTASKINFO taskinfo
#else
#define PVMHOSTINFO pvmhostinfo
#define PVMTASKINFO pvmtaskinfo
#endif

int Tpvm_parent(int numfile, int numline, int masc)
{
int ret;
struct timeval tp;

if((masc&(mselect>>nb_classe))&&(masc_pvm&mselect)) {

  tape_clock(&tp);
  ret = pvm_parent ();

  tape_event(event_parent,taskid,numfile,numline,tp.tv_sec-base_s,tp.tv_usec,
	     "%d",ret);
}
else
  ret = pvm_parent ();

return ret;
}

int Tpvm_config(int numfile,int numline,int masc,int *nhostp, int *narchp,
                struct PVMHOSTINFO **hostp )
{
int ret;
struct timeval tp;

if((masc&(mselect>>nb_classe))&&(masc_pvm&mselect)) {

  tape_clock(&tp);
  ret=pvm_config (nhostp,narchp,hostp);

  tape_event(event_config,taskid,numfile,numline,tp.tv_sec-base_s,tp.tv_usec,
	     "%d",ret);
}
else
  ret=pvm_config (nhostp,narchp,hostp);

return ret;
}

int Tpvm_bufinfo(int numfile,int numline,int masc,int mid,int *len,int *code,int
 *tid)
{
int ret;
struct timeval tp;

if((masc&(mselect>>nb_classe))&&(masc_pvm&mselect)) {

  tape_clock(&tp);
  ret = pvm_bufinfo(mid,len,code,tid);

  tape_event(event_bufinfo,taskid,numfile,numline,tp.tv_sec-base_s,tp.tv_usec,
	     "%d %d %d %d %d",ret,mid,*len,*code,*tid);
}
else
  ret = pvm_bufinfo(mid,len,code,tid);

return ret;
}

int Tpvm_getopt(int numfile,int numline,int masc,int what)
{
int ret;
struct timeval tp;

if((masc&(mselect>>nb_classe))&&(masc_pvm&mselect)) {

  tape_clock(&tp);
  ret=pvm_getopt(what);

  tape_event(event_getopt,taskid,numfile,numline,tp.tv_sec-base_s,tp.tv_usec,
	     "%d %d",ret,what);
}
else
  ret=pvm_getopt(what);

return ret;
}

int Tpvm_tasks(int numfile,int numline,int masc,int where,int *ntaskp,struct PVMTASKINFO **taskp)
{
int ret;
struct timeval tp;

if((masc&(mselect>>nb_classe))&&(masc_pvm&mselect)) {

  tape_clock(&tp);
  ret = pvm_tasks(where,ntaskp,taskp);

  tape_event(event_tasks,taskid,numfile,numline,tp.tv_sec-base_s,tp.tv_usec,
	     "%d %d",ret,where);
}
else
  ret = pvm_tasks(where,ntaskp,taskp);

return ret;
}

int Tpvm_pstat(int numfile,int numline,int masc,int tid)
{
struct timeval tp;
int ret;

if ((masc&(mselect>>nb_classe))&&(masc_pvm&mselect)) {

  tape_clock(&tp);
  ret=pvm_pstat(tid);

  tape_event(event_pstat,taskid,numfile,numline,tp.tv_sec-base_s,tp.tv_usec,
	     "%d %d",ret,tid);
}
else
  ret=pvm_pstat(tid);

return(ret);
}

int Tpvm_perror(int numfile,int numline,int masc,char *msg)
{
struct timeval tp;
int ret;

if((masc&(mselect>>nb_classe))&&(masc_pvm&mselect)) {

  tape_clock(&tp);
  ret=pvm_perror(msg);

  tape_event(event_perror,taskid,numfile,numline,tp.tv_sec - base_s,tp.tv_usec,
	     "%d",ret);
}
else
  ret=pvm_perror(msg);

return(ret);
}
